/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.MockTimestampExtractor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PartitionGroupTest {
    private final LogContext logContext = new LogContext("[test] ");
    private final Time time = new MockTime();
    private final Serializer<Integer> intSerializer = new IntegerSerializer();
    private final Deserializer<Integer> intDeserializer = new IntegerDeserializer();
    private final TimestampExtractor timestampExtractor = new MockTimestampExtractor();
    private final TopicPartition unknownPartition = new TopicPartition("unknown-partition", 0);
    private final String errMessage = "Partition " + this.unknownPartition + " not found.";
    private final String[] topics = new String[]{"topic"};
    private final TopicPartition partition1 = this.createPartition1();
    private final TopicPartition partition2 = this.createPartition2();
    private final RecordQueue queue1 = this.createQueue1();
    private final RecordQueue queue2 = this.createQueue2();
    private final byte[] recordValue = this.intSerializer.serialize(null, (Object)10);
    private final byte[] recordKey = this.intSerializer.serialize(null, (Object)1);
    private final Metrics metrics = new Metrics();
    private final MetricName lastLatenessValue = new MetricName("record-lateness-last-value", "", "", Utils.mkMap((Map.Entry[])new Map.Entry[0]));

    private static Sensor getValueSensor(Metrics metrics, MetricName metricName) {
        Sensor lastRecordedValue = metrics.sensor(metricName.name());
        lastRecordedValue.add(metricName, (MeasurableStat)new Value());
        return lastRecordedValue;
    }

    @Test
    public void testTimeTracking() {
        PartitionGroup group = this.getBasicGroup();
        this.testFirstBatch(group);
        this.testSecondBatch(group);
    }

    private RecordQueue createQueue1() {
        return new RecordQueue(this.partition1, new MockSourceNode(this.intDeserializer, this.intDeserializer), this.timestampExtractor, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler(), (InternalProcessorContext)new InternalMockProcessorContext(), this.logContext);
    }

    private RecordQueue createQueue2() {
        return new RecordQueue(this.partition2, new MockSourceNode(this.intDeserializer, this.intDeserializer), this.timestampExtractor, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler(), (InternalProcessorContext)new InternalMockProcessorContext(), this.logContext);
    }

    private TopicPartition createPartition1() {
        return new TopicPartition(this.topics[0], 1);
    }

    private TopicPartition createPartition2() {
        return new TopicPartition(this.topics[0], 2);
    }

    private void testFirstBatch(PartitionGroup group) {
        PartitionGroup.RecordInfo info = new PartitionGroup.RecordInfo();
        MatcherAssert.assertThat((Object)group.numBuffered(), (Matcher)CoreMatchers.is((Object)0));
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list1);
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 2, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 4L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 6L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition2, list2);
        this.verifyBuffered(6, 3, 3, group);
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)group.streamTime(), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        StampedRecord record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)-1L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)2L));
        this.verifyTimes(record, 1L, 1L, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition2));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        this.verifyTimes(record, 2L, 2L, group);
        this.verifyBuffered(4, 2, 2, group);
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
    }

    private void testSecondBatch(PartitionGroup group) {
        PartitionGroup.RecordInfo info = new PartitionGroup.RecordInfo();
        List<ConsumerRecord> list3 = Arrays.asList(new ConsumerRecord("topic", 1, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 4L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list3);
        this.verifyBuffered(6, 4, 2, group);
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)group.streamTime(), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        StampedRecord record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        this.verifyTimes(record, 3L, 3L, group);
        this.verifyBuffered(5, 3, 2, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition2));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)6L));
        this.verifyTimes(record, 4L, 4L, group);
        this.verifyBuffered(4, 3, 1, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)6L));
        this.verifyTimes(record, 5L, 5L, group);
        this.verifyBuffered(3, 2, 1, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition1), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)6L));
        this.verifyTimes(record, 2L, 5L, group);
        this.verifyBuffered(2, 1, 1, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)3.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)4L));
        Assert.assertNull((Object)group.headRecordOffset(this.partition1));
        MatcherAssert.assertThat((Object)group.headRecordOffset(this.partition2), (Matcher)CoreMatchers.is((Object)6L));
        this.verifyTimes(record, 4L, 5L, group);
        this.verifyBuffered(1, 0, 1, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)1.0));
        record = group.nextRecord(info, this.time.milliseconds());
        MatcherAssert.assertThat((Object)info.partition(), (Matcher)Matchers.equalTo((Object)this.partition2));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)CoreMatchers.is((Object)6L));
        Assert.assertNull((Object)group.headRecordOffset(this.partition1));
        Assert.assertNull((Object)group.headRecordOffset(this.partition2));
        this.verifyTimes(record, 6L, 6L, group);
        this.verifyBuffered(0, 0, 0, group);
        MatcherAssert.assertThat((Object)this.metrics.metric(this.lastLatenessValue).metricValue(), (Matcher)CoreMatchers.is((Object)0.0));
    }

    @Test
    public void shouldChooseNextRecordBasedOnHeadTimestamp() {
        PartitionGroup group = this.getBasicGroup();
        Assert.assertEquals((long)0L, (long)group.numBuffered());
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list1);
        this.verifyBuffered(3, 3, 0, group);
        Assert.assertEquals((long)-1L, (long)group.streamTime());
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(this.lastLatenessValue).metricValue());
        PartitionGroup.RecordInfo info = new PartitionGroup.RecordInfo();
        StampedRecord record = group.nextRecord(info, this.time.milliseconds());
        Assert.assertEquals((long)record.timestamp, (long)1L);
        record = group.nextRecord(info, this.time.milliseconds());
        Assert.assertEquals((long)record.timestamp, (long)5L);
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 2, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 4L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 6L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition2, list2);
        record = group.nextRecord(info, this.time.milliseconds());
        Assert.assertEquals((long)record.timestamp, (long)2L);
        record = group.nextRecord(info, this.time.milliseconds());
        Assert.assertEquals((long)record.timestamp, (long)3L);
    }

    private void verifyTimes(StampedRecord record, long recordTime, long streamTime, PartitionGroup group) {
        MatcherAssert.assertThat((Object)record.timestamp, (Matcher)CoreMatchers.is((Object)recordTime));
        MatcherAssert.assertThat((Object)group.streamTime(), (Matcher)CoreMatchers.is((Object)streamTime));
    }

    private void verifyBuffered(int totalBuffered, int partitionOneBuffered, int partitionTwoBuffered, PartitionGroup group) {
        Assert.assertEquals((long)totalBuffered, (long)group.numBuffered());
        Assert.assertEquals((long)partitionOneBuffered, (long)group.numBuffered(this.partition1));
        Assert.assertEquals((long)partitionTwoBuffered, (long)group.numBuffered(this.partition2));
    }

    @Test
    public void shouldSetPartitionTimestampAndStreamTime() {
        PartitionGroup group = this.getBasicGroup();
        group.setPartitionTime(this.partition1, 100L);
        Assert.assertEquals((long)100L, (long)group.partitionTimestamp(this.partition1));
        Assert.assertEquals((long)100L, (long)group.streamTime());
        group.setPartitionTime(this.partition2, 50L);
        Assert.assertEquals((long)50L, (long)group.partitionTimestamp(this.partition2));
        Assert.assertEquals((long)100L, (long)group.streamTime());
    }

    @Test
    public void shouldThrowIllegalStateExceptionUponAddRecordsIfPartitionUnknown() {
        PartitionGroup group = this.getBasicGroup();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> group.addRawRecords(this.unknownPartition, null));
        MatcherAssert.assertThat((Object)this.errMessage, (Matcher)Matchers.equalTo((Object)exception.getMessage()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionUponNumBufferedIfPartitionUnknown() {
        PartitionGroup group = this.getBasicGroup();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> group.numBuffered(this.unknownPartition));
        MatcherAssert.assertThat((Object)this.errMessage, (Matcher)Matchers.equalTo((Object)exception.getMessage()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionUponSetPartitionTimestampIfPartitionUnknown() {
        PartitionGroup group = this.getBasicGroup();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> group.setPartitionTime(this.unknownPartition, 0L));
        MatcherAssert.assertThat((Object)this.errMessage, (Matcher)Matchers.equalTo((Object)exception.getMessage()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionUponGetPartitionTimestampIfPartitionUnknown() {
        PartitionGroup group = this.getBasicGroup();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> group.partitionTimestamp(this.unknownPartition));
        MatcherAssert.assertThat((Object)this.errMessage, (Matcher)Matchers.equalTo((Object)exception.getMessage()));
    }

    @Test
    public void shouldThrowIllegalStateExceptionUponGetHeadRecordOffsetIfPartitionUnknown() {
        PartitionGroup group = this.getBasicGroup();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> group.headRecordOffset(this.unknownPartition));
        MatcherAssert.assertThat((Object)this.errMessage, (Matcher)Matchers.equalTo((Object)exception.getMessage()));
    }

    @Test
    public void shouldEmptyPartitionsOnClear() {
        PartitionGroup group = this.getBasicGroup();
        List<ConsumerRecord> list = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 3L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list);
        group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds());
        group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds());
        group.clear();
        MatcherAssert.assertThat((Object)group.numBuffered(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)group.streamTime(), (Matcher)Matchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds()), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)Matchers.equalTo((Object)-1L));
        group.addRawRecords(this.partition1, list);
    }

    @Test
    public void shouldUpdatePartitionQueuesShrink() {
        PartitionGroup group = this.getBasicGroup();
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list1);
        List<ConsumerRecord> list2 = Arrays.asList(new ConsumerRecord("topic", 2, 2L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 4L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 2, 6L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition2, list2);
        Assert.assertEquals((long)(list1.size() + list2.size()), (long)group.numBuffered());
        Assert.assertTrue((boolean)group.allPartitionsBuffered());
        group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds());
        group.updatePartitions(Utils.mkSet((Object[])new TopicPartition[]{this.createPartition2()}), p -> {
            Assert.fail((String)"should not create any queues");
            return null;
        });
        Assert.assertTrue((boolean)group.allPartitionsBuffered());
        Assert.assertEquals((long)list2.size(), (long)group.numBuffered());
        Assert.assertEquals((long)1L, (long)group.streamTime());
        Assert.assertThrows(IllegalStateException.class, () -> group.partitionTimestamp(this.partition1));
        MatcherAssert.assertThat((Object)group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds()), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)Matchers.equalTo((Object)2L));
    }

    @Test
    public void shouldUpdatePartitionQueuesExpand() {
        PartitionGroup group = new PartitionGroup(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.partition1, (Object)this.queue1)}), PartitionGroupTest.getValueSensor(this.metrics, this.lastLatenessValue));
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list1);
        Assert.assertEquals((long)list1.size(), (long)group.numBuffered());
        Assert.assertTrue((boolean)group.allPartitionsBuffered());
        group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds());
        group.updatePartitions(Utils.mkSet((Object[])new TopicPartition[]{this.createPartition1(), this.createPartition2()}), p -> {
            Assert.assertEquals((Object)this.createPartition2(), (Object)p);
            return this.createQueue2();
        });
        Assert.assertFalse((boolean)group.allPartitionsBuffered());
        Assert.assertEquals((long)1L, (long)group.numBuffered());
        Assert.assertEquals((long)1L, (long)group.streamTime());
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition1), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)Matchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds()), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void shouldUpdatePartitionQueuesShrinkAndExpand() {
        PartitionGroup group = new PartitionGroup(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.partition1, (Object)this.queue1)}), PartitionGroupTest.getValueSensor(this.metrics, this.lastLatenessValue));
        List<ConsumerRecord> list1 = Arrays.asList(new ConsumerRecord("topic", 1, 1L, (Object)this.recordKey, (Object)this.recordValue), new ConsumerRecord("topic", 1, 5L, (Object)this.recordKey, (Object)this.recordValue));
        group.addRawRecords(this.partition1, list1);
        Assert.assertEquals((long)list1.size(), (long)group.numBuffered());
        Assert.assertTrue((boolean)group.allPartitionsBuffered());
        group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds());
        group.updatePartitions(Utils.mkSet((Object[])new TopicPartition[]{this.createPartition2()}), p -> {
            Assert.assertEquals((Object)this.createPartition2(), (Object)p);
            return this.createQueue2();
        });
        Assert.assertFalse((boolean)group.allPartitionsBuffered());
        Assert.assertEquals((long)0L, (long)group.numBuffered());
        Assert.assertEquals((long)1L, (long)group.streamTime());
        Assert.assertThrows(IllegalStateException.class, () -> group.partitionTimestamp(this.partition1));
        MatcherAssert.assertThat((Object)group.partitionTimestamp(this.partition2), (Matcher)Matchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)group.nextRecord(new PartitionGroup.RecordInfo(), this.time.milliseconds()), (Matcher)Matchers.nullValue());
    }

    private PartitionGroup getBasicGroup() {
        return new PartitionGroup(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.partition1, (Object)this.queue1), Utils.mkEntry((Object)this.partition2, (Object)this.queue2)}), PartitionGroupTest.getValueSensor(this.metrics, this.lastLatenessValue));
    }
}

