/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ForwardingDisabledProcessorContextTest {
    @Mock(value=MockType.NICE)
    private ProcessorContext delegate;
    private ForwardingDisabledProcessorContext context;

    @Before
    public void setUp() {
        this.context = new ForwardingDisabledProcessorContext(this.delegate);
    }

    @Test
    public void shouldThrowOnForward() {
        Assert.assertThrows(StreamsException.class, () -> this.context.forward((Object)"key", (Object)"value"));
    }

    @Test
    public void shouldThrowOnForwardWithTo() {
        Assert.assertThrows(StreamsException.class, () -> this.context.forward((Object)"key", (Object)"value", To.all()));
    }

    @Test
    public void shouldThrowOnForwardWithChildIndex() {
        Assert.assertThrows(StreamsException.class, () -> this.context.forward((Object)"key", (Object)"value", 1));
    }

    @Test
    public void shouldThrowOnForwardWithChildName() {
        Assert.assertThrows(StreamsException.class, () -> this.context.forward((Object)"key", (Object)"value", "child1"));
    }
}

