/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeKeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.NextIteratorFunction;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyWindowStore<K, V>
implements ReadOnlyWindowStore<K, V> {
    private final QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType;
    private final String storeName;
    private final StateStoreProvider provider;

    public CompositeReadOnlyWindowStore(StateStoreProvider provider, QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType, String storeName) {
        this.provider = provider;
        this.windowStoreType = windowStoreType;
        this.storeName = storeName;
    }

    @Override
    public V fetch(K key, long time) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                V result = windowStore.fetch(key, time);
                if (result == null) continue;
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                WindowStoreIterator<V> result = windowStore.fetch(key, timeFrom, timeTo);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return KeyValueIterators.emptyWindowStoreIterator();
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetch(key, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "from")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "to")));
    }

    @Override
    public WindowStoreIterator<V> backwardFetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                WindowStoreIterator<V> result = windowStore.backwardFetch(key, timeFrom, timeTo);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return KeyValueIterators.emptyWindowStoreIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        Objects.requireNonNull(keyFrom, "from can't be null");
        Objects.requireNonNull(keyTo, "to can't be null");
        NextIteratorFunction nextIteratorFunction = store -> store.fetch(keyFrom, keyTo, timeFrom, timeTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetch(keyFrom, keyTo, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        Objects.requireNonNull(keyFrom, "keyFrom can't be null");
        Objects.requireNonNull(keyTo, "keyTo can't be null");
        NextIteratorFunction nextIteratorFunction = store -> store.backwardFetch(keyFrom, keyTo, timeFrom, timeTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        NextIteratorFunction nextIteratorFunction = ReadOnlyWindowStore::all;
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardAll() {
        NextIteratorFunction nextIteratorFunction = ReadOnlyWindowStore::backwardAll;
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    @Deprecated
    public KeyValueIterator<Windowed<K>, V> fetchAll(long timeFrom, long timeTo) {
        NextIteratorFunction nextIteratorFunction = store -> store.fetchAll(timeFrom, timeTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetchAll(ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "from")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "to")));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> backwardFetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        NextIteratorFunction nextIteratorFunction = store -> store.backwardFetchAll(timeFrom, timeTo);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }
}

