/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;

public class StaticMemberTestClient {
    private static String testName = "StaticMemberTestClient";

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println(testName + " requires one argument (properties-file) but none provided: ");
        }
        System.out.println("StreamsTest instance started");
        String propFileName = args[0];
        Properties streamsProperties = Utils.loadProps((String)propFileName);
        String groupInstanceId = Objects.requireNonNull(streamsProperties.getProperty("group.instance.id"));
        System.out.println(testName + " instance started with group.instance.id " + groupInstanceId);
        System.out.println("props=" + streamsProperties);
        System.out.flush();
        StreamsBuilder builder = new StreamsBuilder();
        String inputTopic = (String)Objects.requireNonNull(streamsProperties.remove("input.topic"));
        KStream dataStream = builder.stream(inputTopic);
        dataStream.peek((k, v) -> System.out.println(String.format("PROCESSED key=%s value=%s", k, v)));
        Properties config = new Properties();
        config.setProperty("application.id", testName);
        config.put("commit.interval.ms", (Object)1000);
        config.putAll((Map<?, ?>)streamsProperties);
        KafkaStreams streams = new KafkaStreams(builder.build(), config);
        streams.setStateListener((newState, oldState) -> {
            if (oldState == KafkaStreams.State.REBALANCING && newState == KafkaStreams.State.RUNNING) {
                System.out.println("REBALANCING -> RUNNING");
                System.out.flush();
            }
        });
        streams.start();
        Exit.addShutdownHook((String)"streams-shutdown-hook", () -> {
            System.out.println("closing Kafka Streams instance");
            System.out.flush();
            streams.close();
            System.out.println("Static membership test closed");
            System.out.flush();
        });
    }
}

