/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.NoOpWindowStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WrappingStoreProviderTest {
    private WrappingStoreProvider wrappingStoreProvider;
    private final int numStateStorePartitions = 2;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        StateStoreProviderStub stubProviderTwo = new StateStoreProviderStub(false);
        for (int partition = 0; partition < 2; ++partition) {
            stubProviderOne.addStore("kv", partition, Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"kv"), (Serde)Serdes.serdeFrom(String.class), (Serde)Serdes.serdeFrom(String.class)).build());
            stubProviderOne.addStore("window", partition, new NoOpWindowStore());
            this.wrappingStoreProvider = new WrappingStoreProvider(Arrays.asList(new StreamThreadStateStoreProvider[]{stubProviderOne, stubProviderTwo}), StoreQueryParameters.fromNameAndType((String)"kv", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        }
    }

    @Test
    public void shouldFindKeyValueStores() {
        List results = this.wrappingStoreProvider.stores("kv", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldFindWindowStores() {
        this.wrappingStoreProvider.setStoreQueryParameters(StoreQueryParameters.fromNameAndType((String)"window", (QueryableStoreType)QueryableStoreTypes.windowStore()));
        List windowStores = this.wrappingStoreProvider.stores("window", QueryableStoreTypes.windowStore());
        Assert.assertEquals((long)2L, (long)windowStores.size());
    }

    @Test
    public void shouldThrowInvalidStoreExceptionIfNoStoreOfTypeFound() {
        this.wrappingStoreProvider.setStoreQueryParameters(StoreQueryParameters.fromNameAndType((String)"doesn't exist", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.wrappingStoreProvider.stores("doesn't exist", QueryableStoreTypes.keyValueStore()));
    }

    @Test
    public void shouldReturnAllStoreWhenQueryWithoutPartition() {
        this.wrappingStoreProvider.setStoreQueryParameters(StoreQueryParameters.fromNameAndType((String)"kv", (QueryableStoreType)QueryableStoreTypes.keyValueStore()));
        List results = this.wrappingStoreProvider.stores("kv", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldReturnSingleStoreWhenQueryWithPartition() {
        this.wrappingStoreProvider.setStoreQueryParameters(StoreQueryParameters.fromNameAndType((String)"kv", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(1)));
        List results = this.wrappingStoreProvider.stores("kv", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)1L, (long)results.size());
    }
}

