/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.TimestampedWindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowToTimestampedWindowByteStoreAdapter;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class TimestampedWindowStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private WindowBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private RocksDBTimestampedWindowStore inner;
    private TimestampedWindowStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.expect((Object)this.supplier.metricsScope()).andReturn((Object)"metricScope");
        EasyMock.expect((Object)this.inner.persistent()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.supplier, this.inner});
        this.builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        TimestampedWindowStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        TimestampedWindowStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldNotWrapTimestampedByteStore() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBTimestampedWindowStore((SegmentedBytesStore)new RocksDBTimestampedSegmentedBytesStore("name", "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedWindowStore.class));
    }

    @Test
    public void shouldWrapPlainKeyValueStoreAsTimestampStore() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBWindowStore((SegmentedBytesStore)new RocksDBSegmentedBytesStore("name", "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(WindowToTimestampedWindowByteStoreAdapter.class));
    }

    @Test
    public void shouldDisableCachingWithRetainDuplicates() {
        this.supplier = Stores.persistentTimestampedWindowStore((String)"name", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L), (boolean)true);
        StoreBuilder builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()).withCachingEnabled();
        builder.build();
        Assert.assertFalse((boolean)((AbstractStoreBuilder)builder).enableCaching);
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBTimestampedWindowStore((SegmentedBytesStore)new RocksDBTimestampedSegmentedBytesStore("name", null, 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"storeSupplier's metricsScope can't be null"));
    }
}

