/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractSessionBytesStoreTest;
import org.apache.kafka.streams.state.internals.RocksDbSessionBytesStoreSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RocksDBSessionStoreTest
extends AbstractSessionBytesStoreTest {
    private static final String STORE_NAME = "rocksDB session store";

    @Override
    <K, V> SessionStore<K, V> buildSessionStore(long retentionPeriod, Serde<K> keySerde, Serde<V> valueSerde) {
        return (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod)), keySerde, valueSerde).build();
    }

    @Override
    String getMetricsScope() {
        return new RocksDbSessionBytesStoreSupplier(null, 0L).metricsScope();
    }

    @Test
    public void shouldRemoveExpired() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 60000L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 60000L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 120000L)), (Object)4L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, Long.MAX_VALUE);){
            Assert.assertEquals(StreamsTestUtils.valuesToSet(iterator), new HashSet<Long>(Arrays.asList(2L, 3L, 4L)));
        }
    }
}

