/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlyKeyValueStoreTest {
    private final String storeName = "my-store";
    private StateStoreProviderStub stubProviderTwo;
    private KeyValueStore<String, String> stubOneUnderlying;
    private KeyValueStore<String, String> otherUnderlyingStore;
    private CompositeReadOnlyKeyValueStore<String, String> theStore;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.stubOneUnderlying = this.newStoreInstance();
        stubProviderOne.addStore("my-store", (StateStore)this.stubOneUnderlying);
        this.otherUnderlyingStore = this.newStoreInstance();
        stubProviderOne.addStore("other-store", (StateStore)this.otherUnderlyingStore);
        this.theStore = new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(new StreamThreadStateStoreProvider[]{stubProviderOne, this.stubProviderTwo}), StoreQueryParameters.fromNameAndType((String)"my-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())), QueryableStoreTypes.keyValueStore(), "my-store");
    }

    private KeyValueStore<String, String> newStoreInstance() {
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"my-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        InternalMockProcessorContext context = new InternalMockProcessorContext(new StateSerdes(ProcessorStateManager.storeChangelogTopic((String)"appId", (String)"my-store"), Serdes.String(), Serdes.String()), new MockRecordCollector());
        context.setTime(1L);
        store.init((StateStoreContext)context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldReturnNullIfKeyDoesNotExist() {
        Assert.assertNull((Object)this.theStore.get((Object)"whatever"));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        Assert.assertThrows(NullPointerException.class, () -> {
            String cfr_ignored_0 = (String)this.theStore.get(null);
        });
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.range(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.range((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPrefixScanNullPrefix() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.prefixScan(null, (Serializer)new StringSerializer()));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPrefixScanNullPrefixKeySerializer() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.prefixScan((Object)"aa", null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnReverseRangeNullFromKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.reverseRange(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnReverseRangeNullToKey() {
        Assert.assertThrows(NullPointerException.class, () -> this.theStore.reverseRange((Object)"from", null));
    }

    @Test
    public void shouldReturnValueIfExists() {
        this.stubOneUnderlying.put((Object)"key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)this.theStore.get((Object)"key"));
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() {
        this.otherUnderlyingStore.put((Object)"otherKey", (Object)"otherValue");
        Assert.assertNull((Object)this.theStore.get((Object)"otherKey"));
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhileNext() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        keyValueIterator.next();
        Assert.assertThrows(NoSuchElementException.class, () -> keyValueIterator.next());
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhilePeekNext() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        keyValueIterator.next();
        Assert.assertThrows(NoSuchElementException.class, () -> ((KeyValueIterator)keyValueIterator).peekNextKey());
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhileNextForPrefixScan() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.prefixScan((Object)"a", (Serializer)new StringSerializer());
        keyValueIterator.next();
        Assert.assertThrows(NoSuchElementException.class, () -> keyValueIterator.next());
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhilePeekNextForPrefixScan() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.prefixScan((Object)"a", (Serializer)new StringSerializer());
        keyValueIterator.next();
        Assert.assertThrows(NoSuchElementException.class, () -> ((KeyValueIterator)keyValueIterator).peekNextKey());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRemove() {
        KeyValueIterator keyValueIterator = this.theStore.all();
        Assert.assertThrows(UnsupportedOperationException.class, () -> keyValueIterator.remove());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileReverseRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        this.stubOneUnderlying.put((Object)"b", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.reverseRange((Object)"a", (Object)"b");
        Assert.assertThrows(UnsupportedOperationException.class, () -> keyValueIterator.remove());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        this.stubOneUnderlying.put((Object)"b", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.range((Object)"a", (Object)"b");
        Assert.assertThrows(UnsupportedOperationException.class, () -> keyValueIterator.remove());
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhilePrefixScan() {
        this.stubOneUnderlying.put((Object)"a", (Object)"1");
        this.stubOneUnderlying.put((Object)"b", (Object)"1");
        KeyValueIterator keyValueIterator = this.theStore.prefixScan((Object)"a", (Serializer)new StringSerializer());
        Assert.assertThrows(UnsupportedOperationException.class, () -> keyValueIterator.remove());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        cache.put((Object)"key-two", (Object)"key-two-value");
        this.stubOneUnderlying.put((Object)"key-one", (Object)"key-one-value");
        Assert.assertEquals((Object)"key-two-value", (Object)this.theStore.get((Object)"key-two"));
        Assert.assertEquals((Object)"key-one-value", (Object)this.theStore.get((Object)"key-one"));
    }

    @Test
    public void shouldSupportRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"c", (Object)"c");
        List results = StreamsTestUtils.toList(this.theStore.range((Object)"a", (Object)"b"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldSupportReverseRange() {
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"c", (Object)"c");
        List results = StreamsTestUtils.toList(this.theStore.reverseRange((Object)"a", (Object)"b"));
        Assert.assertArrayEquals((Object[])Arrays.asList(new KeyValue((Object)"b", (Object)"b"), new KeyValue((Object)"a", (Object)"a")).toArray(), (Object[])results.toArray());
    }

    @Test
    public void shouldReturnKeysWithGivenPrefixExcludingNextKeyLargestKey() {
        this.stubOneUnderlying.put((Object)"abc", (Object)"a");
        this.stubOneUnderlying.put((Object)"abcd", (Object)"b");
        this.stubOneUnderlying.put((Object)"abce", (Object)"c");
        List results = StreamsTestUtils.toList(this.theStore.prefixScan((Object)"abcd", (Serializer)new StringSerializer()));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"abcd", (Object)"b")));
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void shouldSupportPrefixScan() {
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"aa", (Object)"b");
        this.stubOneUnderlying.put((Object)"b", (Object)"c");
        List results = StreamsTestUtils.toList(this.theStore.prefixScan((Object)"a", (Serializer)new StringSerializer()));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"aa", (Object)"b")));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldSupportRangeAcrossMultipleKVStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.range((Object)"a", (Object)"e"));
        Assert.assertArrayEquals((Object[])Arrays.asList(new KeyValue((Object)"a", (Object)"a"), new KeyValue((Object)"b", (Object)"b"), new KeyValue((Object)"c", (Object)"c"), new KeyValue((Object)"d", (Object)"d")).toArray(), (Object[])results.toArray());
    }

    @Test
    public void shouldSupportPrefixScanAcrossMultipleKVStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"aa", (Object)"c");
        cache.put((Object)"ab", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.prefixScan((Object)"a", (Serializer)new StringSerializer()));
        Assert.assertArrayEquals((Object[])Arrays.asList(new KeyValue((Object)"a", (Object)"a"), new KeyValue((Object)"aa", (Object)"c"), new KeyValue((Object)"ab", (Object)"d")).toArray(), (Object[])results.toArray());
    }

    @Test
    public void shouldSupportReverseRangeAcrossMultipleKVStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.reverseRange((Object)"a", (Object)"e"));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void shouldSupportAllAcrossMultipleStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.all());
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"x", (Object)"x")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"z", (Object)"z")));
        Assert.assertEquals((long)6L, (long)results.size());
    }

    @Test
    public void shouldSupportReverseAllAcrossMultipleStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        List results = StreamsTestUtils.toList(this.theStore.reverseAll());
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"a", (Object)"a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"b", (Object)"b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"c", (Object)"c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"d", (Object)"d")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"x", (Object)"x")));
        Assert.assertTrue((boolean)results.contains(new KeyValue((Object)"z", (Object)"z")));
        Assert.assertEquals((long)6L, (long)results.size());
    }

    @Test
    public void shouldThrowInvalidStoreExceptionDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().get((Object)"anything"));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnApproximateNumEntriesDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().approximateNumEntries());
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnRangeDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().range((Object)"anything", (Object)"something"));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnReverseRangeDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().reverseRange((Object)"anything", (Object)"something"));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnPrefixScanDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().prefixScan((Object)"anything", (Serializer)new StringSerializer()));
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnAllDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().all());
    }

    @Test
    public void shouldThrowInvalidStoreExceptionOnReverseAllDuringRebalance() {
        Assert.assertThrows(InvalidStateStoreException.class, () -> this.rebalancing().reverseAll());
    }

    @Test
    public void shouldGetApproximateEntriesAcrossAllStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", (StateStore)cache);
        this.stubOneUnderlying.put((Object)"a", (Object)"a");
        this.stubOneUnderlying.put((Object)"b", (Object)"b");
        this.stubOneUnderlying.put((Object)"z", (Object)"z");
        cache.put((Object)"c", (Object)"c");
        cache.put((Object)"d", (Object)"d");
        cache.put((Object)"x", (Object)"x");
        Assert.assertEquals((long)6L, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnOverflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubOneUnderlying.put((Object)"overflow", (Object)"me");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnUnderflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubProviderTwo.addStore("my-storeA", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    private CompositeReadOnlyKeyValueStore<Object, Object> rebalancing() {
        return new CompositeReadOnlyKeyValueStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true)), StoreQueryParameters.fromNameAndType((String)"my-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore())), QueryableStoreTypes.keyValueStore(), "my-store");
    }
}

