/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowsTest {
    private static final long ANY_SIZE = 123L;

    @Test
    public void shouldSetWindowSize() {
        Assert.assertEquals((long)123L, (long)TimeWindows.of((Duration)Duration.ofMillis((long)123L)).sizeMs);
    }

    @Test
    public void shouldSetWindowAdvance() {
        long anyAdvance = 4L;
        Assert.assertEquals((long)4L, (long)TimeWindows.of((Duration)Duration.ofMillis((long)123L)).advanceBy((Duration)Duration.ofMillis((long)4L)).advanceMs);
    }

    @Test
    public void shouldSetWindowRetentionTime() {
        Assert.assertEquals((long)123L, (long)TimeWindows.of((Duration)Duration.ofMillis(123L)).until(123L).maintainMs());
    }

    @Test
    public void shouldUseWindowSizeAsRetentionTimeIfWindowSizeIsLargerThanDefaultRetentionTime() {
        long windowSize = 2L * TimeWindows.of((Duration)Duration.ofMillis(1L)).maintainMs();
        Assert.assertEquals((long)windowSize, (long)TimeWindows.of((Duration)Duration.ofMillis(windowSize)).maintainMs());
    }

    @Test
    public void shouldUseWindowSizeAndGraceAsRetentionTimeIfBothCombinedAreLargerThanDefaultRetentionTime() {
        Duration windowsSize = Duration.ofDays(1L).minus(Duration.ofMillis(1L));
        Duration gracePeriod = Duration.ofMillis(2L);
        Assert.assertEquals((long)(windowsSize.toMillis() + gracePeriod.toMillis()), (long)TimeWindows.of((Duration)windowsSize).grace(gracePeriod).maintainMs());
    }

    @Test
    public void shouldUseDefaultRetentionTimeWithDefaultGracePeriod() {
        long windowSize1 = TimeWindows.of((Duration)Duration.ofMillis(1L)).maintainMs();
        long windowSize2 = TimeWindows.of((Duration)Duration.ofMillis(43200000L)).maintainMs();
        Assert.assertEquals((long)windowSize1, (long)86400000L);
        Assert.assertEquals((long)windowSize2, (long)86400000L);
    }

    @Test
    public void windowSizeMustNotBeZero() {
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeWindows.of((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void windowSizeMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeWindows.of((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void advanceIntervalMustNotBeZero() {
        TimeWindows windowSpec = TimeWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(0L));
            Assert.fail((String)"should not accept zero advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void advanceIntervalMustNotBeNegative() {
        TimeWindows windowSpec = TimeWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negative advance parameter");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Deprecated
    @Test
    public void advanceIntervalMustNotBeLargerThanWindowSize() {
        TimeWindows windowSpec = TimeWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.advanceBy(Duration.ofMillis(124L));
            Assert.fail((String)"should not accept advance greater than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Deprecated
    @Test
    public void retentionTimeMustNoBeSmallerThanWindowSize() {
        TimeWindows windowSpec = TimeWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.until(122L);
            Assert.fail((String)"should not accept retention time smaller than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(0L));
        try {
            TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void gracePeriodShouldBeDefaultRetentionTimeMinusWindowSize() {
        long expectedDefaultRetentionTime = 86400000L;
        Assert.assertEquals((long)86399997L, (long)TimeWindows.of((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)TimeWindows.of((Duration)Duration.ofMillis(86400000L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)TimeWindows.of((Duration)Duration.ofMillis(86400001L)).gracePeriodMs());
    }

    @Test
    public void shouldComputeWindowsForHoppingWindows() {
        TimeWindows windows = TimeWindows.of((Duration)Duration.ofMillis(12L)).advanceBy(Duration.ofMillis(5L));
        Map matched = windows.windowsFor(21L);
        Assert.assertEquals((long)3L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(10L, 22L), matched.get(10L));
        Assert.assertEquals((Object)new TimeWindow(15L, 27L), matched.get(15L));
        Assert.assertEquals((Object)new TimeWindow(20L, 32L), matched.get(20L));
    }

    @Test
    public void shouldComputeWindowsForBarelyOverlappingHoppingWindows() {
        TimeWindows windows = TimeWindows.of((Duration)Duration.ofMillis(6L)).advanceBy(Duration.ofMillis(5L));
        Map matched = windows.windowsFor(7L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(5L, 11L), matched.get(5L));
    }

    @Test
    public void shouldComputeWindowsForTumblingWindows() {
        TimeWindows windows = TimeWindows.of((Duration)Duration.ofMillis(12L));
        Map matched = windows.windowsFor(21L);
        Assert.assertEquals((long)1L, (long)matched.size());
        Assert.assertEquals((Object)new TimeWindow(12L, 24L), matched.get(12L));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)), TimeWindows.of((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(1L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(4L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(4L)));
        EqualityCheck.verifyEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)).grace(Duration.ofMillis(1L)).grace(Duration.ofMillis(4L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)).grace(Duration.ofMillis(1L)).grace(Duration.ofMillis(4L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(9L)), TimeWindows.of((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(2L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(9L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(4L)));
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(4L)).advanceBy(Duration.ofMillis(2L)).grace(Duration.ofMillis(2L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)).grace(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(1L)).grace(Duration.ofMillis(2L)), TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)).grace(Duration.ofMillis(2L)));
        Assert.assertNotEquals((Object)TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)).grace(Duration.ofMillis(1L)), (Object)TimeWindows.of((Duration)Duration.ofMillis(3L)).advanceBy(Duration.ofMillis(2L)).grace(Duration.ofMillis(2L)));
    }
}

