/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeWindowedSerializerTest {
    private final TimeWindowedSerializer<?> timeWindowedSerializer = new TimeWindowedSerializer();
    private final Map<String, String> props = new HashMap<String, String>();

    @Before
    public void setUp() {
        this.props.put("default.windowed.key.serde.inner", Serdes.StringSerde.class.getName());
        this.props.put("default.windowed.value.serde.inner", Serdes.ByteArraySerde.class.getName());
    }

    @Test
    public void testWindowedKeySerializerNoArgConstructors() {
        this.timeWindowedSerializer.configure(this.props, true);
        Serializer inner = this.timeWindowedSerializer.innerSerializer();
        Assert.assertNotNull((String)"Inner serializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner serializer type should be StringSerializer", (boolean)(inner instanceof StringSerializer));
    }

    @Test
    public void testWindowedValueSerializerNoArgConstructors() {
        this.timeWindowedSerializer.configure(this.props, false);
        Serializer inner = this.timeWindowedSerializer.innerSerializer();
        Assert.assertNotNull((String)"Inner serializer should be not null", (Object)inner);
        Assert.assertTrue((String)"Inner serializer type should be ByteArraySerializer", (boolean)(inner instanceof ByteArraySerializer));
    }
}

