/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.junit.Assert;
import org.junit.Test;

public class JoinWindowsTest {
    private static final long ANY_SIZE = 123L;
    private static final long ANY_OTHER_SIZE = 456L;

    @Test
    public void validWindows() {
        JoinWindows.of((Duration)Duration.ofMillis(456L)).before(Duration.ofMillis(123L)).before(Duration.ofMillis(0L)).before(Duration.ofMillis(-123L)).before(Duration.ofMillis(-456L));
        JoinWindows.of((Duration)Duration.ofMillis(456L)).after(Duration.ofMillis(123L)).after(Duration.ofMillis(0L)).after(Duration.ofMillis(-123L)).after(Duration.ofMillis(-456L));
    }

    @Test
    public void timeDifferenceMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> JoinWindows.of((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void endTimeShouldNotBeBeforeStart() {
        JoinWindows windowSpec = JoinWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.after(Duration.ofMillis(-124L));
            Assert.fail((String)"window end time should not be before window start time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void startTimeShouldNotBeAfterEnd() {
        JoinWindows windowSpec = JoinWindows.of((Duration)Duration.ofMillis(123L));
        try {
            windowSpec.before(Duration.ofMillis(-124L));
            Assert.fail((String)"window start time should not be after window end time");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void untilShouldSetGraceDuration() {
        JoinWindows windowSpec = JoinWindows.of((Duration)Duration.ofMillis(123L));
        long windowSize = windowSpec.size();
        Assert.assertEquals((long)windowSize, (long)windowSpec.grace(Duration.ofMillis(windowSize)).gracePeriodMs());
    }

    @Test
    public void shouldUseWindowSizeAsRetentionTimeIfWindowSizeIsLargerThanDefaultRetentionTime() {
        long windowSize = 2L * JoinWindows.of((Duration)Duration.ofMillis(1L)).maintainMs();
        Assert.assertEquals((long)(2L * windowSize), (long)JoinWindows.of((Duration)Duration.ofMillis(windowSize)).maintainMs());
    }

    @Test
    public void shouldUseWindowSizeAndGraceAsRetentionTimeIfBothCombinedAreLargerThanDefaultRetentionTime() {
        Duration windowsSize = Duration.ofDays(1L).minus(Duration.ofMillis(1L));
        Duration gracePeriod = Duration.ofMillis(2L);
        Assert.assertEquals((long)(2L * windowsSize.toMillis()), (long)JoinWindows.of((Duration)windowsSize).grace(gracePeriod).maintainMs());
    }

    @Deprecated
    @Test
    public void retentionTimeMustNoBeSmallerThanWindowSize() {
        JoinWindows windowSpec = JoinWindows.of((Duration)Duration.ofMillis(123L));
        long windowSize = windowSpec.size();
        try {
            windowSpec.until(windowSize - 1L);
            Assert.fail((String)"should not accept retention time smaller than window size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldUseDefaultRetentionTimeWithDefaultGracePeriod() {
        long windowSize1 = JoinWindows.of((Duration)Duration.ofMillis(1L)).maintainMs();
        long windowSize2 = JoinWindows.of((Duration)Duration.ofMillis(43200000L)).maintainMs();
        Assert.assertEquals((long)windowSize1, (long)86400000L);
        Assert.assertEquals((long)windowSize2, (long)86400000L);
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(0L));
        try {
            JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void gracePeriodShouldBeDefaultRetentionTimeMinusWindowSize() {
        long expectedDefaultRetentionTime = 86400000L;
        Assert.assertEquals((long)86399997L, (long)TimeWindows.of((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)TimeWindows.of((Duration)Duration.ofMillis(86400000L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)TimeWindows.of((Duration)Duration.ofMillis(86400001L)).gracePeriodMs());
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)), JoinWindows.of((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(2L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(2L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)));
        EqualityCheck.verifyEquality(JoinWindows.of((Duration)Duration.ofMillis(9L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(9L)), JoinWindows.of((Duration)Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(9L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).after(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(9L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(9L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(2L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(90L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(60L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(9L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(9L)).grace(Duration.ofMillis(3L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)));
        EqualityCheck.verifyInEquality(JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(9L)), JoinWindows.of((Duration)Duration.ofMillis(3L)).before(Duration.ofMillis(1L)).after(Duration.ofMillis(2L)).grace(Duration.ofMillis(3L)));
    }
}

