/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.state.HostInfo;
import org.junit.Assert;
import org.junit.Test;

public class AssignmentInfoTest {
    private final List<TaskId> activeTasks = Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_0);
    private final Map<TaskId, Set<TopicPartition>> standbyTasks = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});
    private final Map<HostInfo, Set<TopicPartition>> activeAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new HostInfo("localhost", 8088), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0", 0), new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)new HostInfo("localhost", 8089), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t0", 1), new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});
    private final Map<HostInfo, Set<TopicPartition>> standbyAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)new HostInfo("localhost", 8088), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 0), new TopicPartition("t2", 0)})), Utils.mkEntry((Object)new HostInfo("localhost", 8089), (Object)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("t1", 1), new TopicPartition("t2", 1)}))});

    @Test
    public void shouldUseLatestSupportedVersionByDefault() {
        AssignmentInfo info = new AssignmentInfo(9, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assert.assertEquals((long)9L, (long)info.version());
    }

    @Test
    public void shouldThrowForUnknownVersion1() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new AssignmentInfo(0, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0));
    }

    @Test
    public void shouldThrowForUnknownVersion2() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new AssignmentInfo(10, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0));
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        AssignmentInfo info = new AssignmentInfo(1, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(1, -1, this.activeTasks, this.standbyTasks, Collections.emptyMap(), Collections.emptyMap(), 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        AssignmentInfo info = new AssignmentInfo(2, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(2, -1, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion3() {
        AssignmentInfo info = new AssignmentInfo(3, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        AssignmentInfo expectedInfo = new AssignmentInfo(3, 9, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 0);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion4() {
        AssignmentInfo info = new AssignmentInfo(4, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(4, 9, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion5() {
        AssignmentInfo info = new AssignmentInfo(5, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(5, 9, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion6() {
        AssignmentInfo info = new AssignmentInfo(6, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(6, 9, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeVersion7() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(7, 9, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldEncodeAndDecodeSmallerCommonlySupportedVersion() {
        int usedVersion = 5;
        int commonlySupportedVersion = 5;
        AssignmentInfo info = new AssignmentInfo(5, 5, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 2);
        AssignmentInfo expectedInfo = new AssignmentInfo(5, 5, this.activeTasks, this.standbyTasks, this.activeAssignment, Collections.emptyMap(), 2);
        Assert.assertEquals((Object)expectedInfo, (Object)AssignmentInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void nextRebalanceTimeShouldBeMaxValueByDefault() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assert.assertEquals((long)info.nextRebalanceMs(), (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldDecodeDefaultNextRebalanceTime() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        Assert.assertEquals((long)info.nextRebalanceMs(), (long)Long.MAX_VALUE);
    }

    @Test
    public void shouldEncodeAndDecodeNextRebalanceTime() {
        AssignmentInfo info = new AssignmentInfo(7, this.activeTasks, this.standbyTasks, this.activeAssignment, this.standbyAssignment, 0);
        info.setNextRebalanceTime(1000L);
        Assert.assertEquals((long)1000L, (long)AssignmentInfo.decode((ByteBuffer)info.encode()).nextRebalanceMs());
    }
}

