/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreSupplier;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;

public class Materialized<K, V, S extends StateStore> {
    protected StoreSupplier<S> storeSupplier;
    protected String storeName;
    protected Serde<V> valueSerde;
    protected Serde<K> keySerde;
    protected boolean loggingEnabled = true;
    protected boolean cachingEnabled = true;
    protected Map<String, String> topicConfig = new HashMap<String, String>();
    protected Duration retention;

    private Materialized(StoreSupplier<S> storeSupplier) {
        this.storeSupplier = storeSupplier;
    }

    private Materialized(String storeName) {
        this.storeName = storeName;
    }

    protected Materialized(Materialized<K, V, S> materialized) {
        this.storeSupplier = materialized.storeSupplier;
        this.storeName = materialized.storeName;
        this.keySerde = materialized.keySerde;
        this.valueSerde = materialized.valueSerde;
        this.loggingEnabled = materialized.loggingEnabled;
        this.cachingEnabled = materialized.cachingEnabled;
        this.topicConfig = materialized.topicConfig;
        this.retention = materialized.retention;
    }

    public static <K, V, S extends StateStore> Materialized<K, V, S> as(String storeName) {
        Named.validate(storeName);
        return new Materialized<K, V, S>(storeName);
    }

    public static <K, V> Materialized<K, V, WindowStore<Bytes, byte[]>> as(WindowBytesStoreSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier can't be null");
        return new Materialized<K, V, WindowStore<Bytes, byte[]>>(supplier);
    }

    public static <K, V> Materialized<K, V, SessionStore<Bytes, byte[]>> as(SessionBytesStoreSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier can't be null");
        return new Materialized<K, V, SessionStore<Bytes, byte[]>>(supplier);
    }

    public static <K, V> Materialized<K, V, KeyValueStore<Bytes, byte[]>> as(KeyValueBytesStoreSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier can't be null");
        return new Materialized<K, V, KeyValueStore<Bytes, byte[]>>(supplier);
    }

    public static <K, V, S extends StateStore> Materialized<K, V, S> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Materialized<K, V, S>((String)null).withKeySerde(keySerde).withValueSerde(valueSerde);
    }

    public Materialized<K, V, S> withValueSerde(Serde<V> valueSerde) {
        this.valueSerde = valueSerde;
        return this;
    }

    public Materialized<K, V, S> withKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
        return this;
    }

    public Materialized<K, V, S> withLoggingEnabled(Map<String, String> config) {
        this.loggingEnabled = true;
        this.topicConfig = config;
        return this;
    }

    public Materialized<K, V, S> withLoggingDisabled() {
        this.loggingEnabled = false;
        this.topicConfig.clear();
        return this;
    }

    public Materialized<K, V, S> withCachingEnabled() {
        this.cachingEnabled = true;
        return this;
    }

    public Materialized<K, V, S> withCachingDisabled() {
        this.cachingEnabled = false;
        return this;
    }

    public Materialized<K, V, S> withRetention(Duration retention) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(retention, "retention");
        long retenationMs = ApiUtils.validateMillisecondDuration(retention, msgPrefix);
        if (retenationMs < 0L) {
            throw new IllegalArgumentException("Retention must not be negative.");
        }
        this.retention = retention;
        return this;
    }
}

