/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.test.MockApiProcessor;
import org.junit.Assert;

public class MockApiProcessorSupplier<KIn, VIn, KOut, VOut>
implements ProcessorSupplier<KIn, VIn, KOut, VOut> {
    private final long scheduleInterval;
    private final PunctuationType punctuationType;
    private final List<MockApiProcessor<KIn, VIn, KOut, VOut>> processors = new ArrayList<MockApiProcessor<KIn, VIn, KOut, VOut>>();

    public MockApiProcessorSupplier() {
        this(-1L);
    }

    public MockApiProcessorSupplier(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockApiProcessorSupplier(long scheduleInterval, PunctuationType punctuationType) {
        this.scheduleInterval = scheduleInterval;
        this.punctuationType = punctuationType;
    }

    public Processor<KIn, VIn, KOut, VOut> get() {
        MockApiProcessor processor = new MockApiProcessor(this.punctuationType, this.scheduleInterval);
        this.processors.add(processor);
        return processor;
    }

    public MockApiProcessor<KIn, VIn, KOut, VOut> theCapturedProcessor() {
        return this.capturedProcessors(1).get(0);
    }

    public int capturedProcessorsCount() {
        return this.processors.size();
    }

    public List<MockApiProcessor<KIn, VIn, KOut, VOut>> capturedProcessors(int expectedNumberOfProcessors) {
        Assert.assertEquals((long)expectedNumberOfProcessors, (long)this.processors.size());
        return this.processors;
    }
}

