/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.SerdeThatDoesntHandleNull;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MeteredWindowStoreTest {
    private static final String STORE_TYPE = "scope";
    private static final String STORE_LEVEL_GROUP_FROM_0100_TO_24 = "stream-scope-state-metrics";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String THREAD_ID_TAG_KEY_FROM_0100_TO_24 = "client-id";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String STORE_NAME = "mocked-store";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final int WINDOW_SIZE_MS = 10;
    private static final long TIMESTAMP = 42L;
    private final String threadId = Thread.currentThread().getName();
    private InternalMockProcessorContext context;
    private final WindowStore<Bytes, byte[]> innerStoreMock = (WindowStore)EasyMock.createNiceMock(WindowStore.class);
    private MeteredWindowStore<String, String> store = new MeteredWindowStore(this.innerStoreMock, 10L, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new SerdeThatDoesntHandleNull());
    private final Metrics metrics = new Metrics(new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG));
    private String storeLevelGroup;
    private String threadIdTagKey;
    private Map<String, String> tags;
    @Parameterized.Parameter
    public String builtInMetricsVersion;

    public MeteredWindowStoreTest() {
        EasyMock.expect((Object)this.innerStoreMock.name()).andReturn((Object)STORE_NAME).anyTimes();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"latest"}, {"0.10.0-2.4"});
    }

    @Before
    public void setUp() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, "test", this.builtInMetricsVersion, (Time)new MockTime());
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), streamsMetrics, new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, streamsMetrics));
        this.storeLevelGroup = "0.10.0-2.4".equals(this.builtInMetricsVersion) ? STORE_LEVEL_GROUP_FROM_0100_TO_24 : STORE_LEVEL_GROUP;
        this.threadIdTagKey = "0.10.0-2.4".equals(this.builtInMetricsVersion) ? THREAD_ID_TAG_KEY_FROM_0100_TO_24 : THREAD_ID_TAG_KEY;
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.threadIdTagKey, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.context.taskId().toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        WindowStore inner = (WindowStore)EasyMock.mock(WindowStore.class);
        MeteredWindowStore outer = new MeteredWindowStore(inner, 10L, STORE_TYPE, (Time)new MockTime(), Serdes.String(), (Serde)new SerdeThatDoesntHandleNull());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner});
        outer.init((ProcessorContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldDelegateInit() {
        WindowStore inner = (WindowStore)EasyMock.mock(WindowStore.class);
        MeteredWindowStore outer = new MeteredWindowStore(inner, 10L, STORE_TYPE, (Time)new MockTime(), Serdes.String(), (Serde)new SerdeThatDoesntHandleNull());
        EasyMock.expect((Object)inner.name()).andStubReturn((Object)"store");
        inner.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{inner});
        outer.init((StateStoreContext)this.context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{inner});
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.context.addChangelogForStore(STORE_NAME, CHANGELOG_TOPIC);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)this.context.applicationId(), (String)STORE_NAME);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)EasyMock.niceMock(Serde.class);
        Serializer keySerializer = (Serializer)EasyMock.mock(Serializer.class);
        Serde valueSerde = (Serde)EasyMock.niceMock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)EasyMock.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)EasyMock.mock(Serializer.class);
        EasyMock.expect((Object)keySerde.serializer()).andStubReturn((Object)keySerializer);
        EasyMock.expect((Object)keySerializer.serialize(topic, (Object)KEY)).andStubReturn((Object)KEY.getBytes());
        EasyMock.expect((Object)valueSerde.deserializer()).andStubReturn((Object)valueDeserializer);
        EasyMock.expect((Object)valueDeserializer.deserialize(topic, VALUE_BYTES)).andStubReturn((Object)VALUE);
        EasyMock.expect((Object)valueSerde.serializer()).andStubReturn((Object)valueSerializer);
        EasyMock.expect((Object)valueSerializer.serialize(topic, (Object)VALUE)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)KEY_BYTES, 42L)).andStubReturn((Object)VALUE_BYTES);
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock, keySerializer, keySerde, valueDeserializer, valueSerializer, valueSerde});
        this.store = new MeteredWindowStore(this.innerStoreMock, 10L, STORE_TYPE, (Time)new MockTime(), keySerde, valueSerde);
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.fetch((Object)KEY, 42L);
        this.store.put((Object)KEY, (Object)VALUE, 42L);
        EasyMock.verify((Object[])new Object[]{keySerializer, valueDeserializer, valueSerializer});
    }

    @Test
    public void testMetrics() {
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", this.storeLevelGroup, this.threadIdTagKey, this.threadId, this.context.taskId().toString(), STORE_TYPE, STORE_NAME)));
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", this.storeLevelGroup, this.threadIdTagKey, this.threadId, this.context.taskId().toString(), STORE_TYPE, "all")));
        }
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() {
        this.innerStoreMock.init((StateStoreContext)this.context, this.store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        Map metrics = this.context.metrics().metrics();
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "restore-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", STORE_NAME)).metricValue());
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "restore-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", "all")).metricValue());
        }
    }

    @Test
    public void shouldRecordPutLatency() {
        byte[] bytes = "a".getBytes();
        this.innerStoreMock.put(EasyMock.eq((Object)Bytes.wrap((byte[])bytes)), EasyMock.anyObject(), EasyMock.eq((long)this.context.timestamp()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.put((Object)"a", (Object)"a");
        Map metrics = this.context.metrics().metrics();
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "put-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", STORE_NAME)).metricValue());
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "put-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", "all")).metricValue());
        }
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFetchLatency() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), 1L, 1L)).andReturn((Object)KeyValueIterators.emptyWindowStoreIterator());
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.fetch((Object)"a", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(1L)).close();
        Map metrics = this.context.metrics().metrics();
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", STORE_NAME)).metricValue());
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", "all")).metricValue());
        }
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFetchRangeLatency() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), (Object)Bytes.wrap((byte[])"b".getBytes()), 1L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.fetch((Object)"a", (Object)"b", Instant.ofEpochMilli(1L), Instant.ofEpochMilli(1L)).close();
        Map metrics = this.context.metrics().metrics();
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", STORE_NAME)).metricValue());
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "fetch-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", "all")).metricValue());
        }
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRecordFlushLatency() {
        this.innerStoreMock.flush();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.flush();
        Map metrics = this.context.metrics().metrics();
        if ("0.10.0-2.4".equals(this.builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "flush-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", STORE_NAME)).metricValue());
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByNameFilterByTags(metrics, "flush-total", this.storeLevelGroup, Collections.singletonMap("scope-state-id", "all")).metricValue());
        }
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfFetchReturnsNull() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), 0L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        Assert.assertNull((Object)this.store.fetch((Object)"a", 0L));
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        CachedWindowStore cachedWindowStore = (CachedWindowStore)EasyMock.mock(CachedWindowStore.class);
        EasyMock.expect((Object)cachedWindowStore.setFlushListener((CacheFlushListener)EasyMock.anyObject(CacheFlushListener.class), EasyMock.eq((boolean)false))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{cachedWindowStore});
        MeteredWindowStore metered = new MeteredWindowStore((WindowStore)cachedWindowStore, 10L, STORE_TYPE, (Time)new MockTime(), Serdes.String(), (Serde)new SerdeThatDoesntHandleNull());
        Assert.assertTrue((boolean)metered.setFlushListener(null, false));
        EasyMock.verify((Object[])new Object[]{cachedWindowStore});
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        Assert.assertFalse((boolean)this.store.setFlushListener(null, false));
    }

    @Test
    public void shouldCloseUnderlyingStore() {
        this.innerStoreMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        this.store.close();
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.innerStoreMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.store.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        this.innerStoreMock.close();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Oops!"));
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((StateStoreContext)this.context, this.store);
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThrows(RuntimeException.class, () -> this.store.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(this.storeLevelGroup) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedWindowStore
    extends WindowStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

