/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.errors.LogAndFailExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.internals.GlobalStateManager;
import org.apache.kafka.streams.processor.internals.GlobalStateUpdateTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.ProcessorTopologyFactories;
import org.apache.kafka.streams.processor.internals.testutil.ConsumerRecordUtil;
import org.apache.kafka.test.GlobalStateManagerStub;
import org.apache.kafka.test.MockProcessorNode;
import org.apache.kafka.test.MockSourceNode;
import org.apache.kafka.test.NoOpProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalStateTaskTest {
    private final LogContext logContext = new LogContext();
    private final String topic1 = "t1";
    private final String topic2 = "t2";
    private final TopicPartition t1 = new TopicPartition("t1", 1);
    private final TopicPartition t2 = new TopicPartition("t2", 1);
    private final MockSourceNode<String, String, ?, ?> sourceOne = new MockSourceNode(new StringDeserializer(), new StringDeserializer());
    private final MockSourceNode<Integer, Integer, ?, ?> sourceTwo = new MockSourceNode(new IntegerDeserializer(), new IntegerDeserializer());
    private final MockProcessorNode<?, ?, ?, ?> processorOne = new MockProcessorNode();
    private final MockProcessorNode<?, ?, ?, ?> processorTwo = new MockProcessorNode();
    private final Map<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
    private File testDirectory = TestUtils.tempDirectory((String)"global-store");
    private final NoOpProcessorContext context = new NoOpProcessorContext();
    private ProcessorTopology topology;
    private GlobalStateManagerStub stateMgr;
    private GlobalStateUpdateTask globalStateTask;

    @Before
    public void before() {
        Set storeNames = Utils.mkSet((Object[])new String[]{"t1-store", "t2-store"});
        HashMap sourceByTopics = new HashMap();
        sourceByTopics.put("t1", this.sourceOne);
        sourceByTopics.put("t2", this.sourceTwo);
        HashMap<String, String> storeToTopic = new HashMap<String, String>();
        storeToTopic.put("t1-store", "t1");
        storeToTopic.put("t2-store", "t2");
        this.topology = ProcessorTopologyFactories.with(Arrays.asList(new ProcessorNode[]{this.sourceOne, this.sourceTwo, this.processorOne, this.processorTwo}), sourceByTopics, Collections.emptyList(), storeToTopic);
        this.offsets.put(this.t1, 50L);
        this.offsets.put(this.t2, 100L);
        this.stateMgr = new GlobalStateManagerStub(storeNames, this.offsets, this.testDirectory);
        this.globalStateTask = new GlobalStateUpdateTask(this.logContext, this.topology, (InternalProcessorContext)this.context, (GlobalStateManager)this.stateMgr, (DeserializationExceptionHandler)new LogAndFailExceptionHandler());
    }

    @Test
    public void shouldInitializeStateManager() {
        Map startingOffsets = this.globalStateTask.initialize();
        Assert.assertTrue((boolean)this.stateMgr.initialized);
        Assert.assertEquals(this.offsets, (Object)startingOffsets);
    }

    @Test
    public void shouldInitializeContext() {
        this.globalStateTask.initialize();
        Assert.assertTrue((boolean)this.context.initialized);
    }

    @Test
    public void shouldInitializeProcessorTopology() {
        this.globalStateTask.initialize();
        Assert.assertTrue((boolean)this.sourceOne.initialized);
        Assert.assertTrue((boolean)this.sourceTwo.initialized);
        Assert.assertTrue((boolean)this.processorOne.initialized);
        Assert.assertTrue((boolean)this.processorTwo.initialized);
    }

    @Test
    public void shouldProcessRecordsForTopic() {
        this.globalStateTask.initialize();
        this.globalStateTask.update(ConsumerRecordUtil.record("t1", 1, 1L, "foo".getBytes(), "bar".getBytes()));
        Assert.assertEquals((long)1L, (long)this.sourceOne.numReceived);
        Assert.assertEquals((long)0L, (long)this.sourceTwo.numReceived);
    }

    @Test
    public void shouldProcessRecordsForOtherTopic() {
        byte[] integerBytes = new IntegerSerializer().serialize("foo", Integer.valueOf(1));
        this.globalStateTask.initialize();
        this.globalStateTask.update(ConsumerRecordUtil.record("t2", 1, 1L, integerBytes, integerBytes));
        Assert.assertEquals((long)1L, (long)this.sourceTwo.numReceived);
        Assert.assertEquals((long)0L, (long)this.sourceOne.numReceived);
    }

    private void maybeDeserialize(GlobalStateUpdateTask globalStateTask, byte[] key, byte[] recordValue, boolean failExpected) {
        block3: {
            ConsumerRecord record = new ConsumerRecord("t2", 1, 1L, 0L, TimestampType.CREATE_TIME, 0L, 0, 0, (Object)key, (Object)recordValue);
            globalStateTask.initialize();
            try {
                globalStateTask.update(record);
                if (failExpected) {
                    Assert.fail((String)"Should have failed to deserialize.");
                }
            }
            catch (StreamsException e) {
                if (failExpected) break block3;
                Assert.fail((String)"Shouldn't have failed to deserialize.");
            }
        }
    }

    @Test
    public void shouldThrowStreamsExceptionWhenKeyDeserializationFails() {
        byte[] key = new LongSerializer().serialize("t2", Long.valueOf(1L));
        byte[] recordValue = new IntegerSerializer().serialize("t2", Integer.valueOf(10));
        this.maybeDeserialize(this.globalStateTask, key, recordValue, true);
    }

    @Test
    public void shouldThrowStreamsExceptionWhenValueDeserializationFails() {
        byte[] key = new IntegerSerializer().serialize("t2", Integer.valueOf(1));
        byte[] recordValue = new LongSerializer().serialize("t2", Long.valueOf(10L));
        this.maybeDeserialize(this.globalStateTask, key, recordValue, true);
    }

    @Test
    public void shouldNotThrowStreamsExceptionWhenKeyDeserializationFailsWithSkipHandler() {
        GlobalStateUpdateTask globalStateTask2 = new GlobalStateUpdateTask(this.logContext, this.topology, (InternalProcessorContext)this.context, (GlobalStateManager)this.stateMgr, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler());
        byte[] key = new LongSerializer().serialize("t2", Long.valueOf(1L));
        byte[] recordValue = new IntegerSerializer().serialize("t2", Integer.valueOf(10));
        this.maybeDeserialize(globalStateTask2, key, recordValue, false);
    }

    @Test
    public void shouldNotThrowStreamsExceptionWhenValueDeserializationFails() {
        GlobalStateUpdateTask globalStateTask2 = new GlobalStateUpdateTask(this.logContext, this.topology, (InternalProcessorContext)this.context, (GlobalStateManager)this.stateMgr, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler());
        byte[] key = new IntegerSerializer().serialize("t2", Integer.valueOf(1));
        byte[] recordValue = new LongSerializer().serialize("t2", Long.valueOf(10L));
        this.maybeDeserialize(globalStateTask2, key, recordValue, false);
    }

    @Test
    public void shouldFlushStateManagerWithOffsets() {
        HashMap<TopicPartition, Long> expectedOffsets = new HashMap<TopicPartition, Long>();
        expectedOffsets.put(this.t1, 52L);
        expectedOffsets.put(this.t2, 100L);
        this.globalStateTask.initialize();
        this.globalStateTask.update(ConsumerRecordUtil.record("t1", 1, 51L, "foo".getBytes(), "foo".getBytes()));
        this.globalStateTask.flushState();
        Assert.assertEquals(expectedOffsets, this.stateMgr.changelogOffsets());
    }

    @Test
    public void shouldCheckpointOffsetsWhenStateIsFlushed() {
        HashMap<TopicPartition, Long> expectedOffsets = new HashMap<TopicPartition, Long>();
        expectedOffsets.put(this.t1, 102L);
        expectedOffsets.put(this.t2, 100L);
        this.globalStateTask.initialize();
        this.globalStateTask.update(ConsumerRecordUtil.record("t1", 1, 101L, "foo".getBytes(), "foo".getBytes()));
        this.globalStateTask.flushState();
        MatcherAssert.assertThat(this.stateMgr.changelogOffsets(), (Matcher)CoreMatchers.equalTo(expectedOffsets));
    }

    @Test
    public void shouldWipeGlobalStateDirectory() throws Exception {
        Assert.assertTrue((boolean)this.stateMgr.baseDir().exists());
        this.globalStateTask.close(true);
        Assert.assertFalse((boolean)this.stateMgr.baseDir().exists());
    }
}

