/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.TimeWindowedCogroupedKStream;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.FullTimeWindowedSerde;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KGroupedStreamImpl;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.RocksDbWindowBytesStoreSupplier;

public class TimeWindowedCogroupedKStreamImpl<K, V, W extends Window>
extends AbstractStream<K, V>
implements TimeWindowedCogroupedKStream<K, V> {
    private final Windows<W> windows;
    private final CogroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns;

    TimeWindowedCogroupedKStreamImpl(Windows<W> windows, InternalStreamsBuilder builder, Set<String> subTopologySourceNodes, String name, CogroupedStreamAggregateBuilder<K, V> aggregateBuilder, StreamsGraphNode streamsGraphNode, Map<KGroupedStreamImpl<K, ?>, Aggregator<? super K, ? super Object, V>> groupPatterns) {
        super(name, null, null, subTopologySourceNodes, streamsGraphNode, builder);
        this.windows = windows;
        this.aggregateBuilder = aggregateBuilder;
        this.groupPatterns = groupPatterns;
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer) {
        return this.aggregate(initializer, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Named named) {
        return this.aggregate(initializer, named, Materialized.with(null, null));
    }

    @Override
    public KTable<Windowed<K>, V> aggregate(Initializer<V> initializer, Named named, Materialized<K, V, WindowStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(named, "named can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, WindowStore<Bytes, byte[]>>(materialized, this.builder, "COGROUPKSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(this.groupPatterns, initializer, new NamedInternal(named), (StoreBuilder<?>)this.materialize(materializedInternal), materializedInternal.keySerde() != null ? new FullTimeWindowedSerde<K>(materializedInternal.keySerde(), this.windows.size()) : null, materializedInternal.valueSerde(), materializedInternal.queryableStoreName(), this.windows);
    }

    private StoreBuilder<TimestampedWindowStore<K, V>> materialize(MaterializedInternal<K, V, WindowStore<Bytes, byte[]>> materialized) {
        WindowBytesStoreSupplier supplier = (WindowBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            if (materialized.retention() != null) {
                long retentionPeriod = materialized.retention().toMillis();
                if (this.windows.size() + this.windows.gracePeriodMs() > retentionPeriod) {
                    throw new IllegalArgumentException("The retention period of the window store " + this.name + " must be no smaller than its window size plus the grace period. Got size=[" + this.windows.size() + "], grace=[" + this.windows.gracePeriodMs() + "], retention=[" + retentionPeriod + "]");
                }
                supplier = Stores.persistentTimestampedWindowStore(materialized.storeName(), Duration.ofMillis(retentionPeriod), Duration.ofMillis(this.windows.size()), false);
            } else {
                if (this.windows.size() + this.windows.gracePeriodMs() > this.windows.maintainMs()) {
                    throw new IllegalArgumentException("The retention period of the window store " + this.name + " must be no smaller than its window size plus the grace period. Got size=[" + this.windows.size() + "], grace=[" + this.windows.gracePeriodMs() + "], retention=[" + this.windows.maintainMs() + "]");
                }
                supplier = new RocksDbWindowBytesStoreSupplier(materialized.storeName(), this.windows.maintainMs(), Math.max(this.windows.maintainMs() / (long)(this.windows.segments - 1), 60000L), this.windows.size(), false, true);
            }
        }
        StoreBuilder<TimestampedWindowStore<K, V>> builder = Stores.timestampedWindowStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }
}

