/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.TaskMovement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TaskMovementTest {
    @Test
    public void shouldAssignTasksToClientsAndReturnFalseWhenAllClientsCaughtUp() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        Set allTasks = Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2});
        HashMap<TaskId, SortedSet> tasksToCaughtUpClients = new HashMap<TaskId, SortedSet>();
        for (TaskId task : allTasks) {
            tasksToCaughtUpClients.put(task, Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_1, AssignmentTestUtils.UUID_2, AssignmentTestUtils.UUID_3}));
        }
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0));
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1));
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2));
        MatcherAssert.assertThat((Object)TaskMovement.assignActiveTaskMovements(tasksToCaughtUpClients, AssignmentTestUtils.getClientStatesMap(client1, client2, client3), new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldAssignAllTasksToClientsAndReturnFalseIfNoClientsAreCaughtUp() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0));
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1));
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Arrays.asList(AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_2));
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_0, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_1, Collections.emptySortedSet()), Utils.mkEntry((Object)AssignmentTestUtils.TASK_1_2, Collections.emptySortedSet())});
        MatcherAssert.assertThat((Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, AssignmentTestUtils.getClientStatesMap(client1, client2, client3), new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldMoveTasksToCaughtUpClientsAndAssignWarmupReplicasInTheirPlace() {
        int maxWarmupReplicas = Integer.MAX_VALUE;
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_0));
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_1));
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_2));
        Map<UUID, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_1})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_3})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_2}))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(Integer.MAX_VALUE)), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
    }

    @Test
    public void shouldOnlyGetUpToMaxWarmupReplicasAndReturnTrue() {
        boolean maxWarmupReplicas = true;
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_0));
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_1));
        ClientState client3 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_2));
        Map<UUID, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2, client3);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_1})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_1, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_3})), Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_2, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_2}))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(1)), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        try {
            MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1})));
            MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        }
        catch (AssertionError ignored) {
            MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
            MatcherAssert.assertThat((Object)client3, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2})));
        }
    }

    @Test
    public void shouldNotCountPreviousStandbyTasksTowardsMaxWarmupReplicas() {
        boolean maxWarmupReplicas = false;
        ClientState client1 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.emptyList());
        client1.assignStandby(AssignmentTestUtils.TASK_0_0);
        ClientState client2 = TaskMovementTest.getClientStateWithActiveAssignment(Collections.singletonList(AssignmentTestUtils.TASK_0_0));
        Map<UUID, ClientState> clientStates = AssignmentTestUtils.getClientStatesMap(client1, client2);
        Map tasksToCaughtUpClients = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSortedSet((Comparable[])new UUID[]{AssignmentTestUtils.UUID_1}))});
        MatcherAssert.assertThat((String)"should have assigned movements", (Object)TaskMovement.assignActiveTaskMovements((Map)tasksToCaughtUpClients, clientStates, new TreeMap(), (AtomicInteger)new AtomicInteger(0)), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("activeTasks", ClientState::activeTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client1, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new Object[0])));
        MatcherAssert.assertThat((Object)client2, AssignmentTestUtils.hasProperty("standbyTasks", ClientState::standbyTasks, Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0})));
    }

    private static ClientState getClientStateWithActiveAssignment(Collection<TaskId> activeTasks) {
        ClientState client1 = new ClientState(1);
        client1.assignActiveTasks(activeTasks);
        return client1;
    }
}

