/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class MockSourceNode<K, V>
extends SourceNode<K, V> {
    private static final String NAME = "MOCK-SOURCE-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public int numReceived = 0;
    public final ArrayList<K> keys = new ArrayList();
    public final ArrayList<V> values = new ArrayList();
    public boolean initialized;
    public boolean closed;

    public MockSourceNode(Deserializer<K> keyDeserializer, Deserializer<V> valDeserializer) {
        super(NAME + INDEX.getAndIncrement(), keyDeserializer, valDeserializer);
    }

    public void process(K key, V value) {
        ++this.numReceived;
        this.keys.add(key);
        this.values.add(value);
    }

    public void init(InternalProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    public void close() {
        super.close();
        this.closed = true;
    }
}

