/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.tests.EosTestClient;
import org.apache.kafka.streams.tests.EosTestDriver;

public class StreamsEosTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("StreamsEosTest are expecting two parameters: propFile, command; but only see " + args.length + " parameter");
            Exit.exit((int)1);
        }
        String propFileName = args[0];
        String command = args[1];
        Properties streamsProperties = Utils.loadProps((String)propFileName);
        String kafka = streamsProperties.getProperty("bootstrap.servers");
        String processingGuarantee = streamsProperties.getProperty("processing.guarantee");
        if (kafka == null) {
            System.err.println("No bootstrap kafka servers specified in bootstrap.servers");
            Exit.exit((int)1);
        }
        if (("process".equals(command) || "process-complex".equals(command)) && !"exactly_once".equals(processingGuarantee) && !"exactly_once_beta".equals(processingGuarantee)) {
            System.err.println("processingGuarantee must be either exactly_once or exactly_once_beta");
            Exit.exit((int)1);
        }
        System.out.println("StreamsTest instance started");
        System.out.println("kafka=" + kafka);
        System.out.println("props=" + streamsProperties);
        System.out.println("command=" + command);
        System.out.flush();
        if (command == null || propFileName == null) {
            Exit.exit((int)-1);
        }
        switch (command) {
            case "run": {
                EosTestDriver.generate(kafka);
                break;
            }
            case "process": {
                new EosTestClient(streamsProperties, false).start();
                break;
            }
            case "process-complex": {
                new EosTestClient(streamsProperties, true).start();
                break;
            }
            case "verify": {
                EosTestDriver.verify(kafka, false);
                break;
            }
            case "verify-complex": {
                EosTestDriver.verify(kafka, true);
                break;
            }
            default: {
                System.out.println("unknown command: " + command);
                System.out.flush();
                Exit.exit((int)-1);
            }
        }
    }
}

