/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBStoreTest;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;

public class RocksDBTimestampedStoreTest
extends RocksDBStoreTest {
    @Override
    RocksDBStore getRocksDBStore() {
        return new RocksDBTimestampedStore("db-name", "metrics-scope");
    }

    @Test
    public void shouldOpenNewStoreInRegularMode() {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RocksDBTimestampedStore.class);){
            this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
            MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in regular mode"));
        }
        var2_2 = null;
        try (KeyValueIterator iterator = this.rocksDBStore.all();){
            MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenExistingStoreInRegularMode() throws Exception {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.rocksDBStore.put(new Bytes("key".getBytes()), "timestamped".getBytes());
        this.rocksDBStore.close();
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RocksDBTimestampedStore.class);){
            this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
            MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in regular mode"));
        }
        finally {
            this.rocksDBStore.close();
        }
        DBOptions dbOptions = new DBOptions();
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions), new ColumnFamilyDescriptor("keyValueWithTimestamp".getBytes(StandardCharsets.UTF_8), columnFamilyOptions));
        ArrayList columnFamilies = new ArrayList(columnFamilyDescriptors.size());
        RocksDB db = null;
        ColumnFamilyHandle noTimestampColumnFamily = null;
        ColumnFamilyHandle withTimestampColumnFamily = null;
        try {
            db = RocksDB.open((DBOptions)dbOptions, (String)new File(new File(this.context.stateDir(), "rocksdb"), "db-name").getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
            withTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(1);
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.getLongProperty(noTimestampColumnFamily, "rocksdb.estimate-num-keys"), (Matcher)CoreMatchers.is((Object)0L));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key".getBytes()).length, (Matcher)CoreMatchers.is((Object)11));
            MatcherAssert.assertThat((Object)db.getLongProperty(withTimestampColumnFamily, "rocksdb.estimate-num-keys"), (Matcher)CoreMatchers.is((Object)1L));
        }
        finally {
            if (noTimestampColumnFamily != null) {
                noTimestampColumnFamily.close();
            }
            if (withTimestampColumnFamily != null) {
                withTimestampColumnFamily.close();
            }
            if (db != null) {
                db.close();
            }
            dbOptions.close();
            columnFamilyOptions.close();
        }
    }

    @Test
    public void shouldMigrateDataFromDefaultToTimestampColumnFamily() throws Exception {
        this.prepareOldStore();
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RocksDBTimestampedStore.class);){
            this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
            MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in upgrade mode"));
        }
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.get(new Bytes("unknown".getBytes())), (Matcher)new IsNull());
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.get(new Bytes("key1".getBytes())).length, (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        this.rocksDBStore.put(new Bytes("key2".getBytes()), "timestamp+22".getBytes());
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)7L));
        this.rocksDBStore.put(new Bytes("key3".getBytes()), null);
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        this.rocksDBStore.put(new Bytes("key8".getBytes()), "timestamp+88888888".getBytes());
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key4".getBytes()), "timestamp+4444".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key11".getBytes()), "timestamp+11111111111".getBytes()), (Matcher)new IsNull());
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key5".getBytes()), null).length, (Matcher)CoreMatchers.is((Object)13));
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)5L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.putIfAbsent(new Bytes("key12".getBytes()), null), (Matcher)new IsNull());
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.rocksDBStore.delete(new Bytes("key6".getBytes())).length, (Matcher)CoreMatchers.is((Object)14));
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)3L));
        this.iteratorsShouldNotMigrateData();
        MatcherAssert.assertThat((Object)this.rocksDBStore.approximateNumEntries(), (Matcher)CoreMatchers.is((Object)3L));
        this.rocksDBStore.close();
        this.verifyOldAndNewColumnFamily();
    }

    private void iteratorsShouldNotMigrateData() {
        KeyValue keyValue;
        try (KeyValueIterator itAll = this.rocksDBStore.all();){
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key1".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 49}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key11".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key2".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 50, 50}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key4".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 52, 52, 52, 52}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key5".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 53, 53, 53, 53, 53}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key7".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 55, 55, 55, 55, 55, 55, 55}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)itAll.next();
            Assert.assertArrayEquals((byte[])"key8".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 56, 56, 56, 56, 56, 56, 56, 56}, (byte[])((byte[])keyValue.value));
            Assert.assertFalse((boolean)itAll.hasNext());
        }
        var2_2 = null;
        try (KeyValueIterator it = this.rocksDBStore.range(new Bytes("key2".getBytes()), new Bytes("key5".getBytes()));){
            keyValue = (KeyValue)it.next();
            Assert.assertArrayEquals((byte[])"key2".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{116, 105, 109, 101, 115, 116, 97, 109, 112, 43, 50, 50}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)it.next();
            Assert.assertArrayEquals((byte[])"key4".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 52, 52, 52, 52}, (byte[])((byte[])keyValue.value));
            keyValue = (KeyValue)it.next();
            Assert.assertArrayEquals((byte[])"key5".getBytes(), (byte[])((Bytes)keyValue.key).get());
            Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 53, 53, 53, 53, 53}, (byte[])((byte[])keyValue.value));
            Assert.assertFalse((boolean)it.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOldAndNewColumnFamily() throws Exception {
        Throwable throwable;
        LogCaptureAppender appender;
        DBOptions dbOptions = new DBOptions();
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = Arrays.asList(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions), new ColumnFamilyDescriptor("keyValueWithTimestamp".getBytes(StandardCharsets.UTF_8), columnFamilyOptions));
        ArrayList columnFamilies = new ArrayList(columnFamilyDescriptors.size());
        RocksDB db = null;
        ColumnFamilyHandle noTimestampColumnFamily = null;
        ColumnFamilyHandle withTimestampColumnFamily = null;
        boolean errorOccurred = false;
        try {
            db = RocksDB.open((DBOptions)dbOptions, (String)new File(new File(this.context.stateDir(), "rocksdb"), "db-name").getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
            withTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(1);
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "unknown".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key1".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key2".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key3".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key4".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key5".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key6".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key7".getBytes()).length, (Matcher)CoreMatchers.is((Object)7));
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key8".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key11".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(noTimestampColumnFamily, "key12".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "unknown".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key1".getBytes()).length, (Matcher)CoreMatchers.is((Object)9));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key2".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key3".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key4".getBytes()).length, (Matcher)CoreMatchers.is((Object)12));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key5".getBytes()).length, (Matcher)CoreMatchers.is((Object)13));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key6".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key7".getBytes()), (Matcher)new IsNull());
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key8".getBytes()).length, (Matcher)CoreMatchers.is((Object)18));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key11".getBytes()).length, (Matcher)CoreMatchers.is((Object)21));
            MatcherAssert.assertThat((Object)db.get(withTimestampColumnFamily, "key12".getBytes()), (Matcher)new IsNull());
        }
        catch (RuntimeException fatal) {
            errorOccurred = true;
        }
        finally {
            if (noTimestampColumnFamily != null) {
                noTimestampColumnFamily.close();
            }
            if (withTimestampColumnFamily != null) {
                withTimestampColumnFamily.close();
            }
            if (db != null) {
                db.close();
            }
            if (errorOccurred) {
                dbOptions.close();
                columnFamilyOptions.close();
            }
        }
        try {
            appender = LogCaptureAppender.createAndRegister(RocksDBTimestampedStore.class);
            throwable = null;
            try {
                this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
                MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in upgrade mode"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        finally {
            this.rocksDBStore.close();
        }
        columnFamilies.clear();
        db = null;
        noTimestampColumnFamily = null;
        try {
            db = RocksDB.open((DBOptions)dbOptions, (String)new File(new File(this.context.stateDir(), "rocksdb"), "db-name").getAbsolutePath(), columnFamilyDescriptors, columnFamilies);
            noTimestampColumnFamily = (ColumnFamilyHandle)columnFamilies.get(0);
            db.delete(noTimestampColumnFamily, "key7".getBytes());
        }
        finally {
            if (noTimestampColumnFamily != null) {
                noTimestampColumnFamily.close();
            }
            if (db != null) {
                db.close();
            }
            dbOptions.close();
            columnFamilyOptions.close();
        }
        appender = LogCaptureAppender.createAndRegister(RocksDBTimestampedStore.class);
        throwable = null;
        try {
            this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
            MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Opening store db-name in regular mode"));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (appender != null) {
                if (throwable != null) {
                    try {
                        appender.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    appender.close();
                }
            }
        }
    }

    private void prepareOldStore() {
        try (RocksDBStore keyValueStore = new RocksDBStore("db-name", "metrics-scope");){
            keyValueStore.init((ProcessorContext)this.context, (StateStore)keyValueStore);
            keyValueStore.put(new Bytes("key1".getBytes()), "1".getBytes());
            keyValueStore.put(new Bytes("key2".getBytes()), "22".getBytes());
            keyValueStore.put(new Bytes("key3".getBytes()), "333".getBytes());
            keyValueStore.put(new Bytes("key4".getBytes()), "4444".getBytes());
            keyValueStore.put(new Bytes("key5".getBytes()), "55555".getBytes());
            keyValueStore.put(new Bytes("key6".getBytes()), "666666".getBytes());
            keyValueStore.put(new Bytes("key7".getBytes()), "7777777".getBytes());
        }
    }
}

