/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.api.easymock.PowerMock;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.Filter;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;

public class RocksDBStoreTest {
    private static boolean enableBloomFilters = false;
    static final String DB_NAME = "db-name";
    static final String METRICS_SCOPE = "metrics-scope";
    private File dir;
    private final Time time = new MockTime();
    private final Serializer<String> stringSerializer = new StringSerializer();
    private final Deserializer<String> stringDeserializer = new StringDeserializer();
    private final RocksDBMetricsRecorder metricsRecorder = (RocksDBMetricsRecorder)EasyMock.mock(RocksDBMetricsRecorder.class);
    InternalMockProcessorContext context;
    RocksDBStore rocksDBStore;

    @Before
    public void setUp() {
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("rocksdb.config.setter", MockRocksDbConfigSetter.class);
        this.dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.dir, Serdes.String(), Serdes.String(), new StreamsConfig((Map)props));
        this.rocksDBStore = this.getRocksDBStore();
        this.context.metrics().setRocksDBMetricsRecordingTrigger(new RocksDBMetricsRecordingTrigger(this.time));
    }

    @After
    public void tearDown() {
        this.rocksDBStore.close();
    }

    RocksDBStore getRocksDBStore() {
        return new RocksDBStore(DB_NAME, METRICS_SCOPE);
    }

    private RocksDBStore getRocksDBStoreWithRocksDBMetricsRecorder() {
        return new RocksDBStore(DB_NAME, METRICS_SCOPE, this.metricsRecorder);
    }

    private InternalMockProcessorContext getProcessorContext(Properties streamsProps) {
        return new InternalMockProcessorContext(TestUtils.tempDirectory(), new StreamsConfig((Map)streamsProps));
    }

    private InternalMockProcessorContext getProcessorContext(Sensor.RecordingLevel recordingLevel, Class<? extends RocksDBConfigSetter> rocksDBConfigSetterClass) {
        Properties streamsProps = StreamsTestUtils.getStreamsConfig();
        streamsProps.setProperty("metrics.recording.level", recordingLevel.name());
        streamsProps.put("rocksdb.config.setter", rocksDBConfigSetterClass);
        return this.getProcessorContext(streamsProps);
    }

    private InternalMockProcessorContext getProcessorContext(Sensor.RecordingLevel recordingLevel) {
        Properties streamsProps = StreamsTestUtils.getStreamsConfig();
        streamsProps.setProperty("metrics.recording.level", recordingLevel.name());
        return this.getProcessorContext(streamsProps);
    }

    @Test
    public void shouldAddStatisticsToInjectedMetricsRecorderWhenRecordingLevelIsDebug() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        this.context = this.getProcessorContext(Sensor.RecordingLevel.DEBUG);
        EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
        this.metricsRecorder.addStatistics((String)EasyMock.eq((Object)DB_NAME), (Statistics)EasyMock.anyObject(Statistics.class));
        PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        this.rocksDBStore.openDB((ProcessorContext)this.context);
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
        EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldNotAddStatisticsToInjectedMetricsRecorderWhenRecordingLevelIsInfo() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        this.context = this.getProcessorContext(Sensor.RecordingLevel.INFO);
        EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
        PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        this.rocksDBStore.openDB((ProcessorContext)this.context);
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldRemoveStatisticsFromInjectedMetricsRecorderOnCloseWhenRecordingLevelIsDebug() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        try {
            this.context = this.getProcessorContext(Sensor.RecordingLevel.DEBUG);
            this.rocksDBStore.openDB((ProcessorContext)this.context);
            EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
            this.metricsRecorder.removeStatistics(DB_NAME);
            PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        }
        finally {
            this.rocksDBStore.close();
        }
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldNotRemoveStatisticsFromInjectedMetricsRecorderOnCloseWhenRecordingLevelIsInfo() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        try {
            this.context = this.getProcessorContext(Sensor.RecordingLevel.INFO);
            this.rocksDBStore.openDB((ProcessorContext)this.context);
            EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
            PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        }
        finally {
            this.rocksDBStore.close();
        }
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldNotAddStatisticsToInjectedMetricsRecorderWhenUserProvidesStatistics() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        this.context = this.getProcessorContext(Sensor.RecordingLevel.DEBUG, RocksDBConfigSetterWithUserProvidedStatistics.class);
        PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        this.rocksDBStore.openDB((ProcessorContext)this.context);
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldNotRemoveStatisticsFromInjectedMetricsRecorderOnCloseWhenUserProvidesStatistics() {
        this.rocksDBStore = this.getRocksDBStoreWithRocksDBMetricsRecorder();
        this.context = this.getProcessorContext(Sensor.RecordingLevel.DEBUG, RocksDBConfigSetterWithUserProvidedStatistics.class);
        this.rocksDBStore.openDB((ProcessorContext)this.context);
        EasyMock.reset((Object[])new Object[]{this.metricsRecorder});
        PowerMock.replay((Object[])new Object[]{this.metricsRecorder});
        PowerMock.verify((Object[])new Object[]{this.metricsRecorder});
    }

    @Test
    public void shouldNotThrowExceptionOnRestoreWhenThereIsPreExistingRocksDbFiles() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.rocksDBStore.put(new Bytes("existingKey".getBytes(StandardCharsets.UTF_8)), "existingValue".getBytes(StandardCharsets.UTF_8));
        this.rocksDBStore.flush();
        ArrayList<KeyValue<byte[], byte[]>> restoreBytes = new ArrayList<KeyValue<byte[], byte[]>>();
        byte[] restoredKey = "restoredKey".getBytes(StandardCharsets.UTF_8);
        byte[] restoredValue = "restoredValue".getBytes(StandardCharsets.UTF_8);
        restoreBytes.add(KeyValue.pair((Object)restoredKey, (Object)restoredValue));
        this.context.restore(DB_NAME, restoreBytes);
        MatcherAssert.assertThat((Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"restoredKey")))), (Matcher)CoreMatchers.equalTo((Object)"restoredValue"));
    }

    @Test
    public void shouldCallRocksDbConfigSetter() {
        MockRocksDbConfigSetter.called = false;
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertTrue((boolean)MockRocksDbConfigSetter.called);
    }

    @Test
    public void shouldThrowProcessorStateExceptionOnOpeningReadOnlyDir() {
        File tmpDir = TestUtils.tempDirectory();
        InternalMockProcessorContext tmpContext = new InternalMockProcessorContext(tmpDir, new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()));
        Assert.assertTrue((boolean)tmpDir.setReadOnly());
        Assert.assertThrows(ProcessorStateException.class, () -> this.rocksDBStore.openDB((ProcessorContext)tmpContext));
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"1")), (Object)this.stringSerializer.serialize(null, (Object)"a")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"2")), (Object)this.stringSerializer.serialize(null, (Object)"b")));
        entries.add(new KeyValue((Object)new Bytes(this.stringSerializer.serialize(null, (Object)"3")), (Object)this.stringSerializer.serialize(null, (Object)"c")));
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.rocksDBStore.putAll(entries);
        this.rocksDBStore.flush();
        Assert.assertEquals((Object)"a", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"1")))));
        Assert.assertEquals((Object)"b", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"2")))));
        Assert.assertEquals((Object)"c", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"3")))));
    }

    @Test
    public void shouldRestoreAll() {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.context.restore(this.rocksDBStore.name(), entries);
        Assert.assertEquals((Object)"a", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"1")))));
        Assert.assertEquals((Object)"b", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"2")))));
        Assert.assertEquals((Object)"c", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"3")))));
    }

    @Test
    public void shouldPutOnlyIfAbsentValue() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Bytes keyBytes = new Bytes(this.stringSerializer.serialize(null, (Object)"one"));
        byte[] valueBytes = this.stringSerializer.serialize(null, (Object)"A");
        byte[] valueBytesUpdate = this.stringSerializer.serialize(null, (Object)"B");
        this.rocksDBStore.putIfAbsent(keyBytes, valueBytes);
        this.rocksDBStore.putIfAbsent(keyBytes, valueBytesUpdate);
        String retrievedValue = (String)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(keyBytes));
        Assert.assertEquals((Object)"A", (Object)retrievedValue);
    }

    @Test
    public void shouldHandleDeletesOnRestoreAll() {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        entries.add((KeyValue<byte[], byte[]>)new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), null));
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.context.restore(this.rocksDBStore.name(), entries);
        KeyValueIterator iterator = this.rocksDBStore.all();
        HashSet<Object> keys = new HashSet<Object>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new String[]{"2", "3"})));
    }

    @Test
    public void shouldHandleDeletesAndPutbackOnRestoreAll() {
        ArrayList<KeyValue<byte[], byte[]>> entries = new ArrayList<KeyValue<byte[], byte[]>>();
        entries.add(new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), (Object)"a".getBytes(StandardCharsets.UTF_8)));
        entries.add(new KeyValue((Object)"2".getBytes(StandardCharsets.UTF_8), (Object)"b".getBytes(StandardCharsets.UTF_8)));
        entries.add(new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), null));
        entries.add(new KeyValue((Object)"3".getBytes(StandardCharsets.UTF_8), (Object)"c".getBytes(StandardCharsets.UTF_8)));
        entries.add(new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), (Object)"restored".getBytes(StandardCharsets.UTF_8)));
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.context.restore(this.rocksDBStore.name(), entries);
        KeyValueIterator iterator = this.rocksDBStore.all();
        HashSet<Object> keys = new HashSet<Object>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new String[]{"1", "2", "3"})));
        Assert.assertEquals((Object)"restored", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"1")))));
        Assert.assertEquals((Object)"b", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"2")))));
        Assert.assertEquals((Object)"c", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"3")))));
    }

    @Test
    public void shouldRestoreThenDeleteOnRestoreAll() {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        this.context.restore(this.rocksDBStore.name(), entries);
        Assert.assertEquals((Object)"a", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"1")))));
        Assert.assertEquals((Object)"b", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"2")))));
        Assert.assertEquals((Object)"c", (Object)this.stringDeserializer.deserialize(null, this.rocksDBStore.get(new Bytes(this.stringSerializer.serialize(null, (Object)"3")))));
        entries.clear();
        entries.add((KeyValue<byte[], byte[]>)new KeyValue((Object)"2".getBytes(StandardCharsets.UTF_8), (Object)"b".getBytes(StandardCharsets.UTF_8)));
        entries.add((KeyValue<byte[], byte[]>)new KeyValue((Object)"3".getBytes(StandardCharsets.UTF_8), (Object)"c".getBytes(StandardCharsets.UTF_8)));
        entries.add((KeyValue<byte[], byte[]>)new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), null));
        this.context.restore(this.rocksDBStore.name(), entries);
        KeyValueIterator iterator = this.rocksDBStore.all();
        HashSet<Object> keys = new HashSet<Object>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.equalTo((Object)Utils.mkSet((Object[])new String[]{"2", "3"})));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullPut() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThrows(NullPointerException.class, () -> this.rocksDBStore.put(null, this.stringSerializer.serialize(null, (Object)"someVal")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullPutAll() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThrows(NullPointerException.class, () -> this.rocksDBStore.put(null, this.stringSerializer.serialize(null, (Object)"someVal")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullGet() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThrows(NullPointerException.class, () -> this.rocksDBStore.get(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnDelete() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThrows(NullPointerException.class, () -> this.rocksDBStore.delete(null));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRange() {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Assert.assertThrows(NullPointerException.class, () -> this.rocksDBStore.range(null, new Bytes(this.stringSerializer.serialize(null, (Object)"2"))));
    }

    @Test(expected=ProcessorStateException.class)
    public void shouldThrowProcessorStateExceptionOnPutDeletedDir() throws IOException {
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        Utils.delete((File)this.dir);
        this.rocksDBStore.put(new Bytes(this.stringSerializer.serialize(null, (Object)"anyKey")), this.stringSerializer.serialize(null, (Object)"anyValue"));
        this.rocksDBStore.flush();
    }

    @Test
    public void shouldHandleToggleOfEnablingBloomFilters() {
        byte[] valBytes;
        Properties props = StreamsTestUtils.getStreamsConfig();
        props.put("rocksdb.config.setter", TestingBloomFilterRocksDBConfigSetter.class);
        this.dir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.dir, Serdes.String(), Serdes.String(), new StreamsConfig((Map)props));
        this.context.metrics().setRocksDBMetricsRecordingTrigger(new RocksDBMetricsRecordingTrigger(this.time));
        enableBloomFilters = false;
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        ArrayList<String> expectedValues = new ArrayList<String>();
        expectedValues.add("a");
        expectedValues.add("b");
        expectedValues.add("c");
        List<KeyValue<byte[], byte[]>> keyValues = this.getKeyValueEntries();
        for (KeyValue<byte[], byte[]> keyValue : keyValues) {
            this.rocksDBStore.put(new Bytes((byte[])keyValue.key), (byte[])keyValue.value);
        }
        int expectedIndex = 0;
        for (KeyValue<byte[], byte[]> keyValue : keyValues) {
            valBytes = this.rocksDBStore.get(new Bytes((byte[])keyValue.key));
            MatcherAssert.assertThat((Object)new String(valBytes, StandardCharsets.UTF_8), (Matcher)CoreMatchers.is(expectedValues.get(expectedIndex++)));
        }
        Assert.assertFalse((boolean)TestingBloomFilterRocksDBConfigSetter.bloomFiltersSet);
        this.rocksDBStore.close();
        expectedIndex = 0;
        enableBloomFilters = true;
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        for (KeyValue<byte[], byte[]> keyValue : keyValues) {
            valBytes = this.rocksDBStore.get(new Bytes((byte[])keyValue.key));
            MatcherAssert.assertThat((Object)new String(valBytes, StandardCharsets.UTF_8), (Matcher)CoreMatchers.is(expectedValues.get(expectedIndex++)));
        }
        Assert.assertTrue((boolean)TestingBloomFilterRocksDBConfigSetter.bloomFiltersSet);
    }

    @Test
    public void shouldVerifyThatMetricsGetMeasurementsFromRocksDB() {
        TaskId taskId = new TaskId(0, 0);
        RocksDBMetricsRecordingTrigger rocksDBMetricsRecordingTrigger = new RocksDBMetricsRecordingTrigger(this.time);
        Metrics metrics = new Metrics(new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG));
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test-application", "latest");
        streamsMetrics.setRocksDBMetricsRecordingTrigger(rocksDBMetricsRecordingTrigger);
        this.context = (InternalMockProcessorContext)((Object)EasyMock.niceMock(InternalMockProcessorContext.class));
        EasyMock.expect((Object)this.context.metrics()).andStubReturn((Object)streamsMetrics);
        EasyMock.expect((Object)this.context.taskId()).andStubReturn((Object)taskId);
        EasyMock.expect((Object)this.context.appConfigs()).andStubReturn((Object)new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()).originals());
        EasyMock.expect((Object)this.context.stateDir()).andStubReturn((Object)this.dir);
        EasyMock.replay((Object[])new Object[]{this.context});
        this.rocksDBStore.init((ProcessorContext)this.context, (StateStore)this.rocksDBStore);
        byte[] key = "hello".getBytes();
        byte[] value = "world".getBytes();
        this.rocksDBStore.put(Bytes.wrap((byte[])key), value);
        rocksDBMetricsRecordingTrigger.run();
        KafkaMetric bytesWrittenTotal = metrics.metric(new MetricName("bytes-written-total", "stream-state-metrics", "description is not verified", streamsMetrics.storeLevelTagMap(Thread.currentThread().getName(), taskId.toString(), METRICS_SCOPE, DB_NAME)));
        MatcherAssert.assertThat((Object)((Double)bytesWrittenTotal.metricValue()), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    private List<KeyValue<byte[], byte[]>> getKeyValueEntries() {
        ArrayList<KeyValue<byte[], byte[]>> entries = new ArrayList<KeyValue<byte[], byte[]>>();
        entries.add(new KeyValue((Object)"1".getBytes(StandardCharsets.UTF_8), (Object)"a".getBytes(StandardCharsets.UTF_8)));
        entries.add(new KeyValue((Object)"2".getBytes(StandardCharsets.UTF_8), (Object)"b".getBytes(StandardCharsets.UTF_8)));
        entries.add(new KeyValue((Object)"3".getBytes(StandardCharsets.UTF_8), (Object)"c".getBytes(StandardCharsets.UTF_8)));
        return entries;
    }

    public static class TestingBloomFilterRocksDBConfigSetter
    implements RocksDBConfigSetter {
        static boolean bloomFiltersSet;
        static Filter filter;
        static Cache cache;

        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
            cache = new LRUCache(0x3200000L);
            tableConfig.setBlockCache(cache);
            tableConfig.setBlockSize(4096L);
            if (enableBloomFilters) {
                filter = new BloomFilter();
                tableConfig.setFilter(filter);
                options.optimizeFiltersForHits();
                bloomFiltersSet = true;
            } else {
                options.setOptimizeFiltersForHits(false);
                bloomFiltersSet = false;
            }
            options.setTableFormatConfig((TableFormatConfig)tableConfig);
        }

        public void close(String storeName, Options options) {
            if (filter != null) {
                filter.close();
            }
            cache.close();
        }
    }

    public static class MockRocksDbConfigSetter
    implements RocksDBConfigSetter {
        static boolean called;

        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            called = true;
            options.setLevel0FileNumCompactionTrigger(10);
        }
    }

    public static class RocksDBConfigSetterWithUserProvidedStatistics
    implements RocksDBConfigSetter {
        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            options.setStatistics(new Statistics());
        }

        public void close(String storeName, Options options) {
            options.statistics().close();
        }
    }
}

