/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class OffsetCheckpointTest {
    private final String topic = "topic";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite() throws IOException {
        File f = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(f);
        try {
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), 0L);
            offsets.put(new TopicPartition("topic", 1), 1L);
            offsets.put(new TopicPartition("topic", 2), 2L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
            checkpoint.delete();
            Assert.assertFalse((boolean)f.exists());
            offsets.put(new TopicPartition("topic", 3), 3L);
            checkpoint.write(offsets);
            Assert.assertEquals(offsets, (Object)checkpoint.read());
        }
        finally {
            checkpoint.delete();
        }
    }

    @Test
    public void shouldNotWriteCheckpointWhenNoOffsets() throws IOException {
        File f = new File(TestUtils.tempDirectory().getAbsolutePath(), "kafka.tmp");
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(f);
        checkpoint.write(Collections.emptyMap());
        Assert.assertFalse((boolean)f.exists());
        Assert.assertEquals(Collections.emptyMap(), (Object)checkpoint.read());
        checkpoint.delete();
    }

    @Test
    public void shouldDeleteExistingCheckpointWhenNoOffsets() throws IOException {
        File file = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(file);
        Map<TopicPartition, Long> offsets = Collections.singletonMap(new TopicPartition("topic", 0), 1L);
        checkpoint.write(offsets);
        MatcherAssert.assertThat((Object)file.exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(offsets, (Matcher)Matchers.is((Object)checkpoint.read()));
        checkpoint.write(Collections.emptyMap());
        MatcherAssert.assertThat((Object)file.exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(Collections.emptyMap(), (Matcher)Matchers.is((Object)checkpoint.read()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSkipInvalidOffsetsDuringRead() throws IOException {
        File file = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(file);
        try {
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), -1L);
            OffsetCheckpointTest.writeVersion0(offsets, file);
            Assert.assertTrue((boolean)checkpoint.read().isEmpty());
        }
        finally {
            checkpoint.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReadAndWriteSentinelOffset() throws IOException {
        File f = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(f);
        long sentinelOffset = -4L;
        try {
            HashMap<TopicPartition, Long> offsetsToWrite = new HashMap<TopicPartition, Long>();
            offsetsToWrite.put(new TopicPartition("topic", 1), -4L);
            checkpoint.write(offsetsToWrite);
            Map readOffsets = checkpoint.read();
            MatcherAssert.assertThat(readOffsets.get(new TopicPartition("topic", 1)), (Matcher)Matchers.equalTo((Object)-4L));
        }
        finally {
            checkpoint.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowOnInvalidOffsetInWrite() throws IOException {
        File f = TestUtils.tempFile();
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(f);
        try {
            HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
            offsets.put(new TopicPartition("topic", 0), 0L);
            offsets.put(new TopicPartition("topic", 1), -1L);
            offsets.put(new TopicPartition("topic", 2), 2L);
            Assert.assertThrows(IllegalStateException.class, () -> checkpoint.write(offsets));
        }
        finally {
            checkpoint.delete();
        }
    }

    static void writeVersion0(Map<TopicPartition, Long> offsets, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
            OffsetCheckpoint.writeIntLine((BufferedWriter)writer, (int)0);
            OffsetCheckpoint.writeIntLine((BufferedWriter)writer, (int)offsets.size());
            for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
                TopicPartition tp = entry.getKey();
                Long offset = entry.getValue();
                OffsetCheckpoint.writeEntry((BufferedWriter)writer, (TopicPartition)tp, (long)offset);
            }
            writer.flush();
            fileOutputStream.getFD().sync();
        }
    }
}

