/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.SerdeThatDoesntHandleNull;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeteredTimestampedWindowStoreTest {
    private InternalMockProcessorContext context;
    private final WindowStore<Bytes, byte[]> innerStoreMock = (WindowStore)EasyMock.createNiceMock(WindowStore.class);
    private final MeteredTimestampedWindowStore<String, String> store = new MeteredTimestampedWindowStore(this.innerStoreMock, 10L, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new ValueAndTimestampSerde((Serde)new SerdeThatDoesntHandleNull()));
    private final Metrics metrics = new Metrics(new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG));

    public MeteredTimestampedWindowStoreTest() {
        EasyMock.expect((Object)this.innerStoreMock.name()).andReturn((Object)"mocked-store").anyTimes();
    }

    @Before
    public void setUp() {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, "test", "latest");
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), streamsMetrics, new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()), MockRecordCollector::new, new ThreadCache(new LogContext("testCache "), 0L, streamsMetrics));
    }

    @Test
    public void shouldCloseUnderlyingStore() {
        this.innerStoreMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        this.store.close();
        EasyMock.verify((Object[])new Object[]{this.innerStoreMock});
    }

    @Test
    public void shouldNotExceptionIfFetchReturnsNull() {
        EasyMock.expect((Object)this.innerStoreMock.fetch((Object)Bytes.wrap((byte[])"a".getBytes()), 0L)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        this.store.init((ProcessorContext)this.context, this.store);
        Assert.assertNull((Object)this.store.fetch((Object)"a", 0L));
    }

    @Test
    public void shouldNotThrowExceptionIfSerdesCorrectlySetFromProcessorContext() {
        EasyMock.expect((Object)this.innerStoreMock.name()).andStubReturn((Object)"mocked-store");
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        MeteredTimestampedWindowStore store = new MeteredTimestampedWindowStore(this.innerStoreMock, 10L, "scope", (Time)new MockTime(), null, null);
        store.init((ProcessorContext)this.context, this.innerStoreMock);
        try {
            store.put((Object)"key", (Object)ValueAndTimestamp.make((Object)42L, (long)60000L));
        }
        catch (StreamsException exception) {
            if (exception.getCause() instanceof ClassCastException) {
                Assert.fail((String)"Serdes are not correctly set from processor context.");
            }
            throw exception;
        }
    }

    @Test
    public void shouldNotThrowExceptionIfSerdesCorrectlySetFromConstructorParameters() {
        EasyMock.expect((Object)this.innerStoreMock.name()).andStubReturn((Object)"mocked-store");
        EasyMock.replay((Object[])new Object[]{this.innerStoreMock});
        MeteredTimestampedWindowStore store = new MeteredTimestampedWindowStore(this.innerStoreMock, 10L, "scope", (Time)new MockTime(), Serdes.String(), (Serde)new ValueAndTimestampSerde(Serdes.Long()));
        store.init((ProcessorContext)this.context, this.innerStoreMock);
        try {
            store.put((Object)"key", (Object)ValueAndTimestamp.make((Object)42L, (long)60000L));
        }
        catch (StreamsException exception) {
            if (exception.getCause() instanceof ClassCastException) {
                Assert.fail((String)"Serdes are not correctly set from constructor parameters.");
            }
            throw exception;
        }
    }
}

