/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ChangeLoggingTimestampedKeyValueBytesStoreTest {
    private final MockRecordCollector collector = new MockRecordCollector();
    private final InMemoryKeyValueStore root = new InMemoryKeyValueStore("kv");
    private final ChangeLoggingTimestampedKeyValueBytesStore store = new ChangeLoggingTimestampedKeyValueBytesStore((KeyValueStore)this.root);
    private final Bytes hi = Bytes.wrap((byte[])"hi".getBytes());
    private final Bytes hello = Bytes.wrap((byte[])"hello".getBytes());
    private final ValueAndTimestamp<byte[]> there = ValueAndTimestamp.make((Object)"there".getBytes(), (long)97L);
    private final byte[] rawThere = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000athere".getBytes();
    private final ValueAndTimestamp<byte[]> world = ValueAndTimestamp.make((Object)"world".getBytes(), (long)98L);
    private final byte[] rawWorld = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000bworld".getBytes();

    @Before
    public void before() {
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), this.collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        context.setTime(0L);
        this.store.init((ProcessorContext)context, (StateStore)this.store);
    }

    @After
    public void after() {
        this.store.close();
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() {
        this.store.put(this.hi, this.rawThere);
        MatcherAssert.assertThat((Object)this.root.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.there.timestamp()));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.rawThere), KeyValue.pair((Object)this.hello, (Object)this.rawWorld)));
        MatcherAssert.assertThat((Object)this.root.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
        MatcherAssert.assertThat((Object)this.root.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.rawWorld));
    }

    @Test
    public void shouldLogChangesOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.rawThere), KeyValue.pair((Object)this.hello, (Object)this.rawWorld)));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.there.timestamp()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hello));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.equalTo((Object)this.world.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.world.timestamp()));
    }

    @Test
    public void shouldPropagateDelete() {
        this.store.put(this.hi, this.rawThere);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.root.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.root.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() {
        this.store.put(this.hi, this.rawThere);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
    }

    @Test
    public void shouldLogKeyNullOnDelete() {
        this.store.put(this.hi, this.rawThere);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.there.timestamp()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).timestamp(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.rawThere);
        MatcherAssert.assertThat((Object)this.root.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.rawThere);
        this.store.putIfAbsent(this.hi, this.rawWorld);
        MatcherAssert.assertThat((Object)this.root.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.rawThere);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.there.timestamp()));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.rawThere);
        this.store.putIfAbsent(this.hi, this.rawWorld);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there.value()));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)this.there.timestamp()));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() {
        this.store.put(this.hi, this.rawThere);
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.rawWorld), (Matcher)CoreMatchers.equalTo((Object)this.rawThere));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.rawThere), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() {
        this.store.put(this.hello, this.rawWorld);
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.rawWorld));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() {
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

