/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.test.MockRecordCollector;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class ChangeLoggingSessionBytesStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final MockRecordCollector collector = new MockRecordCollector();
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContextImpl context;
    private ChangeLoggingSessionBytesStore store;
    private final byte[] value1 = new byte[]{0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value1);
    private final Windowed<Bytes> key1 = new Windowed((Object)this.bytesKey, (Window)new SessionWindow(0L, 0L));

    @Before
    public void setUp() {
        this.store = new ChangeLoggingSessionBytesStore(this.inner);
    }

    private void init() {
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.context.recordCollector()).andReturn((Object)this.collector);
        this.inner.init((ProcessorContext)this.context, (StateStore)this.store);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.store.init((ProcessorContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldLogPuts() {
        this.inner.put(this.key1, (Object)this.value1);
        EasyMock.expectLastCall();
        this.init();
        Bytes binaryKey = SessionKeySchema.toBinary(this.key1);
        EasyMock.reset((Object[])new Object[]{this.context});
        this.context.logChange(this.store.name(), binaryKey, this.value1, 0L);
        EasyMock.replay((Object[])new Object[]{this.context});
        this.store.put(this.key1, this.value1);
        EasyMock.verify((Object[])new Object[]{this.inner, this.context});
    }

    @Test
    public void shouldLogRemoves() {
        this.inner.remove(this.key1);
        EasyMock.expectLastCall();
        this.init();
        this.store.remove(this.key1);
        Bytes binaryKey = SessionKeySchema.toBinary(this.key1);
        EasyMock.reset((Object[])new Object[]{this.context});
        this.context.logChange(this.store.name(), binaryKey, null, 0L);
        EasyMock.replay((Object[])new Object[]{this.context});
        this.store.remove(this.key1);
        EasyMock.verify((Object[])new Object[]{this.inner, this.context});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.fetch(this.bytesKey);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        EasyMock.expect((Object)this.inner.fetch((Object)this.bytesKey, (Object)this.bytesKey)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.fetch(this.bytesKey, this.bytesKey);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFindingSessions() {
        EasyMock.expect((Object)this.inner.findSessions((Object)this.bytesKey, 0L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.findSessions(this.bytesKey, 0L, 1L);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFindingSessionRange() {
        EasyMock.expect((Object)this.inner.findSessions((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L)).andReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        this.store.findSessions(this.bytesKey, this.bytesKey, 0L, 1L);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFlushUnderlyingStore() {
        this.inner.flush();
        EasyMock.expectLastCall();
        this.init();
        this.store.flush();
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldCloseUnderlyingStore() {
        this.inner.close();
        EasyMock.expectLastCall();
        this.init();
        this.store.close();
        EasyMock.verify((Object[])new Object[]{this.inner});
    }
}

