/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableRightJoin;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class KTableKTableRightJoinTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @Test
    public void shouldLogAndMeterSkippedRecordsDueToNullLeftKeyWithBuiltInMetricsVersion0100To24() {
        this.shouldLogAndMeterSkippedRecordsDueToNullLeftKey("0.10.0-2.4");
    }

    @Test
    public void shouldLogAndMeterSkippedRecordsDueToNullLeftKeyWithBuiltInMetricsVersionLatest() {
        this.shouldLogAndMeterSkippedRecordsDueToNullLeftKey("latest");
    }

    private void shouldLogAndMeterSkippedRecordsDueToNullLeftKey(String builtInMetricsVersion) {
        StreamsBuilder builder = new StreamsBuilder();
        Processor join = new KTableKTableRightJoin((KTableImpl)builder.table("left", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), (KTableImpl)builder.table("right", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())), null).get();
        this.props.setProperty("built.in.metrics.version", builtInMetricsVersion);
        MockProcessorContext context = new MockProcessorContext(this.props);
        context.setRecordMetadata("left", -1, -2L, null, -3L);
        join.init((ProcessorContext)context);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(KTableKTableRightJoin.class);){
            join.process(null, (Object)new Change((Object)"new", (Object)"old"));
            MatcherAssert.assertThat(appender.getMessages(), (Matcher)CoreMatchers.hasItem((Object)"Skipping record due to null key. change=[(new<-old)] topic=[left] partition=[-1] offset=[-2]"));
        }
        if ("0.10.0-2.4".equals(builtInMetricsVersion)) {
            Assert.assertEquals((Object)1.0, (Object)StreamsTestUtils.getMetricByName(context.metrics().metrics(), "skipped-records-total", "stream-metrics").metricValue());
        }
    }
}

