/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals.metrics;

import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.internals.metrics.ClientMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.easymock.EasyMock;
import org.junit.Test;
import org.powermock.api.easymock.PowerMock;

public class ClientMetricsTest {
    private static final String COMMIT_ID = "test-commit-ID";
    private static final String VERSION = "test-version";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)EasyMock.mock(StreamsMetricsImpl.class);

    @Test
    public void shouldAddVersionMetric() {
        String name = "version";
        String description = "The version of the Kafka Streams client";
        this.setUpAndVerifyImmutableMetric("version", "The version of the Kafka Streams client", VERSION, () -> ClientMetrics.addVersionMetric((StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldAddCommitIdMetric() {
        String name = "commit-id";
        String description = "The version control commit ID of the Kafka Streams client";
        this.setUpAndVerifyImmutableMetric("commit-id", "The version control commit ID of the Kafka Streams client", COMMIT_ID, () -> ClientMetrics.addCommitIdMetric((StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldAddApplicationIdMetric() {
        String name = "application-id";
        String description = "The application ID of the Kafka Streams client";
        String applicationId = "thisIsAnID";
        this.setUpAndVerifyImmutableMetric("application-id", "The application ID of the Kafka Streams client", "thisIsAnID", () -> ClientMetrics.addApplicationIdMetric((StreamsMetricsImpl)this.streamsMetrics, (String)"thisIsAnID"));
    }

    @Test
    public void shouldAddTopologyDescriptionMetric() {
        String name = "topology-description";
        String description = "The description of the topology executed in the Kafka Streams client";
        String topologyDescription = "thisIsATopologyDescription";
        this.setUpAndVerifyImmutableMetric("topology-description", "The description of the topology executed in the Kafka Streams client", "thisIsATopologyDescription", () -> ClientMetrics.addTopologyDescriptionMetric((StreamsMetricsImpl)this.streamsMetrics, (String)"thisIsATopologyDescription"));
    }

    @Test
    public void shouldAddStateMetric() {
        String name = "state";
        String description = "The state of the Kafka Streams client";
        Gauge stateProvider = (config, now) -> KafkaStreams.State.RUNNING;
        this.setUpAndVerifyMutableMetric("state", "The state of the Kafka Streams client", stateProvider, () -> ClientMetrics.addStateMetric((StreamsMetricsImpl)this.streamsMetrics, (Gauge)stateProvider));
    }

    @Test
    public void shouldAddAliveStreamThreadsMetric() {
        String name = "alive-stream-threads";
        String description = "The current number of alive stream threads that are running or participating in rebalance";
        Gauge valueProvider = (config, now) -> 1;
        this.setUpAndVerifyMutableMetric("alive-stream-threads", "The current number of alive stream threads that are running or participating in rebalance", valueProvider, () -> ClientMetrics.addNumAliveStreamThreadMetric((StreamsMetricsImpl)this.streamsMetrics, (Gauge)valueProvider));
    }

    private <K> void setUpAndVerifyMutableMetric(String name, String description, Gauge<K> valueProvider, Runnable metricAdder) {
        this.streamsMetrics.addClientLevelMutableMetric((String)EasyMock.eq((Object)name), (String)EasyMock.eq((Object)description), (Sensor.RecordingLevel)EasyMock.eq((Object)Sensor.RecordingLevel.INFO), (Gauge)EasyMock.eq(valueProvider));
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        metricAdder.run();
        PowerMock.verify((Object[])new Object[]{this.streamsMetrics});
    }

    private void setUpAndVerifyImmutableMetric(String name, String description, String value, Runnable metricAdder) {
        this.streamsMetrics.addClientLevelImmutableMetric((String)EasyMock.eq((Object)name), (String)EasyMock.eq((Object)description), (Sensor.RecordingLevel)EasyMock.eq((Object)Sensor.RecordingLevel.INFO), EasyMock.eq((Object)value));
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        metricAdder.run();
        PowerMock.verify((Object[])new Object[]{this.streamsMetrics});
    }
}

