/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig$;
import org.apache.kafka.streams.integration.AbstractResetIntegrationTest;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.test.IntegrationTest;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class ResetIntegrationTest
extends AbstractResetIntegrationTest {
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER;
    private static final String TEST_ID = "reset-integration-test";

    @Override
    Map<String, Object> getClientSslConfig() {
        return null;
    }

    @Before
    public void before() throws Exception {
        testId = TEST_ID;
        cluster = CLUSTER;
        this.prepareTest();
    }

    @After
    public void after() throws Exception {
        this.cleanupTest();
    }

    @Override
    @Test
    public void testReprocessingFromScratchAfterResetWithoutIntermediateUserTopic() throws Exception {
        super.testReprocessingFromScratchAfterResetWithoutIntermediateUserTopic();
    }

    @Override
    @Test
    public void testResetWhenLongSessionTimeoutConfiguredWithForceOption() throws Exception {
        super.testResetWhenLongSessionTimeoutConfiguredWithForceOption();
    }

    @Test
    public void testReprocessingFromScratchAfterResetWithIntermediateUserTopic() throws Exception {
        super.testReprocessingFromScratchAfterResetWithIntermediateUserTopic(false);
    }

    @Test
    public void testReprocessingFromScratchAfterResetWithIntermediateInternalTopic() throws Exception {
        super.testReprocessingFromScratchAfterResetWithIntermediateUserTopic(true);
    }

    @Override
    @Test
    public void testReprocessingFromFileAfterResetWithoutIntermediateUserTopic() throws Exception {
        super.testReprocessingFromFileAfterResetWithoutIntermediateUserTopic();
    }

    @Override
    @Test
    public void testReprocessingFromDateTimeAfterResetWithoutIntermediateUserTopic() throws Exception {
        super.testReprocessingFromDateTimeAfterResetWithoutIntermediateUserTopic();
    }

    @Override
    @Test
    public void testReprocessingByDurationAfterResetWithoutIntermediateUserTopic() throws Exception {
        super.testReprocessingByDurationAfterResetWithoutIntermediateUserTopic();
    }

    @Test
    public void shouldNotAllowToResetWhileStreamsRunning() {
        super.shouldNotAllowToResetWhileStreamsIsRunning();
    }

    @Override
    @Test
    public void shouldNotAllowToResetWhenInputTopicAbsent() throws Exception {
        super.shouldNotAllowToResetWhenInputTopicAbsent();
    }

    @Override
    @Test
    public void shouldNotAllowToResetWhenIntermediateTopicAbsent() throws Exception {
        super.shouldNotAllowToResetWhenIntermediateTopicAbsent();
    }

    static {
        Properties brokerProps = new Properties();
        brokerProps.put(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), (Object)-1L);
        CLUSTER = new EmbeddedKafkaCluster(1, brokerProps);
    }
}

