/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class StreamTableJoinNode<K, V>
extends StreamsGraphNode {
    private final String[] storeNames;
    private final ProcessorParameters<K, V> processorParameters;
    private final String otherJoinSideNodeName;

    public StreamTableJoinNode(String nodeName, ProcessorParameters<K, V> processorParameters, String[] storeNames, String otherJoinSideNodeName) {
        super(nodeName);
        this.storeNames = storeNames;
        this.processorParameters = processorParameters;
        this.otherJoinSideNodeName = otherJoinSideNodeName;
    }

    @Override
    public String toString() {
        return "StreamTableJoinNode{storeNames=" + Arrays.toString(this.storeNames) + ", processorParameters=" + this.processorParameters + ", otherJoinSideNodeName='" + this.otherJoinSideNodeName + '\'' + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String processorName = this.processorParameters.processorName();
        ProcessorSupplier<K, V> processorSupplier = this.processorParameters.processorSupplier();
        topologyBuilder.addProcessor(processorName, processorSupplier, this.parentNodeNames());
        if (this.otherJoinSideNodeName != null) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
    }
}

