/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public final class TimeWindows
extends Windows<TimeWindow> {
    private final long maintainDurationMs;
    public final long sizeMs;
    public final long advanceMs;
    private final long graceMs;

    private TimeWindows(long sizeMs, long advanceMs, long graceMs, long maintainDurationMs) {
        this.sizeMs = sizeMs;
        this.advanceMs = advanceMs;
        this.graceMs = graceMs;
        this.maintainDurationMs = maintainDurationMs;
    }

    @Deprecated
    private TimeWindows(long sizeMs, long advanceMs, long graceMs, long maintainDurationMs, int segments) {
        super(segments);
        this.sizeMs = sizeMs;
        this.advanceMs = advanceMs;
        this.graceMs = graceMs;
        this.maintainDurationMs = maintainDurationMs;
    }

    @Deprecated
    public static TimeWindows of(long sizeMs) throws IllegalArgumentException {
        if (sizeMs <= 0L) {
            throw new IllegalArgumentException("Window size (sizeMs) must be larger than zero.");
        }
        return new TimeWindows(sizeMs, sizeMs, -1L, 86400000L);
    }

    public static TimeWindows of(Duration size) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(size, "size");
        return TimeWindows.of(ApiUtils.validateMillisecondDuration(size, msgPrefix));
    }

    @Deprecated
    public TimeWindows advanceBy(long advanceMs) {
        if (advanceMs <= 0L || advanceMs > this.sizeMs) {
            throw new IllegalArgumentException(String.format("Window advancement interval should be more than zero and less than window duration which is %d ms, but given advancement interval is: %d ms", this.sizeMs, advanceMs));
        }
        return new TimeWindows(this.sizeMs, advanceMs, this.graceMs, this.maintainDurationMs, this.segments);
    }

    public TimeWindows advanceBy(Duration advance) {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(advance, "advance");
        return this.advanceBy(ApiUtils.validateMillisecondDuration(advance, msgPrefix));
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        LinkedHashMap<Long, TimeWindow> windows = new LinkedHashMap<Long, TimeWindow>();
        for (long windowStart = Math.max(0L, timestamp - this.sizeMs + this.advanceMs) / this.advanceMs * this.advanceMs; windowStart <= timestamp; windowStart += this.advanceMs) {
            TimeWindow window = new TimeWindow(windowStart, windowStart + this.sizeMs);
            windows.put(windowStart, window);
        }
        return windows;
    }

    @Override
    public long size() {
        return this.sizeMs;
    }

    public TimeWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, msgPrefix);
        if (afterWindowEndMs < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        return new TimeWindows(this.sizeMs, this.advanceMs, afterWindowEndMs, this.maintainDurationMs, this.segments);
    }

    @Override
    public long gracePeriodMs() {
        return this.graceMs != -1L ? this.graceMs : this.maintainMs() - this.size();
    }

    @Deprecated
    public TimeWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.sizeMs) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than the window size.");
        }
        return new TimeWindows(this.sizeMs, this.advanceMs, this.graceMs, durationMs, this.segments);
    }

    @Override
    @Deprecated
    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.sizeMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindows that = (TimeWindows)o;
        return this.maintainDurationMs == that.maintainDurationMs && this.segments == that.segments && this.sizeMs == that.sizeMs && this.advanceMs == that.advanceMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.maintainDurationMs, this.segments, this.sizeMs, this.advanceMs, this.graceMs);
    }

    public String toString() {
        return "TimeWindows{maintainDurationMs=" + this.maintainDurationMs + ", sizeMs=" + this.sizeMs + ", advanceMs=" + this.advanceMs + ", graceMs=" + this.graceMs + ", segments=" + this.segments + '}';
    }
}

