/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=Parameterized.class)
@PrepareForTest(value={StreamsMetricsImpl.class, Sensor.class})
public class StateStoreMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String STORE_NAME = "test-store";
    private static final String STORE_TYPE = "test-type";
    private static final String STORE_LEVEL_GROUP_FROM_0100_TO_24 = "stream-test-type-state-metrics";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String BUFFER_NAME = "test-buffer";
    private static final String BUFFER_LEVEL_GROUP_FROM_0100_TO_24 = "stream-buffer-metrics";
    private final Sensor expectedSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor parentSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createMock(StreamsMetricsImpl.class);
    private final Map<String, String> storeTagMap = Collections.singletonMap("hello", "world");
    private final Map<String, String> bufferTagMap = Collections.singletonMap("hi", "galaxy");
    private final Map<String, String> allTagMap = Collections.singletonMap("hello", "universe");
    private String storeLevelGroup;
    @Parameterized.Parameter
    public StreamsMetricsImpl.Version builtInMetricsVersion;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({StreamsMetricsImpl.Version.LATEST}, {StreamsMetricsImpl.Version.FROM_0100_TO_24});
    }

    @Before
    public void setUp() {
        this.storeLevelGroup = this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24 ? STORE_LEVEL_GROUP_FROM_0100_TO_24 : STORE_LEVEL_GROUP;
        EasyMock.expect((Object)this.streamsMetrics.version()).andReturn((Object)this.builtInMetricsVersion).anyTimes();
        PowerMock.mockStatic(StreamsMetricsImpl.class);
    }

    @Test
    public void shouldGetPutSensor() {
        String metricName = "put";
        String descriptionOfRate = "The average number of calls to put per second";
        String descriptionOfCount = "The total number of calls to put";
        String descriptionOfAvg = "The average latency of calls to put";
        String descriptionOfMax = "The maximum latency of calls to put";
        this.shouldGetSensor("put", "The average number of calls to put per second", "The total number of calls to put", "The average latency of calls to put", "The maximum latency of calls to put", () -> StateStoreMetrics.putSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetPutIfAbsentSensor() {
        String metricName = "put-if-absent";
        String descriptionOfRate = "The average number of calls to put-if-absent per second";
        String descriptionOfCount = "The total number of calls to put-if-absent";
        String descriptionOfAvg = "The average latency of calls to put-if-absent";
        String descriptionOfMax = "The maximum latency of calls to put-if-absent";
        this.shouldGetSensor("put-if-absent", "The average number of calls to put-if-absent per second", "The total number of calls to put-if-absent", "The average latency of calls to put-if-absent", "The maximum latency of calls to put-if-absent", () -> StateStoreMetrics.putIfAbsentSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetPutAllSensor() {
        String metricName = "put-all";
        String descriptionOfRate = "The average number of calls to put-all per second";
        String descriptionOfCount = "The total number of calls to put-all";
        String descriptionOfAvg = "The average latency of calls to put-all";
        String descriptionOfMax = "The maximum latency of calls to put-all";
        this.shouldGetSensor("put-all", "The average number of calls to put-all per second", "The total number of calls to put-all", "The average latency of calls to put-all", "The maximum latency of calls to put-all", () -> StateStoreMetrics.putAllSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetFetchSensor() {
        String metricName = "fetch";
        String descriptionOfRate = "The average number of calls to fetch per second";
        String descriptionOfCount = "The total number of calls to fetch";
        String descriptionOfAvg = "The average latency of calls to fetch";
        String descriptionOfMax = "The maximum latency of calls to fetch";
        this.shouldGetSensor("fetch", "The average number of calls to fetch per second", "The total number of calls to fetch", "The average latency of calls to fetch", "The maximum latency of calls to fetch", () -> StateStoreMetrics.fetchSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetGetSensor() {
        String metricName = "get";
        String descriptionOfRate = "The average number of calls to get per second";
        String descriptionOfCount = "The total number of calls to get";
        String descriptionOfAvg = "The average latency of calls to get";
        String descriptionOfMax = "The maximum latency of calls to get";
        this.shouldGetSensor("get", "The average number of calls to get per second", "The total number of calls to get", "The average latency of calls to get", "The maximum latency of calls to get", () -> StateStoreMetrics.getSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetAllSensor() {
        String metricName = "all";
        String descriptionOfRate = "The average number of calls to all per second";
        String descriptionOfCount = "The total number of calls to all";
        String descriptionOfAvg = "The average latency of calls to all";
        String descriptionOfMax = "The maximum latency of calls to all";
        this.shouldGetSensor("all", "The average number of calls to all per second", "The total number of calls to all", "The average latency of calls to all", "The maximum latency of calls to all", () -> StateStoreMetrics.allSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetRangeSensor() {
        String metricName = "range";
        String descriptionOfRate = "The average number of calls to range per second";
        String descriptionOfCount = "The total number of calls to range";
        String descriptionOfAvg = "The average latency of calls to range";
        String descriptionOfMax = "The maximum latency of calls to range";
        this.shouldGetSensor("range", "The average number of calls to range per second", "The total number of calls to range", "The average latency of calls to range", "The maximum latency of calls to range", () -> StateStoreMetrics.rangeSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetFlushSensor() {
        String metricName = "flush";
        String descriptionOfRate = "The average number of calls to flush per second";
        String descriptionOfCount = "The total number of calls to flush";
        String descriptionOfAvg = "The average latency of calls to flush";
        String descriptionOfMax = "The maximum latency of calls to flush";
        this.shouldGetSensor("flush", "The average number of calls to flush per second", "The total number of calls to flush", "The average latency of calls to flush", "The maximum latency of calls to flush", () -> StateStoreMetrics.flushSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetRemoveSensor() {
        String metricName = "remove";
        String descriptionOfRate = "The average number of calls to remove per second";
        String descriptionOfCount = "The total number of calls to remove";
        String descriptionOfAvg = "The average latency of calls to remove";
        String descriptionOfMax = "The maximum latency of calls to remove";
        this.shouldGetSensor("remove", "The average number of calls to remove per second", "The total number of calls to remove", "The average latency of calls to remove", "The maximum latency of calls to remove", () -> StateStoreMetrics.removeSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetDeleteSensor() {
        String metricName = "delete";
        String descriptionOfRate = "The average number of calls to delete per second";
        String descriptionOfCount = "The total number of calls to delete";
        String descriptionOfAvg = "The average latency of calls to delete";
        String descriptionOfMax = "The maximum latency of calls to delete";
        this.shouldGetSensor("delete", "The average number of calls to delete per second", "The total number of calls to delete", "The average latency of calls to delete", "The maximum latency of calls to delete", () -> StateStoreMetrics.deleteSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetRestoreSensor() {
        String metricName = "restore";
        String descriptionOfRate = "The average number of restorations per second";
        String descriptionOfCount = "The total number of restorations";
        String descriptionOfAvg = "The average latency of restorations";
        String descriptionOfMax = "The maximum latency of restorations";
        this.shouldGetSensor("restore", "The average number of restorations per second", "The total number of restorations", "The average latency of restorations", "The maximum latency of restorations", () -> StateStoreMetrics.restoreSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetSuppressionBufferCountSensor() {
        String metricName = "suppression-buffer-count";
        String descriptionOfCurrentValue = "The current count of buffered records";
        String descriptionOfAvg = "The average count of buffered records";
        String descriptionOfMax = "The maximum count of buffered records";
        this.shouldGetSuppressionBufferSensor("suppression-buffer-count", "The current count of buffered records", "The average count of buffered records", "The maximum count of buffered records", () -> StateStoreMetrics.suppressionBufferCountSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)BUFFER_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetSuppressionBufferSizeSensor() {
        String metricName = "suppression-buffer-size";
        String descriptionOfCurrentValue = "The current size of buffered records";
        String descriptionOfAvg = "The average size of buffered records";
        String descriptionOfMax = "The maximum size of buffered records";
        this.shouldGetSuppressionBufferSensor("suppression-buffer-size", "The current size of buffered records", "The average size of buffered records", "The maximum size of buffered records", () -> StateStoreMetrics.suppressionBufferSizeSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)BUFFER_NAME, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetExpiredWindowRecordDropSensor() {
        String metricName = "expired-window-record-drop";
        String descriptionOfRate = "The average number of dropped records due to an expired window per second";
        String descriptionOfCount = "The total number of dropped records due to an expired window";
        EasyMock.expect((Object)this.streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, "expired-window-record-drop", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, STORE_TYPE, STORE_NAME)).andReturn(this.storeTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-test-type-metrics", this.storeTagMap, (String)"expired-window-record-drop", (String)"The average number of dropped records due to an expired window per second", (String)"The total number of dropped records due to an expired window");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = StateStoreMetrics.expiredWindowRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)STORE_TYPE, (String)STORE_NAME, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    private void shouldGetSensor(String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Supplier<Sensor> sensorSupplier) {
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            this.setUpParentSensor(metricName, descriptionOfRate, descriptionOfCount, descriptionOfAvg, descriptionOfMax);
            EasyMock.expect((Object)this.streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[]{this.parentSensor})).andReturn((Object)this.expectedSensor);
            StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.storeLevelGroup, this.storeTagMap, (String)metricName, (String)descriptionOfRate, (String)descriptionOfCount);
        } else {
            EasyMock.expect((Object)this.streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
            StreamsMetricsImpl.addInvocationRateToSensor((Sensor)this.expectedSensor, (String)this.storeLevelGroup, this.storeTagMap, (String)metricName, (String)descriptionOfRate);
        }
        EasyMock.expect((Object)this.streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, STORE_TYPE, STORE_NAME)).andReturn(this.storeTagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.storeLevelGroup, this.storeTagMap, (String)this.latencyMetricName(metricName), (String)descriptionOfAvg, (String)descriptionOfMax);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = sensorSupplier.get();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    private void setUpParentSensor(String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax) {
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.parentSensor);
        EasyMock.expect((Object)this.streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, STORE_TYPE, "all")).andReturn(this.allTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.parentSensor, (String)this.storeLevelGroup, this.allTagMap, (String)metricName, (String)descriptionOfRate, (String)descriptionOfCount);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.parentSensor, (String)this.storeLevelGroup, this.allTagMap, (String)this.latencyMetricName(metricName), (String)descriptionOfAvg, (String)descriptionOfMax);
    }

    private String latencyMetricName(String metricName) {
        return metricName + "-latency";
    }

    private void shouldGetSuppressionBufferSensor(String metricName, String descriptionOfCurrentValue, String descriptionOfAvg, String descriptionOfMax, Supplier<Sensor> sensorSupplier) {
        Map<String, String> tagMap;
        String group;
        String currentMetricName = metricName + "-current";
        EasyMock.expect((Object)this.streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, BUFFER_NAME, metricName, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            group = BUFFER_LEVEL_GROUP_FROM_0100_TO_24;
            tagMap = this.bufferTagMap;
            EasyMock.expect((Object)this.streamsMetrics.bufferLevelTagMap(THREAD_ID, TASK_ID, BUFFER_NAME)).andReturn(tagMap);
            StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)group, this.bufferTagMap, (String)currentMetricName, (String)descriptionOfCurrentValue);
        } else {
            group = STORE_LEVEL_GROUP;
            tagMap = this.storeTagMap;
            EasyMock.expect((Object)this.streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, STORE_TYPE, BUFFER_NAME)).andReturn(tagMap);
        }
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)group, tagMap, (String)metricName, (String)descriptionOfAvg, (String)descriptionOfMax);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = sensorSupplier.get();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

