/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StreamsMetricsImpl.class})
public class RocksDBMetricsTest {
    private static final String STATE_LEVEL_GROUP = "stream-state-metrics";
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String STORE_TYPE = "test-store-type";
    private static final String STORE_NAME = "store";
    private final Metrics metrics = new Metrics();
    private final Sensor sensor = this.metrics.sensor("dummy");
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createStrictMock(StreamsMetricsImpl.class);
    private final Map<String, String> tags = Collections.singletonMap("hello", "world");

    @Test
    public void shouldGetBytesWrittenSensor() {
        String metricNamePrefix = "bytes-written";
        String descriptionOfTotal = "Total number of bytes written to the RocksDB state store";
        String descriptionOfRate = "Average number of bytes written per second to the RocksDB state store";
        this.verifyRateAndTotalSensor("bytes-written", "Total number of bytes written to the RocksDB state store", "Average number of bytes written per second to the RocksDB state store", RocksDBMetrics::bytesWrittenToDatabaseSensor);
    }

    @Test
    public void shouldGetBytesReadSensor() {
        String metricNamePrefix = "bytes-read";
        String descriptionOfTotal = "Total number of bytes read from the RocksDB state store";
        String descriptionOfRate = "Average number of bytes read per second from the RocksDB state store";
        this.verifyRateAndTotalSensor("bytes-read", "Total number of bytes read from the RocksDB state store", "Average number of bytes read per second from the RocksDB state store", RocksDBMetrics::bytesReadFromDatabaseSensor);
    }

    @Test
    public void shouldGetMemtableHitRatioSensor() {
        String metricNamePrefix = "memtable-hit-ratio";
        String description = "Ratio of memtable hits relative to all lookups to the memtable";
        this.verifyValueSensor("memtable-hit-ratio", "Ratio of memtable hits relative to all lookups to the memtable", RocksDBMetrics::memtableHitRatioSensor);
    }

    @Test
    public void shouldGetMemtableBytesFlushedSensor() {
        String metricNamePrefix = "memtable-bytes-flushed";
        String descriptionOfTotal = "Total number of bytes flushed from the memtable to disk";
        String descriptionOfRate = "Average number of bytes flushed per second from the memtable to disk";
        this.verifyRateAndTotalSensor("memtable-bytes-flushed", "Total number of bytes flushed from the memtable to disk", "Average number of bytes flushed per second from the memtable to disk", RocksDBMetrics::memtableBytesFlushedSensor);
    }

    @Test
    public void shouldGetMemtableAvgFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-avg";
        String description = "Average time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-avg", "Average time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableAvgFlushTimeSensor);
    }

    @Test
    public void shouldGetMemtableMinFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-min";
        String description = "Minimum time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-min", "Minimum time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableMinFlushTimeSensor);
    }

    @Test
    public void shouldGetMemtableMaxFlushTimeSensor() {
        String metricNamePrefix = "memtable-flush-time-max";
        String description = "Maximum time spent on flushing the memtable to disk in ms";
        this.verifyValueSensor("memtable-flush-time-max", "Maximum time spent on flushing the memtable to disk in ms", RocksDBMetrics::memtableMaxFlushTimeSensor);
    }

    @Test
    public void shouldGetWriteStallDurationSensor() {
        String metricNamePrefix = "write-stall-duration";
        String descriptionOfAvg = "Average duration of write stalls in ms";
        String descriptionOfTotal = "Total duration of write stalls in ms";
        this.setupStreamsMetricsMock("write-stall-duration");
        StreamsMetricsImpl.addAvgAndSumMetricsToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)"write-stall-duration", (String)"Average duration of write stalls in ms", (String)"Total duration of write stalls in ms");
        this.replayCallAndVerify(RocksDBMetrics::writeStallDurationSensor);
    }

    @Test
    public void shouldGetBlockCacheDataHitRatioSensor() {
        String metricNamePrefix = "block-cache-data-hit-ratio";
        String description = "Ratio of block cache hits for data relative to all lookups for data to the block cache";
        this.verifyValueSensor("block-cache-data-hit-ratio", "Ratio of block cache hits for data relative to all lookups for data to the block cache", RocksDBMetrics::blockCacheDataHitRatioSensor);
    }

    @Test
    public void shouldGetBlockCacheIndexHitRatioSensor() {
        String metricNamePrefix = "block-cache-index-hit-ratio";
        String description = "Ratio of block cache hits for indexes relative to all lookups for indexes to the block cache";
        this.verifyValueSensor("block-cache-index-hit-ratio", "Ratio of block cache hits for indexes relative to all lookups for indexes to the block cache", RocksDBMetrics::blockCacheIndexHitRatioSensor);
    }

    @Test
    public void shouldGetBlockCacheFilterHitRatioSensor() {
        String metricNamePrefix = "block-cache-filter-hit-ratio";
        String description = "Ratio of block cache hits for filters relative to all lookups for filters to the block cache";
        this.verifyValueSensor("block-cache-filter-hit-ratio", "Ratio of block cache hits for filters relative to all lookups for filters to the block cache", RocksDBMetrics::blockCacheFilterHitRatioSensor);
    }

    @Test
    public void shouldGetBytesReadDuringCompactionSensor() {
        String metricNamePrefix = "bytes-read-compaction";
        String description = "Average number of bytes read per second during compaction";
        this.verifyRateSensor("bytes-read-compaction", "Average number of bytes read per second during compaction", RocksDBMetrics::bytesReadDuringCompactionSensor);
    }

    @Test
    public void shouldGetBytesWrittenDuringCompactionSensor() {
        String metricNamePrefix = "bytes-written-compaction";
        String description = "Average number of bytes written per second during compaction";
        this.verifyRateSensor("bytes-written-compaction", "Average number of bytes written per second during compaction", RocksDBMetrics::bytesWrittenDuringCompactionSensor);
    }

    @Test
    public void shouldGetCompactionTimeAvgSensor() {
        String metricNamePrefix = "compaction-time-avg";
        String description = "Average time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-avg", "Average time spent on compaction in ms", RocksDBMetrics::compactionTimeAvgSensor);
    }

    @Test
    public void shouldGetCompactionTimeMinSensor() {
        String metricNamePrefix = "compaction-time-min";
        String description = "Minimum time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-min", "Minimum time spent on compaction in ms", RocksDBMetrics::compactionTimeMinSensor);
    }

    @Test
    public void shouldGetCompactionTimeMaxSensor() {
        String metricNamePrefix = "compaction-time-max";
        String description = "Maximum time spent on compaction in ms";
        this.verifyValueSensor("compaction-time-max", "Maximum time spent on compaction in ms", RocksDBMetrics::compactionTimeMaxSensor);
    }

    @Test
    public void shouldGetNumberOfOpenFilesSensor() {
        String metricNamePrefix = "number-open-files";
        String description = "Number of currently open files";
        this.verifySumSensor("number-open-files", false, "Number of currently open files", RocksDBMetrics::numberOfOpenFilesSensor);
    }

    @Test
    public void shouldGetNumberOfFilesErrors() {
        String metricNamePrefix = "number-file-errors";
        String description = "Total number of file errors occurred";
        this.verifySumSensor("number-file-errors", true, "Total number of file errors occurred", RocksDBMetrics::numberOfFileErrorsSensor);
    }

    private void verifyRateAndTotalSensor(String metricNamePrefix, String descriptionOfTotal, String descriptionOfRate, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfTotal);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifyRateSensor(String metricNamePrefix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addRateOfSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifyValueSensor(String metricNamePrefix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        this.replayCallAndVerify(sensorCreator);
    }

    private void verifySumSensor(String metricNamePrefix, boolean withSuffix, String description, SensorCreator sensorCreator) {
        this.setupStreamsMetricsMock(metricNamePrefix);
        if (withSuffix) {
            StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (String)description);
        } else {
            StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)STATE_LEVEL_GROUP, this.tags, (String)metricNamePrefix, (boolean)withSuffix, (String)description);
        }
        this.replayCallAndVerify(sensorCreator);
    }

    private void setupStreamsMetricsMock(String metricNamePrefix) {
        PowerMock.mockStatic(StreamsMetricsImpl.class);
        EasyMock.expect((Object)this.streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, STORE_NAME, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.sensor);
        EasyMock.expect((Object)this.streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, STORE_TYPE, STORE_NAME)).andReturn(this.tags);
    }

    private void replayCallAndVerify(SensorCreator sensorCreator) {
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class});
        Sensor sensor = sensorCreator.sensor(this.streamsMetrics, new RocksDBMetrics.RocksDBMetricContext(THREAD_ID, TASK_ID, STORE_TYPE, STORE_NAME));
        PowerMock.verifyAll();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.sensor));
    }

    private static interface SensorCreator {
        public Sensor sensor(StreamsMetricsImpl var1, RocksDBMetrics.RocksDBMetricContext var2);
    }
}

