/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetrics;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TickerType;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={RocksDBMetrics.class, Sensor.class})
public class RocksDBMetricsRecorderTest {
    private static final String METRICS_SCOPE = "metrics-scope";
    private static final String THREAD_ID = "thread-id";
    private static final String STORE_NAME = "store-name";
    private static final String SEGMENT_STORE_NAME_1 = "segment-store-name-1";
    private static final String SEGMENT_STORE_NAME_2 = "segment-store-name-2";
    private final Statistics statisticsToAdd1 = (Statistics)EasyMock.mock(Statistics.class);
    private final Statistics statisticsToAdd2 = (Statistics)EasyMock.mock(Statistics.class);
    private final Sensor bytesWrittenToDatabaseSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesReadFromDatabaseSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableBytesFlushedSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor memtableHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor writeStallDurationSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheDataHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheIndexHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor blockCacheFilterHitRatioSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesReadDuringCompactionSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor bytesWrittenDuringCompactionSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor numberOfOpenFilesSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Sensor numberOfFileErrorsSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)EasyMock.niceMock(StreamsMetricsImpl.class);
    private final RocksDBMetricsRecordingTrigger recordingTrigger = (RocksDBMetricsRecordingTrigger)EasyMock.mock(RocksDBMetricsRecordingTrigger.class);
    private final TaskId taskId1 = new TaskId(0, 0);
    private final TaskId taskId2 = new TaskId(0, 1);
    private final RocksDBMetricsRecorder recorder = new RocksDBMetricsRecorder("metrics-scope", "thread-id", "store-name");

    @Before
    public void setUp() {
        this.setUpMetricsStubMock();
        EasyMock.expect((Object)this.streamsMetrics.rocksDBMetricsRecordingTrigger()).andStubReturn((Object)this.recordingTrigger);
        PowerMock.replay((Object[])new Object[]{this.streamsMetrics});
        this.recorder.init(this.streamsMetrics, this.taskId1);
    }

    @Test
    public void shouldInitMetricsRecorder() {
        this.setUpMetricsMock();
        this.recorder.init(this.streamsMetrics, this.taskId1);
        PowerMock.verify((Object[])new Object[]{RocksDBMetrics.class});
        MatcherAssert.assertThat((Object)this.recorder.taskId(), (Matcher)CoreMatchers.is((Object)this.taskId1));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentTask() {
        this.setUpMetricsStubMock();
        this.recorder.init(this.streamsMetrics, this.taskId1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.init(this.streamsMetrics, this.taskId2));
    }

    @Test
    public void shouldThrowIfMetricRecorderIsReInitialisedWithDifferentStreamsMetrics() {
        this.setUpMetricsStubMock();
        this.recorder.init(this.streamsMetrics, this.taskId1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.init(new StreamsMetricsImpl(new Metrics(), "test-client", "latest"), this.taskId1));
    }

    @Test
    public void shouldSetStatsLevelToExceptDetailedTimersWhenStatisticsIsAdded() {
        this.statisticsToAdd1.setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldThrowIfStatisticsToAddHasBeenAlreadyAdded() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1));
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstStatisticsIsAddedToNewlyCreatedRecorder() {
        this.recordingTrigger.addMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldAddItselfToRecordingTriggerWhenFirstStatisticsIsAddedAfterLastStatisticsWasRemoved() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        this.recorder.removeStatistics(SEGMENT_STORE_NAME_1);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        this.recordingTrigger.addMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addStatistics(SEGMENT_STORE_NAME_2, this.statisticsToAdd2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldNotAddItselfToRecordingTriggerWhenNotEmpty() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.addStatistics(SEGMENT_STORE_NAME_2, this.statisticsToAdd2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldCloseStatisticsWhenStatisticsIsRemoved() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        this.statisticsToAdd1.close();
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.removeStatistics(SEGMENT_STORE_NAME_1);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
    }

    @Test
    public void shouldRemoveItselfFromRecordingTriggerWhenLastStatisticsIsRemoved() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        this.recorder.addStatistics(SEGMENT_STORE_NAME_2, this.statisticsToAdd2);
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.removeStatistics(SEGMENT_STORE_NAME_1);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
        PowerMock.reset((Object[])new Object[]{this.recordingTrigger});
        this.recordingTrigger.removeMetricsRecorder(this.recorder);
        PowerMock.replay((Object[])new Object[]{this.recordingTrigger});
        this.recorder.removeStatistics(SEGMENT_STORE_NAME_2);
        PowerMock.verify((Object[])new Object[]{this.recordingTrigger});
    }

    @Test
    public void shouldThrowIfStatisticsToRemoveNotFound() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        Assert.assertThrows(IllegalStateException.class, () -> this.recorder.removeStatistics(SEGMENT_STORE_NAME_2));
    }

    @Test
    public void shouldRecordMetrics() {
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        this.recorder.addStatistics(SEGMENT_STORE_NAME_2, this.statisticsToAdd2);
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.reset((Object[])new Object[]{this.statisticsToAdd2});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).andReturn((Object)1L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_WRITTEN)).andReturn((Object)2L);
        this.bytesWrittenToDatabaseSensor.record(3.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesWrittenToDatabaseSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BYTES_READ)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BYTES_READ)).andReturn((Object)3L);
        this.bytesReadFromDatabaseSensor.record(5.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesReadFromDatabaseSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.FLUSH_WRITE_BYTES)).andReturn((Object)4L);
        this.memtableBytesFlushedSensor.record(7.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableBytesFlushedSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).andReturn((Object)1L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.MEMTABLE_MISS)).andReturn((Object)4L);
        this.memtableHitRatioSensor.record(0.4, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.STALL_MICROS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.STALL_MICROS)).andReturn((Object)5L);
        this.writeStallDurationSensor.record(9.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.writeStallDurationSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_DATA_MISS)).andReturn((Object)2L);
        this.blockCacheDataHitRatioSensor.record(0.5714285714285714, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_HIT)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_INDEX_MISS)).andReturn((Object)4L);
        this.blockCacheIndexHitRatioSensor.record(0.5, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).andReturn((Object)4L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_HIT)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.BLOCK_CACHE_FILTER_MISS)).andReturn((Object)5L);
        this.blockCacheFilterHitRatioSensor.record(0.35714285714285715, 0L);
        PowerMock.replay((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).andReturn((Object)2L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_WRITE_BYTES)).andReturn((Object)4L);
        this.bytesWrittenDuringCompactionSensor.record(6.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesWrittenDuringCompactionSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.COMPACT_READ_BYTES)).andReturn((Object)6L);
        this.bytesReadDuringCompactionSensor.record(11.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.bytesReadDuringCompactionSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).andReturn((Object)5L);
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).andReturn((Object)3L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_OPENS)).andReturn((Object)7L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_CLOSES)).andReturn((Object)4L);
        this.numberOfOpenFilesSensor.record(5.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.numberOfOpenFilesSensor});
        EasyMock.expect((Object)this.statisticsToAdd1.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).andReturn((Object)34L);
        EasyMock.expect((Object)this.statisticsToAdd2.getAndResetTickerCount(TickerType.NO_FILE_ERRORS)).andReturn((Object)11L);
        this.numberOfFileErrorsSensor.record(45.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.numberOfFileErrorsSensor});
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd2});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd1});
        PowerMock.verify((Object[])new Object[]{this.statisticsToAdd2});
        PowerMock.verify((Object[])new Object[]{this.bytesWrittenToDatabaseSensor});
    }

    @Test
    public void shouldCorrectlyHandleHitRatioRecordingsWithZeroHitsAndMisses() {
        EasyMock.resetToNice((Object[])new Object[]{this.statisticsToAdd1});
        this.recorder.addStatistics(SEGMENT_STORE_NAME_1, this.statisticsToAdd1);
        EasyMock.expect((Object)this.statisticsToAdd1.getTickerCount((TickerType)EasyMock.anyObject())).andStubReturn((Object)0L);
        PowerMock.replay((Object[])new Object[]{this.statisticsToAdd1});
        this.memtableHitRatioSensor.record(0.0, 0L);
        this.blockCacheDataHitRatioSensor.record(0.0, 0L);
        this.blockCacheIndexHitRatioSensor.record(0.0, 0L);
        this.blockCacheFilterHitRatioSensor.record(0.0, 0L);
        PowerMock.replay((Object[])new Object[]{this.memtableHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        PowerMock.replay((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
        this.recorder.record(0L);
        PowerMock.verify((Object[])new Object[]{this.memtableHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheDataHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheIndexHitRatioSensor});
        PowerMock.verify((Object[])new Object[]{this.blockCacheFilterHitRatioSensor});
    }

    private void setUpMetricsMock() {
        PowerMock.mockStatic(RocksDBMetrics.class);
        RocksDBMetrics.RocksDBMetricContext metricsContext = new RocksDBMetrics.RocksDBMetricContext(THREAD_ID, this.taskId1.toString(), METRICS_SCOPE, STORE_NAME);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesWrittenToDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesReadFromDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableBytesFlushedSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.memtableHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.writeStallDurationSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheDataHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheIndexHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.blockCacheFilterHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesWrittenDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.bytesReadDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.numberOfOpenFilesSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)((StreamsMetricsImpl)EasyMock.eq((Object)this.streamsMetrics)), (RocksDBMetrics.RocksDBMetricContext)((RocksDBMetrics.RocksDBMetricContext)EasyMock.eq((Object)metricsContext)))).andReturn((Object)this.numberOfFileErrorsSensor);
        PowerMock.replay((Object[])new Object[]{RocksDBMetrics.class});
    }

    private void setUpMetricsStubMock() {
        PowerMock.mockStatic(RocksDBMetrics.class);
        RocksDBMetrics.RocksDBMetricContext metricsContext = new RocksDBMetrics.RocksDBMetricContext(THREAD_ID, this.taskId1.toString(), METRICS_SCOPE, STORE_NAME);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenToDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesWrittenToDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadFromDatabaseSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesReadFromDatabaseSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableBytesFlushedSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableBytesFlushedSensor);
        EasyMock.expect((Object)RocksDBMetrics.memtableHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.memtableHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.writeStallDurationSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.writeStallDurationSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheDataHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheDataHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheIndexHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheIndexHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.blockCacheFilterHitRatioSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.blockCacheFilterHitRatioSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesWrittenDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesWrittenDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.bytesReadDuringCompactionSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.bytesReadDuringCompactionSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfOpenFilesSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.numberOfOpenFilesSensor);
        EasyMock.expect((Object)RocksDBMetrics.numberOfFileErrorsSensor((StreamsMetricsImpl)this.streamsMetrics, (RocksDBMetrics.RocksDBMetricContext)metricsContext)).andStubReturn((Object)this.numberOfFileErrorsSensor);
        PowerMock.replay((Object[])new Object[]{RocksDBMetrics.class});
    }
}

