/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=Parameterized.class)
@PrepareForTest(value={StreamsMetricsImpl.class, Sensor.class})
public class ThreadMetricsTest {
    private static final String THREAD_ID = "thread-id";
    private static final String THREAD_LEVEL_GROUP_0100_TO_24 = "stream-metrics";
    private static final String THREAD_LEVEL_GROUP = "stream-thread-metrics";
    private static final String TASK_LEVEL_GROUP = "stream-task-metrics";
    private final Sensor expectedSensor = (Sensor)EasyMock.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createMock(StreamsMetricsImpl.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");
    @Parameterized.Parameter
    public StreamsMetricsImpl.Version builtInMetricsVersion;
    @Parameterized.Parameter(value=1)
    public String threadLevelGroup;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({StreamsMetricsImpl.Version.LATEST, THREAD_LEVEL_GROUP}, {StreamsMetricsImpl.Version.FROM_0100_TO_24, THREAD_LEVEL_GROUP_0100_TO_24});
    }

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.streamsMetrics.version()).andReturn((Object)this.builtInMetricsVersion).anyTimes();
        PowerMock.mockStatic(StreamsMetricsImpl.class);
    }

    @Test
    public void shouldGetProcessRatioSensor() {
        String operation = "process-ratio";
        String ratioDescription = "The fraction of time the thread spent on processing active tasks";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"process-ratio", (String)"The fraction of time the thread spent on processing active tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.processRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessRecordsSensor() {
        String operation = "process-records";
        String avgDescription = "The average number of records processed within an iteration";
        String maxDescription = "The maximum number of records processed within an iteration";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-records", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"process-records", (String)"The average number of records processed within an iteration", (String)"The maximum number of records processed within an iteration");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.processRecordsSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessLatencySensor() {
        String operationLatency = "process-latency";
        String avgLatencyDescription = "The average process latency";
        String maxLatencyDescription = "The maximum process latency";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-latency", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"process-latency", (String)"The average process latency", (String)"The maximum process latency");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics, this.expectedSensor});
        Sensor sensor = ThreadMetrics.processLatencySensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessRateSensor() {
        String operation = "process";
        String operationRate = "process-rate";
        String totalDescription = "The total number of calls to process";
        String rateDescription = "The average per-second number of calls to process";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "process-rate", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"process", (String)"The average per-second number of calls to process", (String)"The total number of calls to process");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics, this.expectedSensor});
        Sensor sensor = ThreadMetrics.processRateSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollRatioSensor() {
        String operation = "poll-ratio";
        String ratioDescription = "The fraction of time the thread spent on polling records from consumer";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"poll-ratio", (String)"The fraction of time the thread spent on polling records from consumer");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.pollRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollRecordsSensor() {
        String operation = "poll-records";
        String avgDescription = "The average number of records polled from consumer within an iteration";
        String maxDescription = "The maximum number of records polled from consumer within an iteration";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll-records", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"poll-records", (String)"The average number of records polled from consumer within an iteration", (String)"The maximum number of records polled from consumer within an iteration");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.pollRecordsSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPollSensor() {
        String operation = "poll";
        String operationLatency = "poll-latency";
        String totalDescription = "The total number of calls to poll";
        String rateDescription = "The average per-second number of calls to poll";
        String avgLatencyDescription = "The average poll latency";
        String maxLatencyDescription = "The maximum poll latency";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "poll", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"poll", (String)"The average per-second number of calls to poll", (String)"The total number of calls to poll");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"poll-latency", (String)"The average poll latency", (String)"The maximum poll latency");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.pollSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitSensor() {
        String operation = "commit";
        String operationLatency = "commit-latency";
        String totalDescription = "The total number of calls to commit";
        String rateDescription = "The average per-second number of calls to commit";
        String avgLatencyDescription = "The average commit latency";
        String maxLatencyDescription = "The maximum commit latency";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"commit", (String)"The average per-second number of calls to commit", (String)"The total number of calls to commit");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"commit-latency", (String)"The average commit latency", (String)"The maximum commit latency");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.commitSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitRatioSensor() {
        String operation = "commit-ratio";
        String ratioDescription = "The fraction of time the thread spent on committing all tasks";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"commit-ratio", (String)"The fraction of time the thread spent on committing all tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.commitRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitOverTasksSensor() {
        String operation = "commit";
        String operationLatency = "commit-latency";
        String totalDescription = "The total number of calls to commit over all tasks assigned to one stream thread";
        String rateDescription = "The average per-second number of calls to commit over all tasks assigned to one stream thread";
        String avgLatencyDescription = "The average commit latency over all tasks assigned to one stream thread";
        String maxLatencyDescription = "The maximum commit latency over all tasks assigned to one stream thread";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "commit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, "all")).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)TASK_LEVEL_GROUP, this.tagMap, (String)"commit", (String)"The average per-second number of calls to commit over all tasks assigned to one stream thread", (String)"The total number of calls to commit over all tasks assigned to one stream thread");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.commitOverTasksSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String operation = "punctuate";
        String operationLatency = "punctuate-latency";
        String totalDescription = "The total number of calls to punctuate";
        String rateDescription = "The average per-second number of calls to punctuate";
        String avgLatencyDescription = "The average punctuate latency";
        String maxLatencyDescription = "The maximum punctuate latency";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "punctuate", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"punctuate", (String)"The average per-second number of calls to punctuate", (String)"The total number of calls to punctuate");
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"punctuate-latency", (String)"The average punctuate latency", (String)"The maximum punctuate latency");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.punctuateSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPunctuateRatioSensor() {
        String operation = "punctuate-ratio";
        String ratioDescription = "The fraction of time the thread spent on punctuating active tasks";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "punctuate-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"punctuate-ratio", (String)"The fraction of time the thread spent on punctuating active tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.punctuateRatioSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetSkipRecordSensor() {
        String operation = "skipped-records";
        String totalDescription = "The total number of skipped records";
        String rateDescription = "The average per-second number of skipped records";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "skipped-records", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"skipped-records", (String)"The average per-second number of skipped records", (String)"The total number of skipped records");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.skipRecordSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCreateTaskSensor() {
        String operation = "task-created";
        String totalDescription = "The total number of newly created tasks";
        String rateDescription = "The average per-second number of newly created tasks";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-created", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"task-created", (String)"The average per-second number of newly created tasks", (String)"The total number of newly created tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.createTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCloseTaskSensor() {
        String operation = "task-closed";
        String totalDescription = "The total number of closed tasks";
        String rateDescription = "The average per-second number of closed tasks";
        EasyMock.expect((Object)this.streamsMetrics.threadLevelSensor(THREAD_ID, "task-closed", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.threadLevelTagMap(THREAD_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)this.threadLevelGroup, this.tagMap, (String)"task-closed", (String)"The average per-second number of closed tasks", (String)"The total number of closed tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = ThreadMetrics.closeTaskSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

