/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=Parameterized.class)
@PrepareForTest(value={StreamsMetricsImpl.class, Sensor.class, ThreadMetrics.class, StateStoreMetrics.class, ProcessorNodeMetrics.class})
public class TaskMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createMock(StreamsMetricsImpl.class);
    private final Sensor expectedSensor = (Sensor)PowerMock.createMock(Sensor.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");
    @Parameterized.Parameter
    public StreamsMetricsImpl.Version builtInMetricsVersion;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({StreamsMetricsImpl.Version.LATEST}, {StreamsMetricsImpl.Version.FROM_0100_TO_24});
    }

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.streamsMetrics.version()).andReturn((Object)this.builtInMetricsVersion).anyTimes();
        PowerMock.mockStatic(StreamsMetricsImpl.class);
    }

    @Test
    public void shouldGetActiveProcessRatioSensor() {
        String operation = "active-process-ratio";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "active-process-ratio", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        String ratioDescription = "The fraction of time the thread spent on processing this task among all assigned active tasks";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"active-process-ratio", (String)"The fraction of time the thread spent on processing this task among all assigned active tasks");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.activeProcessRatioSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetActiveBufferCountSensor() {
        String operation = "active-buffer-count";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "active-buffer-count", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        String countDescription = "The count of buffered records that are polled from consumer and not yet processed for this active task";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"active-buffer-count", (String)"The count of buffered records that are polled from consumer and not yet processed for this active task");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.activeBufferedRecordsSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetProcessLatencySensor() {
        String operation = "process-latency";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "process-latency", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.LATEST) {
            String avgLatencyDescription = "The average latency of calls to process";
            String maxLatencyDescription = "The maximum latency of calls to process";
            EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
            StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"process-latency", (String)"The average latency of calls to process", (String)"The maximum latency of calls to process");
        }
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.processLatencySensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String operation = "punctuate";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "punctuate", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.LATEST) {
            String operationLatency = "punctuate-latency";
            String totalDescription = "The total number of calls to punctuate";
            String rateDescription = "The average number of calls to punctuate per second";
            String avgLatencyDescription = "The average latency of calls to punctuate";
            String maxLatencyDescription = "The maximum latency of calls to punctuate";
            EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
            StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"punctuate", (String)"The average number of calls to punctuate per second", (String)"The total number of calls to punctuate");
            StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"punctuate-latency", (String)"The average latency of calls to punctuate", (String)"The maximum latency of calls to punctuate");
        }
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.punctuateSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetCommitSensor() {
        String operation = "commit";
        String totalDescription = "The total number of calls to commit";
        String rateDescription = "The average number of calls to commit per second";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "commit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"commit", (String)"The average number of calls to commit per second", (String)"The total number of calls to commit");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.commitSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics, (Sensor[])new Sensor[0]);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetEnforcedProcessingSensor() {
        String operation = "enforced-processing";
        String totalDescription = "The total number of occurrences of enforced-processing operations";
        String rateDescription = "The average number of occurrences of enforced-processing operations per second";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "enforced-processing", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"enforced-processing", (String)"The average number of occurrences of enforced-processing operations per second", (String)"The total number of occurrences of enforced-processing operations");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.enforcedProcessingSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics, (Sensor[])new Sensor[0]);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetRecordLatenessSensor() {
        String operation = "record-lateness";
        String avgDescription = "The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
        String maxDescription = "The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "record-lateness", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"record-lateness", (String)"The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time", (String)"The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.recordLatenessSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetDroppedRecordsSensor() {
        String operation = "dropped-records";
        String totalDescription = "The total number of dropped records";
        String rateDescription = "The average number of dropped records per second";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "dropped-records", Sensor.RecordingLevel.INFO, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-task-metrics", this.tagMap, (String)"dropped-records", (String)"The average number of dropped records per second", (String)"The total number of dropped records");
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = TaskMetrics.droppedRecordsSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }

    @Test
    public void shouldGetDroppedRecordsSensorOrSkippedRecordsSensor() {
        PowerMock.mockStatic(ThreadMetrics.class);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            EasyMock.expect((Object)ThreadMetrics.skipRecordSensor((String)THREAD_ID, (StreamsMetricsImpl)this.streamsMetrics)).andReturn((Object)this.expectedSensor);
            PowerMock.replay((Object[])new Object[]{ThreadMetrics.class, StreamsMetricsImpl.class, this.streamsMetrics});
            Sensor sensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor((String)THREAD_ID, (String)TASK_ID, (StreamsMetricsImpl)this.streamsMetrics);
            PowerMock.verify((Object[])new Object[]{ThreadMetrics.class});
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        } else {
            this.shouldGetDroppedRecordsSensor();
        }
    }

    @Test
    public void shouldGetDroppedRecordsSensorOrExpiredWindowRecordDropSensor() {
        String storeType = "test-store-type";
        String storeName = "test-store-name";
        PowerMock.mockStatic(StateStoreMetrics.class);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            EasyMock.expect((Object)StateStoreMetrics.expiredWindowRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)"test-store-type", (String)"test-store-name", (StreamsMetricsImpl)this.streamsMetrics)).andReturn((Object)this.expectedSensor);
            PowerMock.replay((Object[])new Object[]{StateStoreMetrics.class, StreamsMetricsImpl.class, this.streamsMetrics});
            Sensor sensor = TaskMetrics.droppedRecordsSensorOrExpiredWindowRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)"test-store-type", (String)"test-store-name", (StreamsMetricsImpl)this.streamsMetrics);
            PowerMock.verify((Object[])new Object[]{StateStoreMetrics.class});
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        } else {
            this.shouldGetDroppedRecordsSensor();
        }
    }

    @Test
    public void shouldGetDroppedRecordsSensorOrLateRecordDropSensor() {
        String processorNodeId = "test-processor-node";
        PowerMock.mockStatic(ProcessorNodeMetrics.class);
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            EasyMock.expect((Object)ProcessorNodeMetrics.lateRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)"test-processor-node", (StreamsMetricsImpl)this.streamsMetrics)).andReturn((Object)this.expectedSensor);
            PowerMock.replay((Object[])new Object[]{ProcessorNodeMetrics.class, StreamsMetricsImpl.class, this.streamsMetrics});
            Sensor sensor = TaskMetrics.droppedRecordsSensorOrLateRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)"test-processor-node", (StreamsMetricsImpl)this.streamsMetrics);
            PowerMock.verify((Object[])new Object[]{ProcessorNodeMetrics.class});
            MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
        } else {
            this.shouldGetDroppedRecordsSensor();
        }
    }
}

