/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.StreamsTestUtils;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Sensor.class})
public class StreamsMetricsImplTest {
    private static final String SENSOR_PREFIX_DELIMITER = ".";
    private static final String SENSOR_NAME_DELIMITER = ".s.";
    private static final String INTERNAL_PREFIX = "internal";
    private static final String VERSION = "latest";
    private static final String CLIENT_ID = "test-client";
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String METRIC_NAME1 = "test-metric1";
    private static final String METRIC_NAME2 = "test-metric2";
    private static final String THREAD_ID_TAG = "thread-id";
    private static final String THREAD_ID_TAG_0100_TO_24 = "client-id";
    private static final String TASK_ID_TAG = "task-id";
    private static final String STORE_ID_TAG = "state-id";
    private static final String RECORD_CACHE_ID_TAG = "record-cache-id";
    private static final String SCOPE_NAME = "test-scope";
    private static final String ENTITY_NAME = "test-entity";
    private static final String OPERATION_NAME = "test-operation";
    private static final String CUSTOM_TAG_KEY1 = "test-key1";
    private static final String CUSTOM_TAG_VALUE1 = "test-value1";
    private static final String CUSTOM_TAG_KEY2 = "test-key2";
    private static final String CUSTOM_TAG_VALUE2 = "test-value2";
    private final Metrics metrics = new Metrics();
    private final Sensor sensor = this.metrics.sensor("dummy");
    private final String storeName = "store";
    private final String sensorName1 = "sensor1";
    private final String sensorName2 = "sensor2";
    private final String metricNamePrefix = "metric";
    private final String group = "group";
    private final Map<String, String> tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tag", (Object)"value")});
    private final String description1 = "description number one";
    private final String description2 = "description number two";
    private final String description3 = "description number three";
    private final String description4 = "description number four";
    private final Map<String, String> clientLevelTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"test-client")});
    private final MetricName metricName1 = new MetricName("test-metric1", "stream-metrics", "description number one", this.clientLevelTags);
    private final MetricName metricName2 = new MetricName("test-metric1", "stream-metrics", "description number two", this.clientLevelTags);
    private final MockTime time = new MockTime(0L);
    private final StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, "test-client", "latest");

    private static MetricConfig eqMetricConfig(final MetricConfig metricConfig) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){
            private final StringBuffer message = new StringBuffer();

            public boolean matches(Object argument) {
                if (argument instanceof MetricConfig) {
                    boolean equalsComparisons;
                    MetricConfig otherMetricConfig = (MetricConfig)argument;
                    boolean bl = equalsComparisons = (otherMetricConfig.quota() == metricConfig.quota() || otherMetricConfig.quota().equals((Object)metricConfig.quota())) && otherMetricConfig.tags().equals(metricConfig.tags());
                    if (otherMetricConfig.eventWindow() == metricConfig.eventWindow() && otherMetricConfig.recordLevel() == metricConfig.recordLevel() && equalsComparisons && otherMetricConfig.samples() == metricConfig.samples() && otherMetricConfig.timeWindowMs() == metricConfig.timeWindowMs()) {
                        return true;
                    }
                    this.message.append("{ ");
                    this.message.append("eventWindow=");
                    this.message.append(otherMetricConfig.eventWindow());
                    this.message.append(", ");
                    this.message.append("recordLevel=");
                    this.message.append(otherMetricConfig.recordLevel());
                    this.message.append(", ");
                    this.message.append("quota=");
                    this.message.append(otherMetricConfig.quota().toString());
                    this.message.append(", ");
                    this.message.append("samples=");
                    this.message.append(otherMetricConfig.samples());
                    this.message.append(", ");
                    this.message.append("tags=");
                    this.message.append(otherMetricConfig.tags().toString());
                    this.message.append(", ");
                    this.message.append("timeWindowMs=");
                    this.message.append(otherMetricConfig.timeWindowMs());
                    this.message.append(" }");
                }
                this.message.append("not a MetricConfig object");
                return false;
            }

            public void appendTo(StringBuffer buffer) {
                buffer.append(this.message);
            }
        });
        return null;
    }

    private void addSensorsOnAllLevels(Metrics metrics, StreamsMetricsImpl streamsMetrics) {
        EasyMock.expect((Object)metrics.sensor(EasyMock.anyString(), (Sensor.RecordingLevel)EasyMock.anyObject(Sensor.RecordingLevel.class), (Sensor[])EasyMock.anyObject(Sensor[].class))).andStubReturn((Object)this.sensor);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", "description number one", this.clientLevelTags)).andReturn((Object)this.metricName1);
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME2, "stream-metrics", "description number two", this.clientLevelTags)).andReturn((Object)this.metricName2);
        EasyMock.replay((Object[])new Object[]{metrics});
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME1, "description number one", Sensor.RecordingLevel.INFO, (Object)"value");
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME2, "description number two", Sensor.RecordingLevel.INFO, (Object)"value");
        streamsMetrics.threadLevelSensor(THREAD_ID, "sensor1", Sensor.RecordingLevel.INFO, new Sensor[0]);
        streamsMetrics.threadLevelSensor(THREAD_ID, "sensor2", Sensor.RecordingLevel.INFO, new Sensor[0]);
        streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "sensor1", Sensor.RecordingLevel.INFO, new Sensor[0]);
        streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "sensor2", Sensor.RecordingLevel.INFO, new Sensor[0]);
        streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, "store", "sensor1", Sensor.RecordingLevel.INFO, new Sensor[0]);
        streamsMetrics.storeLevelSensor(THREAD_ID, TASK_ID, "store", "sensor2", Sensor.RecordingLevel.INFO, new Sensor[0]);
    }

    private void setupGetNewSensorTest(Metrics metrics, String level, Sensor.RecordingLevel recordingLevel) {
        String fullSensorName = this.fullSensorName(level);
        EasyMock.expect((Object)metrics.getSensor(fullSensorName)).andStubReturn(null);
        Sensor[] parents = new Sensor[]{};
        EasyMock.expect((Object)metrics.sensor(fullSensorName, recordingLevel, parents)).andReturn((Object)this.sensor);
        EasyMock.replay((Object[])new Object[]{metrics});
    }

    private void setupGetExistingSensorTest(Metrics metrics, String level) {
        String fullSensorName = this.fullSensorName(level);
        EasyMock.expect((Object)metrics.getSensor(fullSensorName)).andStubReturn((Object)this.sensor);
        EasyMock.replay((Object[])new Object[]{metrics});
    }

    private String fullSensorName(String level) {
        return "internal." + level + SENSOR_NAME_DELIMITER + "sensor1";
    }

    @Test
    public void shouldGetNewThreadLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, THREAD_ID, recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.threadLevelSensor(THREAD_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingThreadLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics, THREAD_ID);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.threadLevelSensor(THREAD_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewTaskLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, "test-thread.task.test-task", recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingTaskLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics, "test-thread.task.test-task");
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewStoreLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetNewSensorTest(metrics, "test-thread.task.store.store.test-task", recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.storeLevelSensor(THREAD_ID, "store", TASK_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingStoreLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        this.setupGetExistingSensorTest(metrics, "test-thread.task.store.store.test-task");
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.storeLevelSensor(THREAD_ID, "store", TASK_ID, "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewNodeLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorNodeName = "processorNodeName";
        this.setupGetNewSensorTest(metrics, "test-thread.task.test-task.node.processorNodeName", recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, "processorNodeName", "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingNodeLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorNodeName = "processorNodeName";
        this.setupGetExistingSensorTest(metrics, "test-thread.task.test-task.node.processorNodeName");
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, "processorNodeName", "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetNewCacheLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorCacheName = "processorNodeName";
        this.setupGetNewSensorTest(metrics, "test-thread.task.test-task.cache.processorNodeName", recordingLevel);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.cacheLevelSensor(THREAD_ID, TASK_ID, "processorNodeName", "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldGetExistingCacheLevelSensor() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        String processorCacheName = "processorNodeName";
        this.setupGetExistingSensorTest(metrics, "test-thread.task.test-task.cache.processorNodeName");
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        Sensor actualSensor = streamsMetrics.cacheLevelSensor(THREAD_ID, TASK_ID, "processorNodeName", "sensor1", recordingLevel, new Sensor[0]);
        EasyMock.verify((Object[])new Object[]{metrics});
        MatcherAssert.assertThat((Object)actualSensor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalToObject((Object)this.sensor)));
    }

    @Test
    public void shouldAddClientLevelImmutableMetric() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        MetricConfig metricConfig = new MetricConfig().recordLevel(recordingLevel);
        String value = "immutable-value";
        StreamsMetricsImpl.ImmutableMetricValue immutableValue = new StreamsMetricsImpl.ImmutableMetricValue((Object)"immutable-value");
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", "description number one", this.clientLevelTags)).andReturn((Object)this.metricName1);
        metrics.addMetric((MetricName)EasyMock.eq((Object)this.metricName1), StreamsMetricsImplTest.eqMetricConfig(metricConfig), (MetricValueProvider)EasyMock.eq((Object)immutableValue));
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        streamsMetrics.addClientLevelImmutableMetric(METRIC_NAME1, "description number one", recordingLevel, (Object)"immutable-value");
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldAddClientLevelMutableMetric() {
        Metrics metrics = (Metrics)EasyMock.mock(Metrics.class);
        Sensor.RecordingLevel recordingLevel = Sensor.RecordingLevel.INFO;
        MetricConfig metricConfig = new MetricConfig().recordLevel(recordingLevel);
        Gauge valueProvider = (config, now) -> "mutable-value";
        EasyMock.expect((Object)metrics.metricName(METRIC_NAME1, "stream-metrics", "description number one", this.clientLevelTags)).andReturn((Object)this.metricName1);
        metrics.addMetric((MetricName)EasyMock.eq((Object)this.metricName1), StreamsMetricsImplTest.eqMetricConfig(metricConfig), (MetricValueProvider)EasyMock.eq((Object)valueProvider));
        EasyMock.replay((Object[])new Object[]{metrics});
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        streamsMetrics.addClientLevelMutableMetric(METRIC_NAME1, "description number one", recordingLevel, valueProvider);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldProvideCorrectStrings() {
        MatcherAssert.assertThat((Object)"-latency", (Matcher)CoreMatchers.is((Object)"-latency"));
        MatcherAssert.assertThat((Object)"all", (Matcher)CoreMatchers.is((Object)"all"));
    }

    private void setupRemoveSensorsTest(Metrics metrics, String level, Sensor.RecordingLevel recordingLevel) {
        String fullSensorNamePrefix = "internal." + level + SENSOR_NAME_DELIMITER;
        EasyMock.resetToDefault((Object[])new Object[]{metrics});
        metrics.removeSensor(fullSensorNamePrefix + "sensor1");
        metrics.removeSensor(fullSensorNamePrefix + "sensor2");
        EasyMock.replay((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldRemoveClientLevelMetrics() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        this.addSensorsOnAllLevels(metrics, streamsMetrics);
        EasyMock.resetToDefault((Object[])new Object[]{metrics});
        EasyMock.expect((Object)metrics.removeMetric(this.metricName1)).andStubReturn(null);
        EasyMock.expect((Object)metrics.removeMetric(this.metricName2)).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{metrics});
        streamsMetrics.removeAllClientLevelMetrics();
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test
    public void shouldRemoveThreadLevelSensors() {
        Metrics metrics = (Metrics)EasyMock.niceMock(Metrics.class);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, CLIENT_ID, VERSION);
        this.addSensorsOnAllLevels(metrics, streamsMetrics);
        this.setupRemoveSensorsTest(metrics, THREAD_ID, Sensor.RecordingLevel.INFO);
        streamsMetrics.removeAllThreadLevelSensors(THREAD_ID);
        EasyMock.verify((Object[])new Object[]{metrics});
    }

    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        new StreamsMetricsImpl(null, "", VERSION);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        this.streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String sensorName = "sensor1";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG);
        this.streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = this.streamsMetrics.addSensor("sensor1", Sensor.RecordingLevel.DEBUG, new Sensor[]{sensor1});
        this.streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = this.streamsMetrics.addLatencyRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        this.streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = this.streamsMetrics.addRateTotalSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        this.streamsMetrics.removeSensor(sensor3);
        Assert.assertEquals(Collections.emptyMap(), (Object)this.streamsMetrics.parentSensors());
    }

    @Test
    public void testMultiLevelSensorRemoval() {
        Metrics registry = new Metrics();
        StreamsMetricsImpl metrics = new StreamsMetricsImpl(registry, THREAD_ID, VERSION);
        for (MetricName defaultMetric : registry.metrics().keySet()) {
            registry.removeMetric(defaultMetric);
        }
        String taskName = "taskName";
        String operation = "operation";
        Map taskTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"tkey", (Object)"value")});
        String processorNodeName = "processorNodeName";
        Map nodeTags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"nkey", (Object)"value")});
        Sensor parent1 = metrics.taskLevelSensor(THREAD_ID, "taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)parent1, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation", (String)"", (String)"");
        int numberOfTaskMetrics = registry.metrics().size();
        Sensor sensor1 = metrics.nodeLevelSensor(THREAD_ID, "taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent1});
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)sensor1, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        metrics.removeAllNodeLevelSensors(THREAD_ID, "taskName", "processorNodeName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor parent2 = metrics.taskLevelSensor(THREAD_ID, "taskName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)parent2, (String)"stream-processor-node-metrics", (Map)taskTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        Sensor sensor2 = metrics.nodeLevelSensor(THREAD_ID, "taskName", "processorNodeName", "operation", Sensor.RecordingLevel.DEBUG, new Sensor[]{parent2});
        StreamsMetricsImpl.addAvgAndMaxLatencyToSensor((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)sensor2, (String)"stream-processor-node-metrics", (Map)nodeTags, (String)"operation", (String)"", (String)"");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(numberOfTaskMetrics)));
        metrics.removeAllNodeLevelSensors(THREAD_ID, "taskName", "processorNodeName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)numberOfTaskMetrics));
        metrics.removeAllTaskLevelSensors(THREAD_ID, "taskName");
        MatcherAssert.assertThat((Object)registry.metrics().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testLatencyMetrics() {
        int defaultMetrics = this.streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addLatencyAndThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(defaultMetrics + 4 + 4), (long)this.streamsMetrics.metrics().size());
        this.streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)this.streamsMetrics.metrics().size());
    }

    @Test
    public void testThroughputMetrics() {
        int defaultMetrics = this.streamsMetrics.metrics().size();
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        Sensor sensor1 = this.streamsMetrics.addThroughputSensor("scope", "entity", "put", Sensor.RecordingLevel.DEBUG, new String[0]);
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(defaultMetrics + 4), (long)this.streamsMetrics.metrics().size());
        this.streamsMetrics.removeSensor(sensor1);
        Assert.assertEquals((long)defaultMetrics, (long)this.streamsMetrics.metrics().size());
    }

    @Test
    public void testTotalMetricDoesntDecrease() {
        MockTime time = new MockTime(1L);
        MetricConfig config = new MetricConfig().timeWindow(1L, TimeUnit.MILLISECONDS);
        Metrics metrics = new Metrics(config, (Time)time);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "", VERSION);
        String scope = "scope";
        String entity = "entity";
        String operation = "op";
        Sensor sensor = streamsMetrics.addLatencyRateTotalSensor("scope", "entity", "op", Sensor.RecordingLevel.INFO, new String[0]);
        double latency = 100.0;
        MetricName totalMetricName = metrics.metricName("op-total", "stream-scope-metrics", "", new String[]{THREAD_ID_TAG, Thread.currentThread().getName(), "scope-id", "entity"});
        KafkaMetric totalMetric = metrics.metric(totalMetricName);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)Math.round(totalMetric.measurable().measure(config, time.milliseconds())));
            sensor.record(100.0, time.milliseconds());
        }
    }

    @Test
    public void shouldAddLatencyRateTotalSensorWithBuiltInMetricsVersionLatest() {
        this.shouldAddLatencyRateTotalSensor(VERSION);
    }

    @Test
    public void shouldAddLatencyRateTotalSensorWithBuiltInMetricsVersion0100To24() {
        this.shouldAddLatencyRateTotalSensor("0.10.0-2.4");
    }

    private void shouldAddLatencyRateTotalSensor(String builtInMetricsVersion) {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, builtInMetricsVersion);
        this.shouldAddCustomSensor(streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[0]), streamsMetrics, Arrays.asList("test-operation-latency-avg", "test-operation-latency-max", "test-operation-total", "test-operation-rate"));
    }

    @Test
    public void shouldAddRateTotalSensorWithBuiltInMetricsVersionLatest() {
        this.shouldAddRateTotalSensor(VERSION);
    }

    @Test
    public void shouldAddRateTotalSensorWithBuiltInMetricsVersion0100To24() {
        this.shouldAddRateTotalSensor("0.10.0-2.4");
    }

    private void shouldAddRateTotalSensor(String builtInMetricsVersion) {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, CLIENT_ID, builtInMetricsVersion);
        this.shouldAddCustomSensor(streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[0]), streamsMetrics, Arrays.asList("test-operation-total", "test-operation-rate"));
    }

    @Test
    public void shouldAddLatencyRateTotalSensorWithCustomTags() {
        Sensor sensor = this.streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1, CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2});
        Map<String, String> tags = this.customTags(this.streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, Arrays.asList("test-operation-latency-avg", "test-operation-latency-max", "test-operation-total", "test-operation-rate"), tags);
    }

    @Test
    public void shouldAddRateTotalSensorWithCustomTags() {
        Sensor sensor = this.streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1, CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2});
        Map<String, String> tags = this.customTags(this.streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, Arrays.asList("test-operation-total", "test-operation-rate"), tags);
    }

    private void shouldAddCustomSensor(Sensor sensor, StreamsMetricsImpl streamsMetrics, List<String> metricsNames) {
        Map<String, String> tags = this.tags(streamsMetrics);
        this.shouldAddCustomSensorWithTags(sensor, metricsNames, tags);
    }

    private void shouldAddCustomSensorWithTags(Sensor sensor, List<String> metricsNames, Map<String, String> tags) {
        String group = "stream-test-scope-metrics";
        Assert.assertTrue((boolean)sensor.hasMetrics());
        MatcherAssert.assertThat((Object)sensor.name(), (Matcher)CoreMatchers.is((Object)("external." + Thread.currentThread().getName() + ".entity." + ENTITY_NAME + SENSOR_NAME_DELIMITER + OPERATION_NAME)));
        for (String name : metricsNames) {
            Assert.assertTrue((boolean)StreamsTestUtils.containsMetric(this.metrics, name, "stream-test-scope-metrics", tags));
        }
    }

    private Map<String, String> tags(StreamsMetricsImpl streamsMetrics) {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)(streamsMetrics.version() == StreamsMetricsImpl.Version.LATEST ? THREAD_ID_TAG : THREAD_ID_TAG_0100_TO_24), (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"test-scope-id", (Object)ENTITY_NAME)});
    }

    private Map<String, String> customTags(StreamsMetricsImpl streamsMetrics) {
        Map<String, String> tags = this.tags(streamsMetrics);
        tags.put(CUSTOM_TAG_KEY1, CUSTOM_TAG_VALUE1);
        tags.put(CUSTOM_TAG_KEY2, CUSTOM_TAG_VALUE2);
        return tags;
    }

    @Test
    public void shouldThrowIfLatencyRateTotalSensorIsAddedWithOddTags() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.streamsMetrics.addLatencyRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{"bad-tag"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Tags needs to be specified in key-value pairs"));
    }

    @Test
    public void shouldThrowIfRateTotalSensorIsAddedWithOddTags() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.streamsMetrics.addRateTotalSensor(SCOPE_NAME, ENTITY_NAME, OPERATION_NAME, Sensor.RecordingLevel.DEBUG, new String[]{"bad-tag"}));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"Tags needs to be specified in key-value pairs"));
    }

    @Test
    public void shouldGetClientLevelTagMap() {
        Map tagMap = this.streamsMetrics.clientLevelTagMap();
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat(tagMap.get(THREAD_ID_TAG_0100_TO_24), (Matcher)Matchers.equalTo((Object)CLIENT_ID));
    }

    @Test
    public void shouldGetStoreLevelTagMapForBuiltInMetricsLatestVersion() {
        this.shouldGetStoreLevelTagMap(VERSION);
    }

    @Test
    public void shouldGetStoreLevelTagMapForBuiltInMetricsVersion0100To24() {
        this.shouldGetStoreLevelTagMap("0.10.0-2.4");
    }

    private void shouldGetStoreLevelTagMap(String builtInMetricsVersion) {
        String taskName = TASK_ID;
        String storeType = "remote-window";
        String storeName = "window-keeper";
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID, builtInMetricsVersion);
        Map tagMap = streamsMetrics.storeLevelTagMap(THREAD_ID, TASK_ID, "remote-window", "window-keeper");
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)3));
        boolean isMetricsLatest = builtInMetricsVersion.equals(VERSION);
        MatcherAssert.assertThat(tagMap.get(isMetricsLatest ? THREAD_ID_TAG : THREAD_ID_TAG_0100_TO_24), (Matcher)Matchers.equalTo((Object)THREAD_ID));
        MatcherAssert.assertThat(tagMap.get(TASK_ID_TAG), (Matcher)Matchers.equalTo((Object)TASK_ID));
        MatcherAssert.assertThat(tagMap.get("remote-window-state-id"), (Matcher)Matchers.equalTo((Object)"window-keeper"));
    }

    @Test
    public void shouldGetCacheLevelTagMapForBuiltInMetricsLatestVersion() {
        this.shouldGetCacheLevelTagMap(VERSION);
    }

    @Test
    public void shouldGetCacheLevelTagMapForBuiltInMetricsVersion0100To24() {
        this.shouldGetCacheLevelTagMap("0.10.0-2.4");
    }

    private void shouldGetCacheLevelTagMap(String builtInMetricsVersion) {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID, builtInMetricsVersion);
        String taskName = "taskName";
        String storeName = "storeName";
        Map tagMap = streamsMetrics.cacheLevelTagMap(THREAD_ID, "taskName", "storeName");
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)3));
        boolean isMetricsLatest = builtInMetricsVersion.equals(VERSION);
        MatcherAssert.assertThat(tagMap.get(isMetricsLatest ? THREAD_ID_TAG : THREAD_ID_TAG_0100_TO_24), (Matcher)Matchers.equalTo((Object)THREAD_ID));
        MatcherAssert.assertThat(tagMap.get(TASK_ID_TAG), (Matcher)Matchers.equalTo((Object)"taskName"));
        MatcherAssert.assertThat(tagMap.get(RECORD_CACHE_ID_TAG), (Matcher)Matchers.equalTo((Object)"storeName"));
    }

    @Test
    public void shouldGetThreadLevelTagMapForBuiltInMetricsLatestVersion() {
        this.shouldGetThreadLevelTagMap(VERSION);
    }

    @Test
    public void shouldGetThreadLevelTagMapForBuiltInMetricsVersion0100To24() {
        this.shouldGetThreadLevelTagMap("0.10.0-2.4");
    }

    private void shouldGetThreadLevelTagMap(String builtInMetricsVersion) {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(this.metrics, THREAD_ID, builtInMetricsVersion);
        Map tagMap = streamsMetrics.threadLevelTagMap(THREAD_ID);
        MatcherAssert.assertThat((Object)tagMap.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat(tagMap.get(builtInMetricsVersion.equals(VERSION) ? THREAD_ID_TAG : THREAD_ID_TAG_0100_TO_24), (Matcher)Matchers.equalTo((Object)THREAD_ID));
    }

    @Test
    public void shouldAddInvocationRateToSensor() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        MetricName expectedMetricName = new MetricName("test-metric1-rate", "group", "description number one", this.tags);
        EasyMock.expect((Object)sensor.add((MetricName)EasyMock.eq((Object)expectedMetricName), (MeasurableStat)EasyMock.anyObject(Rate.class))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.addInvocationRateToSensor((Sensor)sensor, (String)"group", this.tags, (String)METRIC_NAME1, (String)"description number one");
        EasyMock.verify((Object[])new Object[]{sensor});
    }

    @Test
    public void shouldAddAmountRateAndSum() {
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one", (String)"description number two");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 72.0;
        long defaultWindowSizeInSeconds = Duration.ofMillis(new MetricConfig().timeWindowMs()).getSeconds();
        double expectedRateMetricValue = 90.0 / (double)defaultWindowSizeInSeconds;
        this.verifyMetric("metric-rate", "description number one", 18.0, 72.0, expectedRateMetricValue);
        double expectedSumMetricValue = 180.0;
        this.verifyMetric("metric-total", "description number two", 18.0, 72.0, 180.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldAddSum() {
        StreamsMetricsImpl.addSumMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedSumMetricValue = 60.0;
        this.verifyMetric("metric-total", "description number one", 18.0, 42.0, 60.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddAmountRate() {
        StreamsMetricsImpl.addRateOfSumMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 72.0;
        long defaultWindowSizeInSeconds = Duration.ofMillis(new MetricConfig().timeWindowMs()).getSeconds();
        double expectedRateMetricValue = 90.0 / (double)defaultWindowSizeInSeconds;
        this.verifyMetric("metric-rate", "description number one", 18.0, 72.0, expectedRateMetricValue);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddValue() {
        StreamsMetricsImpl.addValueMetricToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one");
        KafkaMetric ratioMetric = this.metrics.metric(new MetricName("metric", "group", "description number one", this.tags));
        MatcherAssert.assertThat((Object)ratioMetric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MetricConfig metricConfig = new MetricConfig();
        double value1 = 42.0;
        this.sensor.record(42.0);
        MatcherAssert.assertThat((Object)ratioMetric.measurable().measure(metricConfig, this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)42.0));
        double value2 = 18.0;
        this.sensor.record(18.0);
        MatcherAssert.assertThat((Object)ratioMetric.measurable().measure(metricConfig, this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)18.0));
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void shouldAddAvgAndTotalMetricsToSensor() {
        StreamsMetricsImpl.addAvgAndSumMetricsToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one", (String)"description number two");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedAvgMetricValue = 30.0;
        this.verifyMetric("metric-avg", "description number one", 18.0, 42.0, 30.0);
        double expectedSumMetricValue = 120.0;
        this.verifyMetric("metric-total", "description number two", 18.0, 42.0, 120.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldAddAvgAndMinAndMaxMetricsToSensor() {
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one", (String)"description number two", (String)"description number three");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        double expectedAvgMetricValue = 30.0;
        this.verifyMetric("metric-avg", "description number one", 18.0, 42.0, 30.0);
        this.verifyMetric("metric-min", "description number two", 18.0, 42.0, 18.0);
        this.verifyMetric("metric-max", "description number three", 18.0, 42.0, 42.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void shouldAddMinAndMaxMetricsToSensor() {
        StreamsMetricsImpl.addMinAndMaxToSensor((Sensor)this.sensor, (String)"group", this.tags, (String)"metric", (String)"description number one", (String)"description number two");
        double valueToRecord1 = 18.0;
        double valueToRecord2 = 42.0;
        this.verifyMetric("metric-min", "description number one", 18.0, 42.0, 18.0);
        this.verifyMetric("metric-max", "description number two", 18.0, 42.0, 42.0);
        MatcherAssert.assertThat((Object)this.metrics.metrics().size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldReturnMetricsVersionCurrent() {
        MatcherAssert.assertThat((Object)new StreamsMetricsImpl(this.metrics, THREAD_ID, VERSION).version(), (Matcher)Matchers.equalTo((Object)StreamsMetricsImpl.Version.LATEST));
    }

    @Test
    public void shouldReturnMetricsVersionFrom100To23() {
        MatcherAssert.assertThat((Object)new StreamsMetricsImpl(this.metrics, THREAD_ID, "0.10.0-2.4").version(), (Matcher)Matchers.equalTo((Object)StreamsMetricsImpl.Version.FROM_0100_TO_24));
    }

    private void verifyMetric(String name, String description, double valueToRecord1, double valueToRecord2, double expectedMetricValue) {
        KafkaMetric metric = this.metrics.metric(new MetricName(name, "group", description, this.tags));
        MatcherAssert.assertThat((Object)metric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)metric.metricName().description(), (Matcher)Matchers.equalTo((Object)description));
        this.sensor.record(valueToRecord1, this.time.milliseconds());
        this.sensor.record(valueToRecord2, this.time.milliseconds());
        MatcherAssert.assertThat((Object)metric.measurable().measure(new MetricConfig(), this.time.milliseconds()), (Matcher)Matchers.equalTo((Object)expectedMetricValue));
    }

    private void verifyMetricWithinError(String name, String description, double valueToRecord1, double valueToRecord2, double expectedMetricValue, double acceptableError) {
        KafkaMetric metric = this.metrics.metric(new MetricName(name, "group", description, this.tags));
        MatcherAssert.assertThat((Object)metric, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)metric.metricName().description(), (Matcher)Matchers.equalTo((Object)description));
        this.sensor.record(valueToRecord1, this.time.milliseconds());
        this.sensor.record(valueToRecord2, this.time.milliseconds());
        Assert.assertEquals((double)expectedMetricValue, (double)metric.measurable().measure(new MetricConfig(), this.time.milliseconds()), (double)1.0);
    }

    @Test
    public void shouldMeasureLatency() {
        long startTime = 6L;
        long endTime = 10L;
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)true);
        EasyMock.expect((Object)sensor.hasMetrics()).andReturn((Object)true);
        sensor.record(4.0);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.expect((Object)time.nanoseconds()).andReturn((Object)6L);
        EasyMock.expect((Object)time.nanoseconds()).andReturn((Object)10L);
        EasyMock.replay((Object[])new Object[]{sensor, time});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor, time});
    }

    @Test
    public void shouldNotMeasureLatencyDueToRecordingLevel() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)false);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor});
    }

    @Test
    public void shouldNotMeasureLatencyBecauseSensorHasNoMetrics() {
        Sensor sensor = (Sensor)PowerMock.createMock(Sensor.class);
        EasyMock.expect((Object)sensor.shouldRecord()).andReturn((Object)true);
        EasyMock.expect((Object)sensor.hasMetrics()).andReturn((Object)false);
        Time time = (Time)EasyMock.mock(Time.class);
        EasyMock.replay((Object[])new Object[]{sensor});
        StreamsMetricsImpl.maybeMeasureLatency(() -> {}, (Time)time, (Sensor)sensor);
        EasyMock.verify((Object[])new Object[]{sensor});
    }
}

