/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class MockClientSupplier
implements KafkaClientSupplier {
    private static final ByteArraySerializer BYTE_ARRAY_SERIALIZER = new ByteArraySerializer();
    private Cluster cluster;
    private String applicationId;
    public MockAdminClient adminClient = new MockAdminClient();
    public final List<MockProducer<byte[], byte[]>> producers = new LinkedList<MockProducer<byte[], byte[]>>();
    public final MockConsumer<byte[], byte[]> consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
    public final MockConsumer<byte[], byte[]> restoreConsumer = new MockConsumer(OffsetResetStrategy.LATEST);

    public void setApplicationIdForProducer(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
        this.adminClient = new MockAdminClient(cluster.nodes(), cluster.nodeById(-1));
    }

    public Admin getAdmin(Map<String, Object> config) {
        return this.adminClient;
    }

    public Producer<byte[], byte[]> getProducer(Map<String, Object> config) {
        if (this.applicationId != null) {
            MatcherAssert.assertThat((Object)((String)config.get("transactional.id")), (Matcher)CoreMatchers.startsWith((String)(this.applicationId + "-")));
        } else {
            Assert.assertFalse((boolean)config.containsKey("transactional.id"));
        }
        MockProducer producer = new MockProducer(this.cluster, true, (Partitioner)new DefaultPartitioner(), (Serializer)BYTE_ARRAY_SERIALIZER, (Serializer)BYTE_ARRAY_SERIALIZER);
        this.producers.add((MockProducer<byte[], byte[]>)producer);
        return producer;
    }

    public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
        return this.consumer;
    }

    public Consumer<byte[], byte[]> getRestoreConsumer(Map<String, Object> config) {
        return this.restoreConsumer;
    }

    public Consumer<byte[], byte[]> getGlobalConsumer(Map<String, Object> config) {
        return this.restoreConsumer;
    }
}

