/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class GenericInMemoryKeyValueStore<K extends Comparable, V>
extends WrappedStateStore<StateStore, K, V>
implements KeyValueStore<K, V> {
    private final String name;
    private final NavigableMap<K, V> map;
    private volatile boolean open = false;

    public GenericInMemoryKeyValueStore(String name) {
        super(null);
        this.name = name;
        this.map = new TreeMap();
    }

    public String name() {
        return this.name;
    }

    public void init(ProcessorContext context, StateStore root) {
        if (root != null) {
            context.register(root, null);
        }
        this.open = true;
    }

    public boolean setFlushListener(CacheFlushListener<K, V> listener, boolean sendOldValues) {
        return false;
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized void put(K key, V value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public synchronized V putIfAbsent(K key, V value) {
        V originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    public synchronized void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.put((K)((Comparable)entry.key), (V)entry.value);
        }
    }

    public synchronized V delete(K key) {
        return this.map.remove(key);
    }

    public synchronized KeyValueIterator<K, V> range(K from, K to) {
        return new DelegatingPeekingKeyValueIterator(this.name, new GenericInMemoryKeyValueIterator(this.map.subMap(from, true, to, true).entrySet().iterator()));
    }

    public synchronized KeyValueIterator<K, V> all() {
        TreeMap<K, V> copy = new TreeMap<K, V>(this.map);
        return new DelegatingPeekingKeyValueIterator(this.name, new GenericInMemoryKeyValueIterator(copy.entrySet().iterator()));
    }

    public long approximateNumEntries() {
        return this.map.size();
    }

    public void flush() {
    }

    public void close() {
        this.map.clear();
        this.open = false;
    }

    private static class GenericInMemoryKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Iterator<Map.Entry<K, V>> iter;

        private GenericInMemoryKeyValueIterator(Iterator<Map.Entry<K, V>> iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public KeyValue<K, V> next() {
            Map.Entry<K, V> entry = this.iter.next();
            return new KeyValue(entry.getKey(), entry.getValue());
        }

        public void close() {
        }

        public K peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

