/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryLRUCacheStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context) {
        StoreBuilder storeBuilder = Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.lruMap((String)"my-store", (int)10), (Serde)context.keySerde(), (Serde)context.valueSerde());
        KeyValueStore store = (KeyValueStore)storeBuilder.build();
        store.init(context, (StateStore)store);
        return store;
    }

    @Test
    public void shouldPutAllKeyValuePairs() {
        List<KeyValue> kvPairs = Arrays.asList(KeyValue.pair((Object)1, (Object)"1"), KeyValue.pair((Object)2, (Object)"2"), KeyValue.pair((Object)3, (Object)"3"));
        this.store.putAll(kvPairs);
        MatcherAssert.assertThat((Object)this.store.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)3L));
        for (KeyValue kvPair : kvPairs) {
            MatcherAssert.assertThat((Object)this.store.get(kvPair.key), (Matcher)CoreMatchers.equalTo((Object)kvPair.value));
        }
    }

    @Test
    public void shouldUpdateValuesForExistingKeysOnPutAll() {
        List<KeyValue> kvPairs = Arrays.asList(KeyValue.pair((Object)1, (Object)"1"), KeyValue.pair((Object)2, (Object)"2"), KeyValue.pair((Object)3, (Object)"3"));
        this.store.putAll(kvPairs);
        List<KeyValue> updatedKvPairs = Arrays.asList(KeyValue.pair((Object)1, (Object)"ONE"), KeyValue.pair((Object)2, (Object)"TWO"), KeyValue.pair((Object)3, (Object)"THREE"));
        this.store.putAll(updatedKvPairs);
        MatcherAssert.assertThat((Object)this.store.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)3L));
        for (KeyValue kvPair : updatedKvPairs) {
            MatcherAssert.assertThat((Object)this.store.get(kvPair.key), (Matcher)CoreMatchers.equalTo((Object)kvPair.value));
        }
    }

    @Test
    public void testEvict() {
        this.store.put((Object)0, (Object)"zero");
        this.store.put((Object)1, (Object)"one");
        this.store.put((Object)2, (Object)"two");
        this.store.put((Object)3, (Object)"three");
        this.store.put((Object)4, (Object)"four");
        this.store.put((Object)5, (Object)"five");
        this.store.put((Object)6, (Object)"six");
        this.store.put((Object)7, (Object)"seven");
        this.store.put((Object)8, (Object)"eight");
        this.store.put((Object)9, (Object)"nine");
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        this.store.put((Object)10, (Object)"ten");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((long)1L, (long)this.driver.numFlushedEntryRemoved());
        this.store.delete((Object)1);
        this.store.flush();
        Assert.assertEquals((long)9L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)11, (Object)"eleven");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)2, (Object)"two-again");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put((Object)12, (Object)"twelve");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(3));
        Assert.assertEquals((long)3L, (long)this.driver.numFlushedEntryRemoved());
    }

    @Test
    public void testRestoreEvict() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.driver.addEntryToRestoreLog(4, "four");
        this.driver.addEntryToRestoreLog(5, "five");
        this.driver.addEntryToRestoreLog(6, "fix");
        this.driver.addEntryToRestoreLog(7, "seven");
        this.driver.addEntryToRestoreLog(8, "eight");
        this.driver.addEntryToRestoreLog(9, "nine");
        this.driver.addEntryToRestoreLog(10, "ten");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.numFlushedEntryStored());
        Assert.assertEquals((long)0L, (long)this.driver.numFlushedEntryRemoved());
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
    }
}

