/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalStateStoreProviderTest {
    private final Map<String, StateStore> stores = new HashMap<String, StateStore>();

    @Before
    public void before() {
        this.stores.put("kv-store", Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-kv-store", Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"ts-kv-store"), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("w-store", Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        this.stores.put("ts-w-store", Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"ts-w-store", (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(2L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).build());
        ProcessorContextImpl mockContext = (ProcessorContextImpl)EasyMock.mock(ProcessorContextImpl.class);
        EasyMock.expect((Object)mockContext.applicationId()).andReturn((Object)"appId").anyTimes();
        EasyMock.expect((Object)mockContext.metrics()).andReturn((Object)new StreamsMetricsImpl(new Metrics(), "threadName", "latest")).anyTimes();
        EasyMock.expect((Object)mockContext.taskId()).andReturn((Object)new TaskId(0, 0)).anyTimes();
        EasyMock.expect((Object)mockContext.recordCollector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockContext});
        for (StateStore store : this.stores.values()) {
            store.init((ProcessorContext)mockContext, null);
        }
    }

    @Test
    public void shouldReturnSingleItemListIfStoreExists() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", new NoOpReadOnlyStore()));
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)stores.size(), (long)1L);
    }

    @Test
    public void shouldReturnEmptyItemListIfStoreDoesntExist() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.emptyMap());
        List stores = provider.stores("global", QueryableStoreTypes.keyValueStore());
        Assert.assertTrue((boolean)stores.isEmpty());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfStoreIsntOpen() {
        NoOpReadOnlyStore store = new NoOpReadOnlyStore();
        store.close();
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(Collections.singletonMap("global", store));
        provider.stores("global", QueryableStoreTypes.keyValueStore());
    }

    @Test
    public void shouldReturnKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnTimestampedKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class));
        }
    }

    @Test
    public void shouldNotReturnKeyValueStoreAsTimestampedStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("kv-store", QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertEquals((long)0L, (long)stores.size());
    }

    @Test
    public void shouldReturnTimestampedKeyValueStoreAsKeyValueStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-kv-store", QueryableStoreTypes.keyValueStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyKeyValueStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyKeyValueStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedKeyValueStore.class)));
        }
    }

    @Test
    public void shouldReturnTimestampedWindowStoreAsWindowStore() {
        GlobalStateStoreProvider provider = new GlobalStateStoreProvider(this.stores);
        List stores = provider.stores("ts-w-store", QueryableStoreTypes.windowStore());
        Assert.assertEquals((long)1L, (long)stores.size());
        for (ReadOnlyWindowStore store : stores) {
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.instanceOf(ReadOnlyWindowStore.class));
            MatcherAssert.assertThat((Object)store, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(TimestampedWindowStore.class)));
        }
    }
}

