/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.StampedRecord;

public class PartitionGroup {
    private final Map<TopicPartition, RecordQueue> partitionQueues;
    private final Sensor recordLatenessSensor;
    private final PriorityQueue<RecordQueue> nonEmptyQueuesByTime;
    private long streamTime;
    private int totalBuffered;
    private boolean allBuffered;

    PartitionGroup(Map<TopicPartition, RecordQueue> partitionQueues, Sensor recordLatenessSensor) {
        this.nonEmptyQueuesByTime = new PriorityQueue<RecordQueue>(partitionQueues.size(), Comparator.comparingLong(RecordQueue::headRecordTimestamp));
        this.partitionQueues = partitionQueues;
        this.recordLatenessSensor = recordLatenessSensor;
        this.totalBuffered = 0;
        this.allBuffered = false;
        this.streamTime = -1L;
    }

    long partitionTimestamp(TopicPartition partition) {
        RecordQueue queue = this.partitionQueues.get(partition);
        if (queue == null) {
            throw new IllegalStateException("Partition " + partition + " not found.");
        }
        return queue.partitionTime();
    }

    void setPartitionTime(TopicPartition partition, long partitionTime) {
        RecordQueue queue = this.partitionQueues.get(partition);
        if (queue == null) {
            throw new IllegalStateException("Partition " + partition + " not found.");
        }
        if (this.streamTime < partitionTime) {
            this.streamTime = partitionTime;
        }
        queue.setPartitionTime(partitionTime);
    }

    StampedRecord nextRecord(RecordInfo info) {
        RecordQueue queue;
        StampedRecord record = null;
        info.queue = queue = this.nonEmptyQueuesByTime.poll();
        if (queue != null && (record = queue.poll()) != null) {
            --this.totalBuffered;
            if (queue.isEmpty()) {
                this.allBuffered = false;
            } else {
                this.nonEmptyQueuesByTime.offer(queue);
            }
            if (record.timestamp > this.streamTime) {
                this.streamTime = record.timestamp;
                this.recordLatenessSensor.record(0.0);
            } else {
                this.recordLatenessSensor.record((double)(this.streamTime - record.timestamp));
            }
        }
        return record;
    }

    int addRawRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> rawRecords) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        if (recordQueue == null) {
            throw new IllegalStateException("Partition " + partition + " not found.");
        }
        int oldSize = recordQueue.size();
        int newSize = recordQueue.addRawRecords(rawRecords);
        if (oldSize == 0 && newSize > 0) {
            this.nonEmptyQueuesByTime.offer(recordQueue);
            if (this.nonEmptyQueuesByTime.size() == this.partitionQueues.size()) {
                this.allBuffered = true;
            }
        }
        this.totalBuffered += newSize - oldSize;
        return newSize;
    }

    Set<TopicPartition> partitions() {
        return Collections.unmodifiableSet(this.partitionQueues.keySet());
    }

    long streamTime() {
        return this.streamTime;
    }

    Long headRecordOffset(TopicPartition partition) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        if (recordQueue == null) {
            throw new IllegalStateException("Partition " + partition + " not found.");
        }
        return recordQueue.headRecordOffset();
    }

    int numBuffered(TopicPartition partition) {
        RecordQueue recordQueue = this.partitionQueues.get(partition);
        if (recordQueue == null) {
            throw new IllegalStateException("Partition " + partition + " not found.");
        }
        return recordQueue.size();
    }

    int numBuffered() {
        return this.totalBuffered;
    }

    boolean allPartitionsBuffered() {
        return this.allBuffered;
    }

    void close() {
        this.clear();
        this.partitionQueues.clear();
    }

    void clear() {
        this.nonEmptyQueuesByTime.clear();
        this.streamTime = -1L;
        this.totalBuffered = 0;
        for (RecordQueue queue : this.partitionQueues.values()) {
            queue.clear();
        }
    }

    static class RecordInfo {
        RecordQueue queue;

        RecordInfo() {
        }

        ProcessorNode node() {
            return this.queue.source();
        }

        TopicPartition partition() {
            return this.queue.partition();
        }

        RecordQueue queue() {
            return this.queue;
        }
    }
}

