/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tools;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.tools.StreamsResetter;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamsResetterTest {
    private static final String TOPIC = "topic1";
    private final StreamsResetter streamsResetter = new StreamsResetter();
    private final MockConsumer<byte[], byte[]> consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final Set<TopicPartition> inputTopicPartitions = new HashSet<TopicPartition>(Collections.singletonList(this.topicPartition));

    @Before
    public void setUp() {
        this.consumer.assign(Collections.singletonList(this.topicPartition));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 0L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 1L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 2L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 3L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 4L, (Object)new byte[0], (Object)new byte[0]));
    }

    @Test
    public void testResetToSpecificOffsetWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(2L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)3L, (long)records.count());
    }

    @Test
    public void testResetToSpecificOffsetWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 3L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(2L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testResetToSpecificOffsetWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(4L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testShiftOffsetByWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, 3L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testShiftOffsetByWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, -3L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)5L, (long)records.count());
    }

    @Test
    public void testShiftOffsetByWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, 5L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testResetUsingPlanWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 3L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testResetUsingPlanWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 3L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 1L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void testResetUsingPlanWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 5L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void shouldSeekToEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashSet<TopicPartition> intermediateTopicPartitions = new HashSet<TopicPartition>();
        intermediateTopicPartitions.add(this.topicPartition);
        this.streamsResetter.maybeSeekToEnd("g1", this.consumer, intermediateTopicPartitions);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test
    public void shouldDeleteTopic() throws InterruptedException, ExecutionException {
        Cluster cluster = this.createCluster(1);
        try (MockAdminClient adminClient = new MockAdminClient(cluster.nodes(), cluster.nodeById(0));){
            TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, cluster.nodeById(0), cluster.nodes(), Collections.emptyList());
            adminClient.addTopic(false, TOPIC, Collections.singletonList(topicPartitionInfo), null);
            this.streamsResetter.doDelete(Collections.singletonList(TOPIC), (Admin)adminClient);
            Assert.assertEquals(Collections.emptySet(), (Object)adminClient.listTopics().names().get());
        }
    }

    private Cluster createCluster(int numNodes) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
    }

    @Test
    public void shouldAcceptValidDateFormats() throws ParseException {
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
    }

    @Test
    public void shouldThrowOnInvalidDateFormat() throws ParseException {
        try {
            this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
            Assert.fail((String)"Call to getDateTime should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.X"));
            Assert.fail((String)"Call to getDateTime should fail");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void invokeGetDateTimeMethod(SimpleDateFormat format) throws ParseException {
        Date checkpoint = new Date();
        StreamsResetter streamsResetter = new StreamsResetter();
        String formattedCheckpoint = format.format(checkpoint);
        streamsResetter.getDateTime(formattedCheckpoint);
    }
}

