/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.StandbyContextImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.AbstractRocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.AbstractSegments;
import org.apache.kafka.streams.state.internals.Segment;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecordingTrigger;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.rocksdb.Options;
import org.rocksdb.WriteBatch;

@RunWith(value=Parameterized.class)
public abstract class AbstractRocksDBSegmentedBytesStoreTest<S extends Segment> {
    private final long windowSizeForTimeWindow = 500L;
    private InternalMockProcessorContext context;
    private AbstractRocksDBSegmentedBytesStore<S> bytesStore;
    private File stateDir;
    private final Window[] windows = new Window[4];
    private Window nextSegmentWindow;
    final long retention = 1000L;
    final long segmentInterval = 60000L;
    final String storeName = "bytes-store";
    @Parameterized.Parameter
    public SegmentedBytesStore.KeySchema schema;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getKeySchemas() {
        return new Object[]{new SessionKeySchema(), new WindowKeySchema()};
    }

    @Before
    public void before() {
        if (this.schema instanceof SessionKeySchema) {
            this.windows[0] = new SessionWindow(10L, 10L);
            this.windows[1] = new SessionWindow(500L, 1000L);
            this.windows[2] = new SessionWindow(1000L, 1500L);
            this.windows[3] = new SessionWindow(30000L, 60000L);
            this.nextSegmentWindow = new SessionWindow(61000L, 61000L);
        }
        if (this.schema instanceof WindowKeySchema) {
            this.windows[0] = WindowKeySchema.timeWindowForSize((long)10L, (long)500L);
            this.windows[1] = WindowKeySchema.timeWindowForSize((long)500L, (long)500L);
            this.windows[2] = WindowKeySchema.timeWindowForSize((long)1000L, (long)500L);
            this.windows[3] = WindowKeySchema.timeWindowForSize((long)60000L, (long)500L);
            this.nextSegmentWindow = WindowKeySchema.timeWindowForSize((long)61000L, (long)500L);
        }
        this.bytesStore = this.getBytesStore();
        this.stateDir = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDir, Serdes.String(), Serdes.Long(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.bytesStore.init((ProcessorContext)this.context, this.bytesStore);
    }

    @After
    public void close() {
        this.bytesStore.close();
    }

    abstract AbstractRocksDBSegmentedBytesStore<S> getBytesStore();

    abstract AbstractSegments<S> newSegments();

    abstract Options getOptions(S var1);

    @Test
    public void shouldPutAndFetch() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(100L));
        KeyValueIterator values = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 500L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L));
        Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)values));
    }

    @Test
    public void shouldFindValuesWithinRange() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(10L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(100L));
        KeyValueIterator results = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 1L, 999L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)10L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)50L));
        Assert.assertEquals(expected, this.toList((KeyValueIterator<Bytes, byte[]>)results));
    }

    @Test
    public void shouldRemove() {
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(30L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(50L));
        this.bytesStore.remove(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])));
        KeyValueIterator value = this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 100L);
        Assert.assertFalse((boolean)value.hasNext());
    }

    @Test
    public void shouldRollSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[2])), this.serializeValue(500L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(1000L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 1500L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[1]), (Object)100L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[2]), (Object)500L)), results);
    }

    @Test
    public void shouldGetAllSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L)), results);
    }

    @Test
    public void shouldFetchAllSegments() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        Assert.assertEquals(Collections.singleton(segments.segmentName(0L)), this.segmentDirs());
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{segments.segmentName(0L), segments.segmentName(1L)}), this.segmentDirs());
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetchAll(0L, 60000L));
        Assert.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L)), results);
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleDateFormattedName() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        Long segmentId = Long.parseLong(nameParts[1]);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String formatted = formatter.format(new Date(segmentId * 60000L));
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + "-" + formatted);
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((ProcessorContext)this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
    }

    @Test
    public void shouldLoadSegmentsWithOldStyleColonFormattedName() {
        AbstractSegments<S> segments = this.newSegments();
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        this.bytesStore.close();
        String firstSegmentName = segments.segmentName(0L);
        String[] nameParts = firstSegmentName.split("\\.");
        File parent = new File(this.stateDir, "bytes-store");
        File oldStyleName = new File(parent, nameParts[0] + ":" + Long.parseLong(nameParts[1]));
        Assert.assertTrue((boolean)new File(parent, firstSegmentName).renameTo(oldStyleName));
        this.bytesStore = this.getBytesStore();
        this.bytesStore.init((ProcessorContext)this.context, this.bytesStore);
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.fetch(Bytes.wrap((byte[])"a".getBytes()), 0L, 60000L));
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L), KeyValue.pair((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L))));
    }

    @Test
    public void shouldBeAbleToWriteToReInitializedStore() {
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.close();
        this.bytesStore.init((ProcessorContext)this.context, this.bytesStore);
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[1])), this.serializeValue(100L));
    }

    @Test
    public void shouldCreateWriteBatches() {
        String key = "a";
        ArrayList<KeyValue> records = new ArrayList<KeyValue>();
        records.add(new KeyValue((Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])).get(), (Object)this.serializeValue(50L)));
        records.add(new KeyValue((Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])).get(), (Object)this.serializeValue(100L)));
        Map writeBatchMap = this.bytesStore.getWriteBatches(records);
        Assert.assertEquals((long)2L, (long)writeBatchMap.size());
        for (WriteBatch batch : writeBatchMap.values()) {
            Assert.assertEquals((long)1L, (long)batch.count());
        }
    }

    @Test
    public void shouldRestoreToByteStoreForActiveTask() {
        ProcessorContextImpl context = (ProcessorContextImpl)EasyMock.niceMock(ProcessorContextImpl.class);
        this.verifyRestoreToByteStore((InternalProcessorContext)context);
        for (Segment segment : this.bytesStore.getSegments()) {
            MatcherAssert.assertThat((Object)this.getOptions(segment).level0FileNumCompactionTrigger(), (Matcher)CoreMatchers.equalTo((Object)0x40000000));
        }
    }

    @Test
    public void shouldRestoreToByteStoreForStandbyTask() {
        StandbyContextImpl context = (StandbyContextImpl)EasyMock.niceMock(StandbyContextImpl.class);
        this.verifyRestoreToByteStore((InternalProcessorContext)context);
        for (Segment segment : this.bytesStore.getSegments()) {
            MatcherAssert.assertThat((Object)this.getOptions(segment).level0FileNumCompactionTrigger(), (Matcher)CoreMatchers.equalTo((Object)4));
        }
    }

    private void verifyRestoreToByteStore(InternalProcessorContext context) {
        this.bytesStore = this.getBytesStore();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "mock", "latest");
        streamsMetrics.setRocksDBMetricsRecordingTrigger(new RocksDBMetricsRecordingTrigger());
        EasyMock.expect((Object)context.metrics()).andStubReturn((Object)streamsMetrics);
        TaskId taskId = new TaskId(0, 0);
        EasyMock.expect((Object)context.taskId()).andStubReturn((Object)taskId);
        Map config = new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig()).originals();
        EasyMock.expect((Object)context.appConfigs()).andStubReturn((Object)config);
        EasyMock.expect((Object)context.stateDir()).andStubReturn((Object)this.stateDir);
        EasyMock.replay((Object[])new Object[]{context});
        this.bytesStore.init((ProcessorContext)context, this.bytesStore);
        Assert.assertEquals((long)0L, (long)this.bytesStore.getSegments().size());
        String key = "a";
        ArrayList<KeyValue> records = new ArrayList<KeyValue>();
        records.add(new KeyValue((Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])).get(), (Object)this.serializeValue(50L)));
        records.add(new KeyValue((Object)this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])).get(), (Object)this.serializeValue(100L)));
        this.bytesStore.restoreAllInternal(records);
        Assert.assertEquals((long)2L, (long)this.bytesStore.getSegments().size());
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[0]), (Object)50L));
        expected.add(new KeyValue((Object)new Windowed((Object)"a", this.windows[3]), (Object)100L));
        List<KeyValue<Windowed<String>, Long>> results = this.toList((KeyValueIterator<Bytes, byte[]>)this.bytesStore.all());
        Assert.assertEquals(expected, results);
    }

    @Test
    public void shouldRespectBulkLoadOptionsDuringInit() {
        this.bytesStore.init((ProcessorContext)this.context, this.bytesStore);
        String key = "a";
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0])), this.serializeValue(50L));
        this.bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[3])), this.serializeValue(100L));
        Assert.assertEquals((long)2L, (long)this.bytesStore.getSegments().size());
        StateRestoreListener restoreListener = this.context.getRestoreListener(this.bytesStore.name());
        restoreListener.onRestoreStart(null, this.bytesStore.name(), 0L, 0L);
        for (Segment segment : this.bytesStore.getSegments()) {
            MatcherAssert.assertThat((Object)this.getOptions(segment).level0FileNumCompactionTrigger(), (Matcher)CoreMatchers.equalTo((Object)0x40000000));
        }
        restoreListener.onRestoreEnd(null, this.bytesStore.name(), 0L);
        for (Segment segment : this.bytesStore.getSegments()) {
            MatcherAssert.assertThat((Object)this.getOptions(segment).level0FileNumCompactionTrigger(), (Matcher)CoreMatchers.equalTo((Object)4));
        }
    }

    @Test
    public void shouldLogAndMeasureExpiredRecordsWithBuiltInMetricsVersionLatest() {
        this.shouldLogAndMeasureExpiredRecords("latest");
    }

    @Test
    public void shouldLogAndMeasureExpiredRecordsWithBuiltInMetricsVersion0100To24() {
        this.shouldLogAndMeasureExpiredRecords("0.10.0-2.4");
    }

    private void shouldLogAndMeasureExpiredRecords(String builtInMetricsVersion) {
        Metric dropRate;
        Metric dropTotal;
        LogCaptureAppender.setClassLoggerToDebug(AbstractRocksDBSegmentedBytesStore.class);
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
        streamsConfig.setProperty("built.in.metrics.version", builtInMetricsVersion);
        AbstractRocksDBSegmentedBytesStore<S> bytesStore = this.getBytesStore();
        InternalMockProcessorContext context = new InternalMockProcessorContext(TestUtils.tempDirectory(), new StreamsConfig((Map)streamsConfig));
        bytesStore.init((ProcessorContext)context, bytesStore);
        bytesStore.put(this.serializeKey((Windowed<String>)new Windowed((Object)"dummy", this.nextSegmentWindow)), this.serializeValue(0L));
        Bytes key = this.serializeKey((Windowed<String>)new Windowed((Object)"a", this.windows[0]));
        byte[] value = this.serializeValue(5L);
        bytesStore.put(key, value);
        LogCaptureAppender.unregister(appender);
        Map metrics = context.metrics().metrics();
        String threadId = Thread.currentThread().getName();
        if ("0.10.0-2.4".equals(builtInMetricsVersion)) {
            dropTotal = (Metric)metrics.get(new MetricName("expired-window-record-drop-total", "stream-metrics-scope-metrics", "The total number of dropped records due to an expired window", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"metrics-scope-state-id", (Object)"bytes-store")})));
            dropRate = (Metric)metrics.get(new MetricName("expired-window-record-drop-rate", "stream-metrics-scope-metrics", "The average number of dropped records due to an expired window per second.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)"metrics-scope-state-id", (Object)"bytes-store")})));
        } else {
            dropTotal = (Metric)metrics.get(new MetricName("dropped-records-total", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
            dropRate = (Metric)metrics.get(new MetricName("dropped-records-rate", "stream-task-metrics", "", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)threadId), Utils.mkEntry((Object)"task-id", (Object)"0_0")})));
        }
        Assert.assertEquals((Object)1.0, (Object)dropTotal.metricValue());
        Assert.assertNotEquals((Object)0.0, (Object)dropRate.metricValue());
        List<String> messages = appender.getMessages();
        MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Skipping record for expired segment."));
    }

    private Set<String> segmentDirs() {
        File windowDir = new File(this.stateDir, "bytes-store");
        return Utils.mkSet((Object[])Objects.requireNonNull(windowDir.list()));
    }

    private Bytes serializeKey(Windowed<String> key) {
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        if (this.schema instanceof SessionKeySchema) {
            return Bytes.wrap((byte[])SessionKeySchema.toBinary(key, (Serializer)stateSerdes.keySerializer(), (String)"dummy"));
        }
        return WindowKeySchema.toStoreKeyBinary(key, (int)0, (StateSerdes)stateSerdes);
    }

    private byte[] serializeValue(long value) {
        return Serdes.Long().serializer().serialize("", (Object)value);
    }

    private List<KeyValue<Windowed<String>, Long>> toList(KeyValueIterator<Bytes, byte[]> iterator) {
        ArrayList<KeyValue<Windowed<String>, Long>> results = new ArrayList<KeyValue<Windowed<String>, Long>>();
        StateSerdes stateSerdes = StateSerdes.withBuiltinTypes((String)"dummy", String.class, Long.class);
        while (iterator.hasNext()) {
            KeyValue deserialized;
            KeyValue next = (KeyValue)iterator.next();
            if (this.schema instanceof WindowKeySchema) {
                deserialized = KeyValue.pair((Object)WindowKeySchema.fromStoreKey((byte[])((Bytes)next.key).get(), (long)500L, (Deserializer)stateSerdes.keyDeserializer(), (String)stateSerdes.topic()), (Object)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value));
                results.add((KeyValue<Windowed<String>, Long>)deserialized);
                continue;
            }
            deserialized = KeyValue.pair((Object)SessionKeySchema.from((byte[])((Bytes)next.key).get(), (Deserializer)stateSerdes.keyDeserializer(), (String)"dummy"), (Object)stateSerdes.valueDeserializer().deserialize("dummy", (byte[])next.value));
            results.add((KeyValue<Windowed<String>, Long>)deserialized);
        }
        return results;
    }
}

