/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.LegacySubscriptionInfoSerde;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionInfoTest {
    private final UUID processId = UUID.randomUUID();
    private final Set<TaskId> activeTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(0, 0), new TaskId(0, 1), new TaskId(1, 0)));
    private final Set<TaskId> standbyTasks = new HashSet<TaskId>(Arrays.asList(new TaskId(1, 1), new TaskId(2, 0)));
    private static final String IGNORED_USER_ENDPOINT = "ignoredUserEndpoint:80";

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion1() {
        new SubscriptionInfo(0, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowForUnknownVersion2() {
        new SubscriptionInfo(7, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
    }

    @Test
    public void shouldEncodeAndDecodeVersion1() {
        SubscriptionInfo info = new SubscriptionInfo(1, 6, this.processId, this.activeTasks, this.standbyTasks, IGNORED_USER_ENDPOINT);
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, (Object)decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, (Object)decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion1ShouldBeDecodableByLegacyLogic() {
        SubscriptionInfo info = new SubscriptionInfo(1, 1234, this.processId, this.activeTasks, this.standbyTasks, "ignoreme");
        ByteBuffer buffer = info.encode();
        LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion1ShouldDecodeLegacyFormat() {
        LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(1, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        ByteBuffer buffer = info.encode();
        buffer.rewind();
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
        Assert.assertEquals((long)1L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, (Object)decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, (Object)decoded.standbyTasks());
        Assert.assertNull((Object)decoded.userEndPoint());
    }

    @Test
    public void shouldEncodeAndDecodeVersion2() {
        SubscriptionInfo info = new SubscriptionInfo(2, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, (Object)decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, (Object)decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion2ShouldBeDecodableByLegacyLogic() {
        SubscriptionInfo info = new SubscriptionInfo(2, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        ByteBuffer buffer = info.encode();
        LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void generatedVersion2ShouldDecodeLegacyFormat() {
        LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(2, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        ByteBuffer buffer = info.encode();
        buffer.rewind();
        SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
        Assert.assertEquals((long)2L, (long)decoded.version());
        Assert.assertEquals((long)-1L, (long)decoded.latestSupportedVersion());
        Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
        Assert.assertEquals(this.activeTasks, (Object)decoded.prevTasks());
        Assert.assertEquals(this.standbyTasks, (Object)decoded.standbyTasks());
        Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
    }

    @Test
    public void shouldEncodeAndDecodeVersion3And4() {
        for (int version = 3; version <= 4; ++version) {
            SubscriptionInfo info = new SubscriptionInfo(version, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
            SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)info.encode());
            Assert.assertEquals((long)version, (long)decoded.version());
            Assert.assertEquals((long)6L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
            Assert.assertEquals(this.activeTasks, (Object)decoded.prevTasks());
            Assert.assertEquals(this.standbyTasks, (Object)decoded.standbyTasks());
            Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void generatedVersion3And4ShouldBeDecodableByLegacyLogic() {
        for (int version = 3; version <= 4; ++version) {
            SubscriptionInfo info = new SubscriptionInfo(version, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
            ByteBuffer buffer = info.encode();
            LegacySubscriptionInfoSerde decoded = LegacySubscriptionInfoSerde.decode(buffer);
            Assert.assertEquals((long)version, (long)decoded.version());
            Assert.assertEquals((long)6L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((Object)this.processId, (Object)decoded.processId());
            Assert.assertEquals(this.activeTasks, decoded.prevTasks());
            Assert.assertEquals(this.standbyTasks, decoded.standbyTasks());
            Assert.assertEquals((Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void generatedVersion3To6ShouldDecodeLegacyFormat() {
        for (int version = 3; version <= 6; ++version) {
            LegacySubscriptionInfoSerde info = new LegacySubscriptionInfoSerde(version, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
            ByteBuffer buffer = info.encode();
            buffer.rewind();
            SubscriptionInfo decoded = SubscriptionInfo.decode((ByteBuffer)buffer);
            String message = "for version: " + version;
            Assert.assertEquals((String)message, (long)version, (long)decoded.version());
            Assert.assertEquals((String)message, (long)6L, (long)decoded.latestSupportedVersion());
            Assert.assertEquals((String)message, (Object)this.processId, (Object)decoded.processId());
            Assert.assertEquals((String)message, this.activeTasks, (Object)decoded.prevTasks());
            Assert.assertEquals((String)message, this.standbyTasks, (Object)decoded.standbyTasks());
            Assert.assertEquals((String)message, (Object)"localhost:80", (Object)decoded.userEndPoint());
        }
    }

    @Test
    public void shouldEncodeAndDecodeVersion5() {
        SubscriptionInfo info = new SubscriptionInfo(5, 6, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)info, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    @Test
    public void shouldAllowToDecodeFutureSupportedVersion() {
        SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)SubscriptionInfoTest.encodeFutureVersion());
        Assert.assertEquals((long)7L, (long)info.version());
        Assert.assertEquals((long)7L, (long)info.latestSupportedVersion());
    }

    @Test
    public void shouldEncodeAndDecodeSmallerLatestSupportedVersion() {
        int usedVersion = 5;
        int latestSupportedVersion = 5;
        SubscriptionInfo info = new SubscriptionInfo(5, 5, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        SubscriptionInfo expectedInfo = new SubscriptionInfo(5, 5, this.processId, this.activeTasks, this.standbyTasks, "localhost:80");
        Assert.assertEquals((Object)expectedInfo, (Object)SubscriptionInfo.decode((ByteBuffer)info.encode()));
    }

    private static ByteBuffer encodeFutureVersion() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(7);
        buf.putInt(7);
        buf.rewind();
        return buf;
    }
}

