/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.assignment.CopartitionedTopicsEnforcer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class CopartitionedTopicsEnforcerTest {
    private final CopartitionedTopicsEnforcer validator = new CopartitionedTopicsEnforcer("thread");
    private final Map<TopicPartition, PartitionInfo> partitions = new HashMap<TopicPartition, PartitionInfo>();
    private final Cluster cluster = Cluster.empty();

    @Before
    public void before() {
        this.partitions.put(new TopicPartition("first", 0), new PartitionInfo("first", 0, null, null, null));
        this.partitions.put(new TopicPartition("first", 1), new PartitionInfo("first", 1, null, null, null));
        this.partitions.put(new TopicPartition("second", 0), new PartitionInfo("second", 0, null, null, null));
        this.partitions.put(new TopicPartition("second", 1), new PartitionInfo("second", 1, null, null, null));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowTopologyBuilderExceptionIfNoPartitionsFoundForCoPartitionedTopic() {
        this.validator.enforce(Collections.singleton("topic"), Collections.emptyMap(), this.cluster);
    }

    @Test(expected=TopologyException.class)
    public void shouldThrowTopologyBuilderExceptionIfPartitionCountsForCoPartitionedTopicsDontMatch() {
        this.partitions.remove(new TopicPartition("second", 0));
        this.validator.enforce(Utils.mkSet((Object[])new String[]{"first", "second"}), Collections.emptyMap(), this.cluster.withPartitions(this.partitions));
    }

    @Test
    public void shouldEnforceCopartitioningOnRepartitionTopics() {
        InternalTopicConfig config = this.createTopicConfig("repartitioned", 10);
        this.validator.enforce(Utils.mkSet((Object[])new String[]{"first", "second", config.name()}), Collections.singletonMap(config.name(), config), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)config.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(2)));
    }

    @Test
    public void shouldSetNumPartitionsToMaximumPartitionsWhenAllTopicsAreRepartitionTopics() {
        InternalTopicConfig one = this.createTopicConfig("one", 1);
        InternalTopicConfig two = this.createTopicConfig("two", 15);
        InternalTopicConfig three = this.createTopicConfig("three", 5);
        HashMap<String, InternalTopicConfig> repartitionTopicConfig = new HashMap<String, InternalTopicConfig>();
        repartitionTopicConfig.put(one.name(), one);
        repartitionTopicConfig.put(two.name(), two);
        repartitionTopicConfig.put(three.name(), three);
        this.validator.enforce(Utils.mkSet((Object[])new String[]{one.name(), two.name(), three.name()}), repartitionTopicConfig, this.cluster);
        MatcherAssert.assertThat((Object)one.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
        MatcherAssert.assertThat((Object)two.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
        MatcherAssert.assertThat((Object)three.numberOfPartitions(), (Matcher)CoreMatchers.equalTo(Optional.of(15)));
    }

    private InternalTopicConfig createTopicConfig(String repartitionTopic, int partitions) {
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig(repartitionTopic, Collections.emptyMap());
        repartitionTopicConfig.setNumberOfPartitions(partitions);
        return repartitionTopicConfig;
    }
}

