/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AssignedStreamsTasks;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.MockChangelogReader;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamTaskTest;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.MockSourceNode;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class AssignedStreamsTasksTest {
    private final StreamTask t1 = (StreamTask)EasyMock.createMock(StreamTask.class);
    private final StreamTask t2 = (StreamTask)EasyMock.createMock(StreamTask.class);
    private final TopicPartition tp1 = new TopicPartition("t1", 0);
    private final TopicPartition tp2 = new TopicPartition("t2", 0);
    private final TopicPartition changeLog1 = new TopicPartition("cl1", 0);
    private final TopicPartition changeLog2 = new TopicPartition("cl2", 0);
    private final TaskId taskId1 = new TaskId(0, 0);
    private final TaskId taskId2 = new TaskId(1, 0);
    private AssignedStreamsTasks assignedTasks;
    private final List<TopicPartition> revokedChangelogs = new ArrayList<TopicPartition>();

    @Before
    public void before() {
        this.assignedTasks = new AssignedStreamsTasks(new LogContext("log "));
        EasyMock.expect((Object)this.t1.id()).andReturn((Object)this.taskId1).anyTimes();
        EasyMock.expect((Object)this.t2.id()).andReturn((Object)this.taskId2).anyTimes();
        this.revokedChangelogs.clear();
    }

    @Test
    public void shouldInitializeNewTasks() {
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldMoveInitializedTasksNeedingRestoreToRestoring() {
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet()).anyTimes();
        this.t2.initializeMetadata();
        EasyMock.expect((Object)this.t2.initializeStateStores()).andReturn((Object)true);
        this.t2.initializeTopology();
        EasyMock.expectLastCall().once();
        Set<TopicPartition> t2partitions = Collections.singleton(this.tp2);
        EasyMock.expect((Object)this.t2.partitions()).andReturn(t2partitions).anyTimes();
        EasyMock.expect((Object)this.t2.changelogPartitions()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.t1, this.t2});
        this.assignedTasks.addNewTask((Task)this.t1);
        this.assignedTasks.addNewTask((Task)this.t2);
        this.assignedTasks.initializeNewTasks();
        Collection restoring = this.assignedTasks.restoringTasks();
        MatcherAssert.assertThat((Object)restoring.size(), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertSame(restoring.iterator().next(), (Object)this.t1);
    }

    @Test
    public void shouldMoveInitializedTasksThatDontNeedRestoringToRunning() {
        this.t2.initializeMetadata();
        EasyMock.expect((Object)this.t2.initializeStateStores()).andReturn((Object)true);
        this.t2.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t2.partitions()).andReturn(Collections.singleton(this.tp2)).anyTimes();
        EasyMock.expect((Object)this.t2.changelogPartitions()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.t2});
        this.assignedTasks.addNewTask((Task)this.t2);
        this.assignedTasks.initializeNewTasks();
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId2)));
    }

    @Test
    public void shouldTransitionFullyRestoredTasksToRunning() {
        Set task1Partitions = Utils.mkSet((Object[])new TopicPartition[]{this.tp1});
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn((Object)task1Partitions).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn((Object)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog1, this.changeLog2})).anyTimes();
        EasyMock.expect((Object)this.t1.hasStateStores()).andReturn((Object)true).anyTimes();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.assignedTasks.updateRestored((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog1}));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.emptySet()));
        this.assignedTasks.updateRestored((Collection)Utils.mkSet((Object[])new TopicPartition[]{this.changeLog2}));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
    }

    @Test
    public void shouldSuspendRunningTasks() {
        this.mockRunningTaskSuspension();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.assignedTasks.suspendedTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseRestoringTasks() {
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)false);
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptySet()).anyTimes();
        this.t1.closeStateManager(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.closeRestoringTasks(this.assignedTasks.restoringTaskIds(), this.revokedChangelogs), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseUnInitializedTasksOnSuspend() {
        EasyMock.expect((Object)this.t1.partitions()).andAnswer(Collections::emptySet).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andAnswer(Collections::emptyList).anyTimes();
        this.t1.close(false, false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.assignedTasks.addNewTask((Task)this.t1);
        MatcherAssert.assertThat((Object)this.assignedTasks.suspendOrCloseTasks(this.assignedTasks.allAssignedTaskIds(), this.revokedChangelogs), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotSuspendSuspendedTasks() {
        this.mockRunningTaskSuspension();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.assignedTasks.suspendOrCloseTasks(this.assignedTasks.allAssignedTaskIds(), this.revokedChangelogs), (Matcher)CoreMatchers.nullValue());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnSuspendWhenRuntimeException() {
        this.mockTaskInitialization();
        this.t1.suspend();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("KABOOM!"));
        this.t1.close(false, false);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertTrue((boolean)this.assignedTasks.runningTaskIds().isEmpty());
        Assert.assertTrue((boolean)this.assignedTasks.suspendedTaskIds().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseTaskOnSuspendIfTaskMigratedException() {
        this.mockTaskInitialization();
        this.t1.suspend();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("any exception"));
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)this.assignedTasks.runningTaskIds().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseUncleanAndThenRethrowOnShutdownIfRuntimeException() {
        this.mockTaskInitialization();
        this.t1.close(true, false);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("any first exception"));
        this.t1.close(false, false);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("any second exception"));
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.shutdown(true);
            Assert.fail((String)"expected a runtime exception");
        }
        catch (RuntimeException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"any first exception"));
        }
    }

    @Test
    public void shouldCloseWithoutExceptionOnShutdownIfTaskMigratedException() {
        this.mockTaskInitialization();
        this.t1.close(true, false);
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        this.t1.close(false, true);
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("any second exception"));
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.assignedTasks.shutdown(true);
    }

    @Test
    public void shouldResumeMatchingSuspendedTasks() {
        this.mockRunningTaskSuspension();
        this.t1.resume();
        EasyMock.expectLastCall();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        Assert.assertTrue((boolean)this.assignedTasks.maybeResumeSuspendedTask(this.taskId1, Collections.singleton(this.tp1)));
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotCloseTaskWithinResumeSuspendedIfTaskMigratedException() {
        this.mockRunningTaskSuspension();
        this.t1.resume();
        this.t1.initializeTopology();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        MatcherAssert.assertThat((Object)this.suspendTask(), (Matcher)CoreMatchers.nullValue());
        this.verifyTaskMigratedExceptionDoesNotCloseTask(() -> this.assignedTasks.maybeResumeSuspendedTask(this.taskId1, Collections.singleton(this.tp1)));
    }

    private void mockTaskInitialization() {
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)true);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptyList()).anyTimes();
    }

    @Test
    public void shouldCommitRunningTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.assignedTasks.commit();
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotCloseTaskWithinCommitIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.verifyTaskMigratedExceptionDoesNotCloseTask(() -> this.assignedTasks.commit());
    }

    @Test
    public void shouldThrowExceptionOnCommitWhenNotCommitFailedOrProducerFenced() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException(""));
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.commit();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCommitRunningTasksIfNeeded() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitRequested()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.maybeCommitPerUserRequested(), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotCloseTaskWithinMaybeCommitIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.commitRequested()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.commitNeeded()).andReturn((Object)true);
        this.t1.commit();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.verifyTaskMigratedExceptionDoesNotCloseTask(() -> this.assignedTasks.maybeCommitPerUserRequested());
    }

    @Test
    public void shouldNotCloseTaskWithinProcessIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)true);
        this.t1.process();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.verifyTaskMigratedExceptionDoesNotCloseTask(() -> this.assignedTasks.process(0L));
    }

    @Test
    public void shouldNotProcessUnprocessableTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.process(0L), (Matcher)IsEqual.equalTo((Object)0));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldAlwaysProcessProcessableTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.isProcessable(0L)).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.process()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.process(0L), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldPunctuateRunningTasks() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.maybePunctuateSystemTime()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.punctuate(), (Matcher)IsEqual.equalTo((Object)2));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldNotCloseTaskWithinMaybePunctuateStreamTimeIfTaskMigratedException() {
        this.mockTaskInitialization();
        this.t1.maybePunctuateStreamTime();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        this.verifyTaskMigratedExceptionDoesNotCloseTask(() -> this.assignedTasks.punctuate());
    }

    @Test
    public void shouldNotloseTaskWithinMaybePunctuateSystemTimeIfTaskMigratedException() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        this.t1.maybePunctuateSystemTime();
        EasyMock.expectLastCall().andThrow((Throwable)new TaskMigratedException());
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        try {
            this.assignedTasks.punctuate();
            Assert.fail((String)"Should have thrown TaskMigratedException.");
        }
        catch (TaskMigratedException expected) {
            MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(Collections.singleton(this.taskId1)));
        }
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldReturnNumberOfPunctuations() {
        this.mockTaskInitialization();
        EasyMock.expect((Object)this.t1.maybePunctuateStreamTime()).andReturn((Object)true);
        EasyMock.expect((Object)this.t1.maybePunctuateSystemTime()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.t1});
        this.addAndInitTask();
        MatcherAssert.assertThat((Object)this.assignedTasks.punctuate(), (Matcher)IsEqual.equalTo((Object)1));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    @Test
    public void shouldCloseCleanlyWithSuspendedTaskAndEOS() {
        String topic = "topic";
        Deserializer deserializer = Serdes.ByteArray().deserializer();
        Serializer serializer = Serdes.ByteArray().serializer();
        MockConsumer consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        MockProducer producer = new MockProducer(false, serializer, serializer);
        MockSourceNode source = new MockSourceNode(new String[]{"topic"}, deserializer, deserializer);
        MockChangelogReader changelogReader = new MockChangelogReader();
        ProcessorTopology topology = new ProcessorTopology(Collections.singletonList(source), Collections.singletonMap("topic", source), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptySet());
        Set<TopicPartition> partitions = Collections.singleton(new TopicPartition("topic", 1));
        Metrics metrics = new Metrics(new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG));
        MockStreamsMetrics streamsMetrics = new MockStreamsMetrics(metrics);
        MockTime time = new MockTime();
        StateDirectory stateDirectory = new StateDirectory(StreamTaskTest.createConfig(true), (Time)time, true);
        StreamTask task = new StreamTask(new TaskId(0, 0), partitions, topology, (Consumer)consumer, (ChangelogReader)changelogReader, StreamTaskTest.createConfig(true), (StreamsMetricsImpl)streamsMetrics, stateDirectory, null, (Time)time, () -> producer);
        this.assignedTasks.addNewTask((Task)task);
        this.assignedTasks.initializeNewTasks();
        Assert.assertNull((Object)this.assignedTasks.suspendOrCloseTasks(this.assignedTasks.allAssignedTaskIds(), this.revokedChangelogs));
        this.assignedTasks.shutdown(true);
    }

    @Test
    public void shouldClearZombieCreatedTasks() {
        new TaskTestSuite(){

            @Override
            public void additionalSetup(StreamTask task) {
                task.close(false, true);
            }

            @Override
            public void action(StreamTask task) {
                AssignedStreamsTasksTest.this.assignedTasks.addNewTask((Task)task);
            }

            @Override
            public Set<TaskId> taskIds() {
                return ((AssignedStreamsTasksTest)AssignedStreamsTasksTest.this).assignedTasks.created.keySet();
            }
        }.createTaskAndClear();
    }

    @Test
    public void shouldClearZombieRestoringTasks() {
        new TaskTestSuite(){

            @Override
            public void additionalSetup(StreamTask task) {
                task.closeStateManager(false);
            }

            @Override
            public void action(StreamTask task) {
                AssignedStreamsTasksTest.this.assignedTasks.addTaskToRestoring(task);
            }

            @Override
            public Set<TaskId> taskIds() {
                return AssignedStreamsTasksTest.this.assignedTasks.restoringTaskIds();
            }
        }.createTaskAndClear();
    }

    @Test
    public void shouldClearZombieRunningTasks() {
        new TaskTestSuite(){

            @Override
            public void additionalSetup(StreamTask task) {
                task.initializeTopology();
                task.close(false, true);
            }

            @Override
            public void action(StreamTask task) {
                AssignedStreamsTasksTest.this.assignedTasks.transitionToRunning((Task)task);
            }

            @Override
            public Set<TaskId> taskIds() {
                return AssignedStreamsTasksTest.this.assignedTasks.runningTaskIds();
            }
        }.createTaskAndClear();
    }

    @Test
    public void shouldClearZombieSuspendedTasks() {
        new TaskTestSuite(){

            @Override
            public void additionalSetup(StreamTask task) {
                task.initializeTopology();
                task.suspend();
                task.closeSuspended(false, null);
            }

            @Override
            public void action(StreamTask task) {
                AssignedStreamsTasksTest.this.assignedTasks.transitionToRunning((Task)task);
                ArrayList revokedChangelogs = new ArrayList();
                List<TaskId> ids = Collections.singletonList(task.id());
                AssignedStreamsTasksTest.this.assignedTasks.suspendOrCloseTasks(new HashSet<TaskId>(ids), revokedChangelogs);
                Assert.assertEquals((Object)this.clearingPartitions, revokedChangelogs);
            }

            @Override
            public Set<TaskId> taskIds() {
                return AssignedStreamsTasksTest.this.assignedTasks.suspendedTaskIds();
            }
        }.createTaskAndClear();
    }

    private void addAndInitTask() {
        this.assignedTasks.addNewTask((Task)this.t1);
        this.assignedTasks.initializeNewTasks();
    }

    private RuntimeException suspendTask() {
        this.addAndInitTask();
        return this.assignedTasks.suspendOrCloseTasks(this.assignedTasks.allAssignedTaskIds(), this.revokedChangelogs);
    }

    private void mockRunningTaskSuspension() {
        this.t1.initializeMetadata();
        EasyMock.expect((Object)this.t1.initializeStateStores()).andReturn((Object)true);
        this.t1.initializeTopology();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.t1.hasStateStores()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.t1.partitions()).andReturn(Collections.singleton(this.tp1)).anyTimes();
        EasyMock.expect((Object)this.t1.changelogPartitions()).andReturn(Collections.emptyList()).anyTimes();
        this.t1.suspend();
        EasyMock.expectLastCall();
    }

    private void verifyTaskMigratedExceptionDoesNotCloseTask(ThrowingRunnable action) {
        Set<TaskId> expectedRunningTaskIds = Collections.singleton(this.taskId1);
        Assert.assertThrows(TaskMigratedException.class, (ThrowingRunnable)action);
        MatcherAssert.assertThat((Object)this.assignedTasks.runningTaskIds(), (Matcher)IsEqual.equalTo(expectedRunningTaskIds));
        EasyMock.verify((Object[])new Object[]{this.t1});
    }

    abstract class TaskTestSuite {
        TaskId clearingTaskId = new TaskId(0, 0);
        List<TopicPartition> clearingPartitions = Collections.singletonList(new TopicPartition("topic", 0));

        TaskTestSuite() {
        }

        abstract void additionalSetup(StreamTask var1);

        abstract void action(StreamTask var1);

        abstract Set<TaskId> taskIds();

        void createTaskAndClear() {
            StreamTask task = (StreamTask)EasyMock.createMock(StreamTask.class);
            EasyMock.expect((Object)task.id()).andReturn((Object)this.clearingTaskId).anyTimes();
            EasyMock.expect((Object)task.partitions()).andReturn(Collections.emptySet()).anyTimes();
            EasyMock.expect((Object)task.changelogPartitions()).andReturn(this.clearingPartitions).anyTimes();
            EasyMock.expect((Object)task.toString(EasyMock.anyString())).andReturn((Object)"task").anyTimes();
            this.additionalSetup(task);
            EasyMock.replay((Object[])new Object[]{task});
            this.action(task);
            HashSet<TaskId> ids = new HashSet<TaskId>(Collections.singleton(task.id()));
            Assert.assertEquals(ids, this.taskIds());
            AssignedStreamsTasksTest.this.assignedTasks.closeAllTasksAsZombies();
            Assert.assertEquals(Collections.emptySet(), this.taskIds());
        }
    }
}

