/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class StoreQueryIntegrationTest {
    private static final int NUM_BROKERS = 1;
    private static int port = 0;
    private static final String INPUT_TOPIC_NAME = "input-topic";
    private static final String TABLE_NAME = "source-table";
    @Rule
    public final EmbeddedKafkaCluster cluster = new EmbeddedKafkaCluster(1);
    private final List<KafkaStreams> streamsToCleanup = new ArrayList<KafkaStreams>();
    private final MockTime mockTime;

    public StoreQueryIntegrationTest() {
        this.mockTime = this.cluster.time;
    }

    @Before
    public void before() throws InterruptedException {
        this.cluster.createTopic(INPUT_TOPIC_NAME, 2, 1);
    }

    @After
    public void after() {
        for (KafkaStreams kafkaStreams : this.streamsToCleanup) {
            kafkaStreams.close();
        }
    }

    @Test
    public void shouldQueryOnlyActivePartitionStoresByDefault() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
        this.produceValueRange(1, 0, 100);
        MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        KeyQueryMetadata keyQueryMetadata = kafkaStreams1.queryMetadataForKey(TABLE_NAME, (Object)1, (topic, somekey, value, numPartitions) -> 0);
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        ReadOnlyKeyValueStore store1 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType));
        ReadOnlyKeyValueStore store2 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType));
        boolean kafkaStreams1IsActive = keyQueryMetadata.getActiveHost().port() % 2 == 1;
        MatcherAssert.assertThat((Object)(kafkaStreams1IsActive ? (Integer)store1.get((Object)1) : (Integer)store2.get((Object)1)), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)(kafkaStreams1IsActive ? (Integer)store2.get((Object)1) : (Integer)store1.get((Object)1)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldQuerySpecificActivePartitionStores() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
        this.produceValueRange(1, 0, 100);
        MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        KeyQueryMetadata keyQueryMetadata = kafkaStreams1.queryMetadataForKey(TABLE_NAME, (Object)1, (topic, somekey, value, numPartitions) -> 0);
        int keyPartition = keyQueryMetadata.getPartition();
        int keyDontBelongPartition = keyPartition == 0 ? 1 : 0;
        boolean kafkaStreams1IsActive = keyQueryMetadata.getActiveHost().port() % 2 == 1;
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        ReadOnlyKeyValueStore store1 = null;
        ReadOnlyKeyValueStore store2 = null;
        if (kafkaStreams1IsActive) {
            store1 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).withPartition(Integer.valueOf(keyPartition)));
        } else {
            store2 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).withPartition(Integer.valueOf(keyPartition)));
        }
        if (kafkaStreams1IsActive) {
            MatcherAssert.assertThat((Object)store1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)store2, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)store2, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)store1, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        MatcherAssert.assertThat((Object)(kafkaStreams1IsActive ? (Integer)store1.get((Object)1) : (Integer)store2.get((Object)1)), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ReadOnlyKeyValueStore store3 = null;
        ReadOnlyKeyValueStore store4 = null;
        if (!kafkaStreams1IsActive) {
            store3 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).withPartition(Integer.valueOf(keyDontBelongPartition)));
        } else {
            store4 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).withPartition(Integer.valueOf(keyDontBelongPartition)));
        }
        MatcherAssert.assertThat((Object)(kafkaStreams1IsActive ? (Integer)store4.get((Object)1) : (Integer)store3.get((Object)1)), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldQueryAllStalePartitionStores() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
        this.produceValueRange(1, 0, 100);
        MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store1 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores());
            return store1.get((Object)1) != null;
        }, (String)"store1 cannot find results for key");
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store2 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores());
            return store2.get((Object)1) != null;
        }, (String)"store2 cannot find results for key");
    }

    @Test
    public void shouldQuerySpecificStalePartitionStores() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, this.streamsConfiguration());
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, this.streamsConfiguration());
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
        this.produceValueRange(1, 0, 100);
        MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        KeyQueryMetadata keyQueryMetadata = kafkaStreams1.queryMetadataForKey(TABLE_NAME, (Object)1, (topic, somekey, value, numPartitions) -> 0);
        int keyPartition = keyQueryMetadata.getPartition();
        int keyDontBelongPartition = keyPartition == 0 ? 1 : 0;
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store1 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyPartition)));
            return store1.get((Object)1) != null;
        }, (String)"store1 cannot find results for key");
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store2 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyPartition)));
            return store2.get((Object)1) != null;
        }, (String)"store2 cannot find results for key");
        ReadOnlyKeyValueStore store3 = (ReadOnlyKeyValueStore)kafkaStreams1.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyDontBelongPartition)));
        ReadOnlyKeyValueStore store4 = (ReadOnlyKeyValueStore)kafkaStreams2.store(StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyDontBelongPartition)));
        MatcherAssert.assertThat((Object)store3.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)store4.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldQuerySpecificStalePartitionStoresMultiStreamThreads() throws Exception {
        int batch1NumMessages = 100;
        boolean key = true;
        Semaphore semaphore = new Semaphore(0);
        int numStreamThreads = 2;
        StreamsBuilder builder = new StreamsBuilder();
        builder.table(INPUT_TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()), Materialized.as((String)TABLE_NAME).withCachingDisabled()).toStream().peek((k, v) -> semaphore.release());
        Properties streamsConfiguration1 = this.streamsConfiguration();
        streamsConfiguration1.put("num.stream.threads", (Object)2);
        Properties streamsConfiguration2 = this.streamsConfiguration();
        streamsConfiguration2.put("num.stream.threads", (Object)2);
        KafkaStreams kafkaStreams1 = this.createKafkaStreams(builder, streamsConfiguration1);
        KafkaStreams kafkaStreams2 = this.createKafkaStreams(builder, streamsConfiguration2);
        List<KafkaStreams> kafkaStreamsList = Arrays.asList(kafkaStreams1, kafkaStreams2);
        IntegrationTestUtils.startApplicationAndWaitUntilRunning(kafkaStreamsList, Duration.ofSeconds(60L));
        Assert.assertTrue((kafkaStreams1.localThreadsMetadata().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((kafkaStreams2.localThreadsMetadata().size() > 1 ? 1 : 0) != 0);
        this.produceValueRange(1, 0, 100);
        MatcherAssert.assertThat((Object)semaphore.tryAcquire(100, 60L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)true)));
        KeyQueryMetadata keyQueryMetadata = kafkaStreams1.queryMetadataForKey(TABLE_NAME, (Object)1, (Serializer)new IntegerSerializer());
        int keyPartition = keyQueryMetadata.getPartition();
        int keyDontBelongPartition = keyPartition == 0 ? 1 : 0;
        QueryableStoreType queryableStoreType = QueryableStoreTypes.keyValueStore();
        StoreQueryParameters param = StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyPartition));
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store1 = (ReadOnlyKeyValueStore)kafkaStreams1.store(param);
            return store1.get((Object)1) != null;
        }, (String)"store1 cannot find results for key");
        TestUtils.waitForCondition(() -> {
            ReadOnlyKeyValueStore store2 = (ReadOnlyKeyValueStore)kafkaStreams2.store(param);
            return store2.get((Object)1) != null;
        }, (String)"store2 cannot find results for key");
        StoreQueryParameters otherParam = StoreQueryParameters.fromNameAndType((String)TABLE_NAME, (QueryableStoreType)queryableStoreType).enableStaleStores().withPartition(Integer.valueOf(keyDontBelongPartition));
        ReadOnlyKeyValueStore store3 = (ReadOnlyKeyValueStore)kafkaStreams1.store(otherParam);
        ReadOnlyKeyValueStore store4 = (ReadOnlyKeyValueStore)kafkaStreams2.store(otherParam);
        MatcherAssert.assertThat((Object)store3.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)store4.get((Object)1), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private KafkaStreams createKafkaStreams(StreamsBuilder builder, Properties config) {
        KafkaStreams streams = new KafkaStreams(builder.build(config), config);
        this.streamsToCleanup.add(streams);
        return streams;
    }

    private void produceValueRange(int key, int start, int endExclusive) throws Exception {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.cluster.bootstrapServers());
        producerProps.put("key.serializer", IntegerSerializer.class);
        producerProps.put("value.serializer", IntegerSerializer.class);
        IntegrationTestUtils.produceKeyValuesSynchronously(INPUT_TOPIC_NAME, IntStream.range(start, endExclusive).mapToObj(i -> KeyValue.pair((Object)key, (Object)i)).collect(Collectors.toList()), producerProps, (Time)this.mockTime);
    }

    private Properties streamsConfiguration() {
        String applicationId = "streamsApp";
        Properties config = new Properties();
        config.put("topology.optimization", "all");
        config.put("application.id", "streamsApp");
        config.put("application.server", "localhost:" + String.valueOf(++port));
        config.put("bootstrap.servers", this.cluster.bootstrapServers());
        config.put("state.dir", TestUtils.tempDirectory((String)"streamsApp").getPath());
        config.put("default.key.serde", Serdes.Integer().getClass());
        config.put("default.value.serde", Serdes.Integer().getClass());
        config.put("num.standby.replicas", (Object)1);
        config.put("max.poll.records", (Object)100);
        config.put("heartbeat.interval.ms", (Object)200);
        config.put("session.timeout.ms", (Object)1000);
        config.put("commit.interval.ms", (Object)100);
        return config;
    }
}

