/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.tests.SmokeTestClient;
import org.apache.kafka.streams.tests.SmokeTestDriver;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class SmokeTestDriverIntegrationTest {
    @ClassRule
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldWorkWithRebalance() throws InterruptedException {
        int numClientsCreated = 0;
        ArrayList<SmokeTestClient> clients = new ArrayList<SmokeTestClient>();
        IntegrationTestUtils.cleanStateBeforeTest(CLUSTER, SmokeTestDriver.topics());
        String bootstrapServers = CLUSTER.bootstrapServers();
        Driver driver = new Driver(bootstrapServers, 10, 1000);
        driver.start();
        System.out.println("started driver");
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        while (driver.isAlive()) {
            Thread.sleep(1000L);
            SmokeTestClient smokeTestClient = new SmokeTestClient("streams-" + numClientsCreated++);
            clients.add(smokeTestClient);
            smokeTestClient.start(props);
            while (!((SmokeTestClient)clients.get(clients.size() - 1)).started()) {
                Thread.sleep(100L);
            }
            if (clients.size() < 3) continue;
            SmokeTestClient client = (SmokeTestClient)clients.remove(0);
            client.closeAsync();
            while (!client.closed()) {
                Thread.sleep(100L);
            }
        }
        try {
            driver.join();
        }
        finally {
            for (SmokeTestClient client : clients) {
                client.closeAsync();
            }
            for (SmokeTestClient client : clients) {
                while (!client.closed()) {
                    Thread.sleep(100L);
                }
            }
        }
        if (driver.exception() != null) {
            driver.exception().printStackTrace();
            throw new AssertionError((Object)driver.exception());
        }
        Assert.assertTrue((String)driver.result().result(), (boolean)driver.result().passed());
    }

    private static class Driver
    extends Thread {
        private String bootstrapServers;
        private int numKeys;
        private int maxRecordsPerKey;
        private Exception exception = null;
        private SmokeTestDriver.VerificationResult result;

        private Driver(String bootstrapServers, int numKeys, int maxRecordsPerKey) {
            this.bootstrapServers = bootstrapServers;
            this.numKeys = numKeys;
            this.maxRecordsPerKey = maxRecordsPerKey;
        }

        @Override
        public void run() {
            try {
                Map<String, Set<Integer>> allData = SmokeTestDriver.generate(this.bootstrapServers, this.numKeys, this.maxRecordsPerKey, Duration.ofSeconds(20L));
                this.result = SmokeTestDriver.verify(this.bootstrapServers, allData, this.maxRecordsPerKey);
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception exception() {
            return this.exception;
        }

        SmokeTestDriver.VerificationResult result() {
            return this.result;
        }
    }
}

