/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class StoreChangeLoggerTest {
    private final String topic = "topic";
    private final MockRecordCollector collector = new MockRecordCollector();
    private final InternalMockProcessorContext context = new InternalMockProcessorContext(StateSerdes.withBuiltinTypes((String)"topic", Integer.class, String.class), this.collector);
    private final StoreChangeLogger<Integer, String> changeLogger = new StoreChangeLogger("topic", (ProcessorContext)this.context, StateSerdes.withBuiltinTypes((String)"topic", Integer.class, String.class));

    @Test
    public void testAddRemove() {
        this.context.setTime(1L);
        this.changeLogger.logChange((Object)0, (Object)"zero");
        this.context.setTime(5L);
        this.changeLogger.logChange((Object)1, (Object)"one");
        this.changeLogger.logChange((Object)2, (Object)"two");
        this.changeLogger.logChange((Object)3, (Object)"three", 42L);
        this.context.setTime(9L);
        this.changeLogger.logChange((Object)0, null);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)"zero"));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.equalTo((Object)"one"));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).timestamp(), (Matcher)CoreMatchers.equalTo((Object)5L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(2).key(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(2).value(), (Matcher)CoreMatchers.equalTo((Object)"two"));
        MatcherAssert.assertThat((Object)this.collector.collected().get(2).timestamp(), (Matcher)CoreMatchers.equalTo((Object)5L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(3).key(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)this.collector.collected().get(3).value(), (Matcher)CoreMatchers.equalTo((Object)"three"));
        MatcherAssert.assertThat((Object)this.collector.collected().get(3).timestamp(), (Matcher)CoreMatchers.equalTo((Object)42L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(4).key(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.collector.collected().get(4).value(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)this.collector.collected().get(4).timestamp(), (Matcher)CoreMatchers.equalTo((Object)9L));
    }

    @Test
    public void shouldNotSendRecordHeadersToChangelogTopic() {
        this.context.headers().add((Header)new RecordHeader("key", "value".getBytes()));
        this.changeLogger.logChange((Object)0, (Object)"zero", 42L);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)"zero"));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).timestamp(), (Matcher)CoreMatchers.equalTo((Object)42L));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).headers().toArray(), (Matcher)CoreMatchers.equalTo((Object)Record.EMPTY_HEADERS));
    }
}

